/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotCurrentWork
extends OutlineFilterDescriptor {
    private static final String ID = "FILTER_NOT_CURRENT_WORK";

    public NotCurrentWork() {
        super(ID, Messages.NotCurrentWork_LABEL, Messages.NotCurrentWork_DESCRIPTION);
    }

    @Override
    public boolean select(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        if (!EntryUtils.isType(entry, PlanItem.class)) {
            return true;
        }
        PlanItem item = (PlanItem)entry.getElement();
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(item.getPlan().getReferenceTime());
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        startDate.add(3, -1);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(3, 2);
        Timespan scheduledTime = item.getScheduledTime();
        return scheduledTime != null && scheduledTime.getEnd().getTime() > startDate.getTimeInMillis() && scheduledTime.getStart().getTime() < endDate.getTimeInMillis();
    }

    @Override
    public boolean isFilterType(OutlineFilterDescriptor.FilterType filterType) {
        return filterType == OutlineFilterDescriptor.FilterType.REGULAR;
    }

    @Override
    public boolean isFilterProperty(OutlineEntry<?> entry, String property) {
        return PlanItem.SCHEDULED_TIME.getName().equals(property);
    }
}

