/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.HierarchicalItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElementProgressUpdater;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.ProgressModeSettingListener;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressAwarePlanModelTransformer;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class GroupByOwnerDescription
extends GroupByDescription {
    public static final String ID = "OWNER";

    public GroupByOwnerDescription() {
        super(ID, Messages.GroupByOwnerDescription_LABEL);
    }

    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new OwnerGroupingTransformer();
    }

    protected ItemMovePolicy createItemMovePolicy() {
        return new OwnerGroupingItemMovePolicy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OwnerGroupingItemMovePolicy
    extends HierarchicalItemMovePolicy {
        private OwnerGroupingItemMovePolicy() {
        }

        @Override
        public boolean canMoveUp(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveUp(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    return !n.isFirst(n.parentEntry(entry));
                }
            });
        }

        @Override
        public boolean canMoveDown(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveDown(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                        return false;
                    }
                    return !n.isLast(n.parentEntry(entry));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OwnerGroupingTransformer
    extends ProgressAwarePlanModelTransformer<OwnerElement> {
        private ProgressModeSettingListener fSettingsListener;

        public OwnerGroupingTransformer() {
            super((Collection<Attribute>)Arrays.asList(PlanItem.OWNER, PlanItem.PRIMARY_ITEM));
            this.setProgressUpdater(new OwnerElementProgressUpdater(this));
            this.fSettingsListener = new ProgressModeSettingListener(this);
        }

        @Override
        public void inputChanged(PlanViewModel newModel, ResolvedPlan newInput) {
            PlanViewModel oldModel = this.getViewModel();
            if (oldModel != null) {
                ((IPlanOutlineSettings)oldModel.getOutlineSettings()).removeSettingsChangeListener(this.fSettingsListener);
            }
            if (newModel != null) {
                ((IPlanOutlineSettings)newModel.getOutlineSettings()).addSettingsChangeListener(this.fSettingsListener);
            }
            super.inputChanged(newModel, newInput);
        }

        @Override
        protected Collection<GroupElement[]> getDefaultGroups() {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            ItemCollection owners = plan.getTeamMembers();
            ArrayList<GroupElement[]> result = new ArrayList<GroupElement[]>(owners.size());
            for (IContributor owner : owners) {
                if (owner.isArchived()) continue;
                result.add(new OwnerElement[]{new OwnerElement((ResolvedPlan)plan, owner)});
            }
            result.add(new OwnerElement[]{new OwnerElement((ResolvedPlan)plan, this.getPlan().getNullOwner())});
            return result;
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            ItemHashMap resultMap = new ItemHashMap();
            for (PlanModelTransformer.ElementInfo elementInfo : elementInfoPath) {
                IContributor owner;
                if (!this.isPrimaryItem(elementInfo) || resultMap.containsKey((IItemHandle)(owner = this.getOwner(elementInfo)))) continue;
                resultMap.put((IItemHandle)owner, (Object)this.getGroupElements(owner));
            }
            return resultMap.values().toCollection();
        }

        @Override
        protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            PlanModelTransformer.ElementInfo elementInfo = elementInfoPath.get(0);
            return this.isPrimaryItem(elementInfo) && Arrays.equals(groupPath, this.getGroupElements(this.getOwner(elementInfo))) ? DEFAULT_TAGS : NO_TAGS;
        }

        @Override
        public LocationMarker calculateLocationMarker(OutlineEntry<?> entry) {
            LocationMarker result = super.calculateLocationMarker(entry);
            if (result == null && EntryUtils.isType(entry, PlanItem.class) && !entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                PlanItem planItem = (PlanItem)entry.getElement();
                result = new SecondaryLocationMarker(NLS.bind((String)Messages.GroupByOwnerDescription_BELONGS_TO_OTHER_OWNER, (Object[])new Object[]{planItem.getOwner().getName()}));
            }
            return result;
        }

        private IContributor getOwner(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[0] instanceof IContributor ? 1 : 0) != 0);
            return (IContributor)structureValues[0];
        }

        private GroupElement[] getGroupElements(IContributor owner) {
            return new GroupElement[]{new OwnerElement(this.getPlan(), owner)};
        }

        private boolean isPrimaryItem(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[1] instanceof Boolean ? 1 : 0) != 0);
            return (Boolean)structureValues[1];
        }

        private IPlanOutlineSettings getSettings() {
            return (IPlanOutlineSettings)this.getViewModel().getOutlineSettings();
        }
    }
}

