/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.CategoryElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.DefaultRootElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.HierarchicalItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressAwarePlanModelTransformer;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class GroupByCategoryDescription
extends GroupByDescription {
    public static final String ID = "CATEGORIES";

    public GroupByCategoryDescription() {
        super(ID, Messages.GroupByCategoryDescription_LABEL);
    }

    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new CategoryGroupingTransformer();
    }

    protected ItemMovePolicy createItemMovePolicy() {
        return new CategoryGroupingItemMovePolicy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryGroupingItemMovePolicy
    extends HierarchicalItemMovePolicy {
        private CategoryGroupingItemMovePolicy() {
        }

        @Override
        public boolean canMoveUp(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (n.parentElement(entry) instanceof GroupElement && n.parentElement(entry, 2) == DefaultRootElement.INSTANCE && n.isFirst(entry)) {
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        public boolean canMoveDown(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveDown(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                        return false;
                    }
                    OutlineEntry<?> candidate = n.parentEntry(entry);
                    while (candidate != null) {
                        if (EntryUtils.isType(candidate, GroupElement.class) && n.parentElement(candidate) == null) break;
                        if (!n.isLast(candidate)) {
                            return true;
                        }
                        candidate = n.parentEntry(candidate);
                    }
                    return false;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryGroupingTransformer
    extends ProgressAwarePlanModelTransformer<CategoryElement> {
        private final ItemMap<ICategory, GroupElement[]> fGroupPaths = new ItemHashMap();
        private final List<GroupElement[]> fDefaultGroups = new ArrayList<GroupElement[]>();

        public CategoryGroupingTransformer() {
            super((Collection<Attribute>)Arrays.asList(PlanItem.CATEGORY, PlanItem.PRIMARY_ITEM), CategoryElement.class);
        }

        @Override
        protected void onBeginRefresh() {
            ResolvedPlan plan = this.getPlan();
            this.fGroupPaths.clear();
            ArrayList categories = new ArrayList(plan.getCategories().toCollection());
            Categories.sort(categories);
            Stack<CategoryElement> categoryStack = new Stack<CategoryElement>();
            for (ICategory category : categories) {
                String categoryId = category.getCategoryId().getInternalRepresentation();
                while (!categoryStack.isEmpty() && !categoryId.startsWith(((CategoryElement)categoryStack.peek()).getCategory().getCategoryId().getInternalRepresentation())) {
                    categoryStack.pop();
                }
                categoryStack.push(new CategoryElement(category));
                GroupElement[] groupPath = new GroupElement[categoryStack.size() + 1];
                int i = 1;
                while (i < groupPath.length) {
                    groupPath[i] = (GroupElement)categoryStack.elementAt(i - 1);
                    ++i;
                }
                GroupElement[] elements = categoryStack.toArray(new GroupElement[categoryStack.size()]);
                this.fGroupPaths.put((IItemHandle)category, (Object)elements);
                if (category.isArchived()) continue;
                this.fDefaultGroups.add(elements);
            }
            super.onBeginRefresh();
        }

        @Override
        protected Collection<GroupElement[]> getDefaultGroups() {
            return this.fDefaultGroups;
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            ItemHashMap resultMap = new ItemHashMap();
            for (PlanModelTransformer.ElementInfo elementInfo : elementInfoPath) {
                ICategory category;
                if (!this.isPrimaryItem(elementInfo) || resultMap.containsKey((IItemHandle)(category = this.getCategory(elementInfo)))) continue;
                resultMap.put((IItemHandle)category, (Object)this.getGroupElements(category));
            }
            return resultMap.values().toCollection();
        }

        @Override
        protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            PlanModelTransformer.ElementInfo elementInfo = elementInfoPath.get(0);
            return this.isPrimaryItem(elementInfo) && Arrays.equals(groupPath, this.getGroupElements(this.getCategory(elementInfo))) ? DEFAULT_TAGS : NO_TAGS;
        }

        @Override
        public LocationMarker calculateLocationMarker(OutlineEntry<?> entry) {
            LocationMarker result = super.calculateLocationMarker(entry);
            if (result == null && EntryUtils.isType(entry, PlanItem.class) && !entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                PlanItem planItem = (PlanItem)entry.getElement();
                result = new SecondaryLocationMarker(NLS.bind((String)Messages.GroupByCategoryDescription_BELONGS_TO_OTHER_CATEGORY, (Object[])new Object[]{planItem.getCategory().getName()}));
            }
            return result;
        }

        @Override
        public List<OutlineEntry<?>> getElementsToExpandInitially() {
            return (List)this.getViewModel().readModel(new ModelReadRunnable<List<OutlineEntry<?>>, RuntimeException>(){

                @Override
                public List<OutlineEntry<?>> run(IOutlineModelReader reader) {
                    List<OutlineEntry<?>> rootEntries = reader.getChildren(reader.getRootEntry());
                    ArrayList result = new ArrayList(rootEntries);
                    for (OutlineEntry<?> rootEntry : rootEntries) {
                        for (OutlineEntry<?> childEntry : reader.getChildren(rootEntry)) {
                            if (!EntryUtils.isType(childEntry, CategoryElement.class)) continue;
                            result.add(childEntry);
                        }
                    }
                    return result;
                }
            });
        }

        private ICategory getCategory(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[0] instanceof ICategory ? 1 : 0) != 0);
            return (ICategory)structureValues[0];
        }

        private boolean isPrimaryItem(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[1] instanceof Boolean ? 1 : 0) != 0);
            return (Boolean)structureValues[1];
        }

        private GroupElement[] getGroupElements(ICategory category) {
            GroupElement[] groupElements = (GroupElement[])this.fGroupPaths.get((IItemHandle)category);
            if (groupElements == null) {
                groupElements = new GroupElement[]{new CategoryElement(category)};
            }
            return groupElements;
        }
    }
}

