/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class StatusComposite
extends Composite {
    public static final String ID = "com.ibm.team.apt.internal.IterationPlanEditor.LoadingPage";
    private Label fImage;
    private Label fTitleMessage;
    private Text fException;
    private Link fMessageLink;

    public StatusComposite(Composite parent, int style) {
        super(parent, style);
        this.setFont(parent.getFont());
        this.setBackground(parent.getBackground());
    }

    public void setStatus(IStatus status) {
        this.createContent(MessageKind.EXCEPTION);
        this.doSetStatus(status);
        Throwable exception = status.getException();
        if (exception != null) {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            this.fException.setText(writer.getBuffer().toString());
            ((GridData)this.fException.getLayoutData()).exclude = false;
        } else {
            this.fException.setText("");
            ((GridData)this.fException.getLayoutData()).exclude = true;
        }
        this.layout(true, true);
    }

    public void setStatus(IStatus status, String message, SelectionListener listener) {
        this.createContent(MessageKind.LINK);
        this.doSetStatus(status);
        this.fMessageLink.setText(message);
        this.fMessageLink.addSelectionListener(listener);
        this.layout(true, true);
    }

    private void doSetStatus(IStatus status) {
        Display display = this.fImage.getDisplay();
        switch (status.getSeverity()) {
            case 0: {
                this.fImage.setImage(null);
                break;
            }
            case 1: {
                this.fImage.setImage(display.getSystemImage(2));
                break;
            }
            case 2: {
                this.fImage.setImage(display.getSystemImage(8));
                break;
            }
            case 4: {
                this.fImage.setImage(display.getSystemImage(1));
                break;
            }
            default: {
                this.fImage.setImage(null);
            }
        }
        this.fTitleMessage.setText(status.getMessage());
    }

    private void createContent(MessageKind kind) {
        if (this.fImage != null) {
            return;
        }
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
        this.fImage = new Label((Composite)this, 0);
        this.fImage.setBackground(this.getBackground());
        GridDataFactory.swtDefaults().align(16384, 128).span(1, 2).applyTo((Control)this.fImage);
        this.fTitleMessage = new Label((Composite)this, 64);
        this.fTitleMessage.setBackground(this.getBackground());
        this.fTitleMessage.setFont(JFaceResources.getBannerFont());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fTitleMessage);
        switch (kind) {
            case EXCEPTION: {
                this.fException = new Text((Composite)this, 776);
                this.fException.setBackground(this.getBackground());
                GridDataFactory.fillDefaults().grab(true, true).exclude(true).applyTo((Control)this.fException);
                break;
            }
            case LINK: {
                this.fMessageLink = new Link((Composite)this, 64);
                this.fMessageLink.setBackground(this.getBackground());
                GridDataFactory.fillDefaults().grab(true, true).exclude(false).applyTo((Control)this.fMessageLink);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageKind {
        EXCEPTION,
        MESSAGE,
        LINK;

    }
}

