/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;

public class ProblemDialog
extends Dialog {
    public static final int OPEN = 1025;
    public static final int SELECT = 1026;
    private TableViewer fTableViewer;
    private final IterationPlanEditor fIterationPlanEditor;

    public ProblemDialog(IterationPlanEditor editor) {
        super(editor.getSite().getShell());
        this.fIterationPlanEditor = editor;
        this.setShellStyle(0x870 | ProblemDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
    }

    public void setInput(PlanProblemReport report) {
        this.fTableViewer.setInput((Object)report);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ProblemDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.fTableViewer = new TableViewer(result, 68354);
        Table table = this.fTableViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = this.convertWidthInCharsToPixels(90);
        gridData.minimumHeight = this.convertHeightInCharsToPixels(12);
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        TableColumn description = new TableColumn(table, 0);
        description.setText(Messages.ProblemDialog_COLUMN_DESCRIPTION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80));
        TableColumn workItem = new TableColumn(table, 131072);
        workItem.setText(Messages.ProblemDialog_COLUMN_WORKITEM);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        this.fTableViewer.setContentProvider((IContentProvider)new ProblemContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ProblemLabelProvider());
        this.fTableViewer.setSorter((ViewerSorter)new ProblemSorter());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ProblemDialog.this.getButton(1025).setEnabled(selection.size() > 0);
                ProblemDialog.this.getButton(1026).setEnabled(ProblemDialog.this.isSelectEnabled(selection));
            }
        });
        this.fTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PlanItemProblemReport report = (PlanItemProblemReport)((IStructuredSelection)event.getSelection()).getFirstElement();
                ProblemDialog.this.selectPlanItem(report.getPlanItem());
            }
        });
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                break;
            }
            case 1025: {
                Object[] elements = ((IStructuredSelection)this.fTableViewer.getSelection()).toArray();
                int i = 0;
                while (i < elements.length) {
                    PlanItemProblemReport report = (PlanItemProblemReport)elements[i];
                    WorkItemUI.open((IWorkbenchPage)this.fIterationPlanEditor.getSite().getPage(), (Object)report.getPlanItem().getWorkItemHandle());
                    ++i;
                }
                this.close();
                break;
            }
            case 1026: {
                PlanItemProblemReport report = (PlanItemProblemReport)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
                this.selectPlanItem(report.getPlanItem());
            }
        }
    }

    private void selectPlanItem(PlanItem item) {
        if (!this.fIterationPlanEditor.select(item)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ProblemDialog_NOT_SELECTED_TITLE, (String)Messages.ProblemDialog_NOT_SELECTED_MESSAGE);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.ProblemDialog_BUTTON_OPEN, true).setEnabled(false);
        this.createButton(parent, 1026, Messages.ProblemDialog_BUTTON_CLOSE, true).setEnabled(false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    public boolean close() {
        boolean result = super.close();
        this.fIterationPlanEditor.problemDialogClosed();
        return result;
    }

    private boolean isSelectEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        PlanItemProblemReport report = (PlanItemProblemReport)selection.getFirstElement();
        IWorkItemHandle workItem = report.getPlanItem().getWorkItemHandle();
        if (workItem == null) {
            return false;
        }
        return this.fIterationPlanEditor.getIterationPlanData().getIterationPlan().contains(workItem);
    }

    private static class ProblemContentProvider
    implements IStructuredContentProvider {
        private ProblemContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            PlanItemProblemReport[] itemReports = ((PlanProblemReport)inputElement).getPlanItemProblemReports();
            ArrayList<PlanItemProblemReport> result = new ArrayList<PlanItemProblemReport>(itemReports.length);
            PlanItemProblemReport[] planItemProblemReportArray = itemReports;
            int n = itemReports.length;
            int n2 = 0;
            while (n2 < n) {
                PlanItemProblemReport report = planItemProblemReportArray[n2];
                if (report.hasProblems()) {
                    result.add(report);
                }
                ++n2;
            }
            return result.toArray();
        }
    }

    private static class ProblemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int ICON_COLUMN = 0;
        private static final int MESSAGE_COLUMN = 1;
        private static final int ID_COLUMN = 2;
        private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private ProblemLabelProvider() {
        }

        public void dispose() {
            this.fResourceManager.dispose();
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                PlanItemProblemReport report = (PlanItemProblemReport)element;
                Problem problem = report.getMostSevereProblem();
                if (problem.isSeverity(Problem.Severity.FATAL_ERROR) || problem.isSeverity(Problem.Severity.ERROR)) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ERROR_OBJ);
                }
                if (problem.isSeverity(Problem.Severity.WARNING)) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.WARNING_OBJ);
                }
                if (problem.isSeverity(Problem.Severity.INFO)) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.INFO_OBJ);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PlanItemProblemReport report = (PlanItemProblemReport)element;
            Problem problem = report.getMostSevereProblem();
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return problem != null ? problem.getMessage() : "";
                }
                case 2: {
                    return Integer.toString(report.getPlanItem().getId());
                }
            }
            return "";
        }
    }

    private static class ProblemSorter
    extends ViewerSorter {
        private ProblemSorter() {
        }

        public int category(Object element) {
            return ((PlanItemProblemReport)element).getMostSevereProblem().getSeverity().ordinal();
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return -(cat1 - cat2);
            }
            PlanItemProblemReport r1 = (PlanItemProblemReport)e1;
            PlanItemProblemReport r2 = (PlanItemProblemReport)e2;
            return r2.getPlanItem().getId() - r1.getPlanItem().getId();
        }
    }
}

