/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.resource.parts.WorkItemProgressPresentationPart;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.CommandAction;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AttributeTypePresentationIdBindingManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationsManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.services.IServiceLocator;

public final class PreviewPane
extends PlatformObject {
    private static final Identifier<IAttribute> COMPLEXITY_ATTRIBUTE = Identifier.create(IAttribute.class, (String)"com.ibm.team.apt.attribute.complexity");
    private static final Set<Identifier<IAttribute>> fDetailsAttributes = new LinkedHashSet<Identifier<IAttribute>>(5);
    private static final int SECTION_STYLE = 320;
    private final Composite fContainer;
    private Composite fContentStack;
    private final ContextProvider fContextProvider = new ContextProvider(null){

        public URIReference getContext() {
            if (PreviewPane.this.fEditorInput != null) {
                return PreviewPane.this.fEditorInput.getReference();
            }
            return null;
        }

        public Object getUIContext() {
            return PreviewPane.this.fWorkbenchPart;
        }
    };
    private WorkItemEditorInput fEditorInput;
    private boolean fIsVisible;
    private boolean fIsWriteTracked;
    private AnimatedLoadingLabel fLoadingLabel;
    private Composite fLoadingLabelContainer;
    private Job fLoadJob;
    private Object fLoadJobGuard = new Object();
    private Composite fMessageContainer;
    private PlanCanvas fOutlineControl;
    private final IterationPlanData fPlanData;
    private PlanItem fPlanItem;
    private Collection<PreviewPanePresentation> fPresentations = new ArrayList<PreviewPanePresentation>(2);
    private Sash fPreviewSash;
    private ResourceManager fResourceManager;
    private Label fStatusLabel;
    private FormToolkit fToolkit;
    private IWorkbenchPart fWorkbenchPart;
    private ActiveControlTracker fActiveControlTracker;
    private Map<String, CommandAction> fActions;

    static {
        fDetailsAttributes.add(COMPLEXITY_ATTRIBUTE);
        fDetailsAttributes.add((Identifier<IAttribute>)WorkItemAttributes.TAGS);
        fDetailsAttributes.add((Identifier<IAttribute>)WorkItemAttributes.DURATION);
        fDetailsAttributes.add((Identifier<IAttribute>)WorkItemAttributes.TIME_SPENT);
        fDetailsAttributes.add((Identifier<IAttribute>)WorkItemAttributes.TARGET);
        fDetailsAttributes.add((Identifier<IAttribute>)WorkItemAttributes.DUE_DATE);
    }

    public PreviewPane(Composite parent, PlanCanvas outlineControl, OutlinePage outlinePage, IterationPlanData planData) {
        this.fContainer = parent;
        this.fPlanData = planData;
        this.fWorkbenchPart = outlinePage.getIterationPlanEditor().getSite().getPart();
        this.createControls(parent, outlineControl);
        this.initActions();
    }

    private void initActions() {
        Object version = Platform.getBundle((String)"org.eclipse.ui").getHeaders().get("Bundle-Version");
        if (version instanceof String && ((String)version).startsWith("3.3")) {
            this.fActions = new HashMap<String, CommandAction>();
            IWorkbenchPartSite serviceLocator = this.fWorkbenchPart.getSite();
            this.fActions.put(ActionFactory.CUT.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.cut"));
            this.fActions.put(ActionFactory.COPY.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.copy"));
            this.fActions.put(ActionFactory.PASTE.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.paste"));
            this.fActions.put(ActionFactory.UNDO.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.undo"));
            this.fActions.put(ActionFactory.REDO.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.redo"));
        }
    }

    public Action getAction(String id) {
        if (this.fActions == null) {
            return null;
        }
        return (Action)this.fActions.get(id);
    }

    private void createControls(final Composite parent, PlanCanvas outlineControl) {
        this.fOutlineControl = outlineControl;
        this.fToolkit = new WorkItemEditorToolkit(WorkItemIDEUIPlugin.getDefault().getSharedFormColors(parent.getDisplay()));
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fPreviewSash = new Sash(parent, 512);
        this.fToolkit.adapt((Control)this.fPreviewSash, true, true);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)outlineControl);
        data.bottom = new FormAttachment(100);
        this.fPreviewSash.setLayoutData((Object)data);
        this.fPreviewSash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (PreviewPane.this.fIsVisible) {
                    Rectangle clientArea = parent.getClientArea();
                    if (event.x < clientArea.x + 40 || event.x > clientArea.x + clientArea.width - 40) {
                        event.doit = false;
                    } else {
                        ((FormData)((PreviewPane)PreviewPane.this).fOutlineControl.getLayoutData()).right = new FormAttachment(event.x, clientArea.width, 0);
                        parent.layout();
                    }
                }
            }
        });
        this.fContentStack = this.fToolkit.createComposite(parent);
        this.fActiveControlTracker = new ActiveControlTracker(this.fContentStack);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.fPreviewSash, 0);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        this.fContentStack.setLayoutData((Object)data);
        this.fContentStack.setLayout((Layout)new StackLayout());
        this.createMessageContainer(this.fContentStack);
        this.createPresentations(this.fContentStack);
        this.createLoadingContainer(this.fContentStack);
        this.showLoadingLabel(0L);
    }

    private void createLoadingContainer(Composite parent) {
        this.fLoadingLabelContainer = this.fToolkit.createComposite(parent);
        this.fLoadingLabelContainer.setLayout((Layout)new FillLayout());
        this.fLoadingLabel = new AnimatedLoadingLabel(this.fLoadingLabelContainer, 0);
        this.fLoadingLabel.setFont(JFaceResources.getBannerFont());
    }

    private void createMessageContainer(Composite parent) {
        this.fMessageContainer = this.fToolkit.createComposite(parent);
        this.fStatusLabel = this.fToolkit.createLabel(this.fMessageContainer, "", 0x1000000);
        this.fStatusLabel.setFont(JFaceResources.getBannerFont());
        this.fStatusLabel.setForeground(this.fMessageContainer.getDisplay().getSystemColor(15));
        GridLayoutFactory.fillDefaults().applyTo(this.fMessageContainer);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.fStatusLabel);
    }

    private void createPresentations(Composite parent) {
        this.fPresentations.add(new PreviewPanePresentation(parent, 0));
        this.fPresentations.add(new PreviewPanePresentation(parent, 2));
        this.fPresentations.add(new PreviewPanePresentation(parent, 3));
    }

    private Sash createSash(final Composite parent, final Composite[] boundsControls) {
        Sash result = new Sash(parent, 256);
        result.setBackground(parent.getBackground());
        final FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        layoutData.top = new FormAttachment(60, 0);
        result.setLayoutData((Object)layoutData);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private Rectangle map(Composite parent2, Composite candidate) {
                return candidate != null ? parent2.getDisplay().map((Control)candidate, (Control)parent2, candidate.getClientArea()) : parent2.getClientArea();
            }

            public void widgetSelected(SelectionEvent event) {
                Rectangle clientArea = parent.getClientArea();
                Rectangle upperClientArea = this.map(parent, boundsControls[0]);
                Rectangle lowerClientArea = this.map(parent, boundsControls[1]);
                if (event.y < upperClientArea.y + 100 || event.y > lowerClientArea.y + lowerClientArea.height - 100) {
                    event.doit = false;
                } else {
                    layoutData.top = new FormAttachment(event.y, clientArea.height, 0);
                    parent.layout();
                }
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.fLoadJobGuard;
        synchronized (object) {
            for (PreviewPanePresentation presentation : this.fPresentations) {
                presentation.dispose();
            }
            this.fPresentations.clear();
            if (this.fLoadJob != null) {
                this.fLoadJob.cancel();
                this.fLoadJob = null;
            }
            if (this.fEditorInput != null) {
                this.fEditorInput.release();
                this.fEditorInput = null;
            }
            if (this.fPlanItem != null && this.fIsWriteTracked) {
                this.fPlanItem.endWriteTracking();
            }
            if (this.fToolkit != null) {
                this.fToolkit.dispose();
                this.fToolkit = null;
            }
            if (this.fActions != null) {
                for (CommandAction action : this.fActions.values()) {
                    action.dispose();
                }
            }
            this.fPlanItem = null;
            this.fWorkbenchPart = null;
        }
    }

    private PreviewPanePresentation findPresentation(IWorkItemType type) {
        block3: {
            block2: {
                if (!"com.ibm.team.apt.workItemType.story".equals(type.getIdentifier())) break block2;
                for (PreviewPanePresentation presentation : this.fPresentations) {
                    if (!presentation.hasStyle(3)) continue;
                    return presentation;
                }
                break block3;
            }
            if (this.fPlanItem.getChildrenCount() == 0) break block3;
            for (PreviewPanePresentation presentation : this.fPresentations) {
                if (!presentation.hasStyle(2)) continue;
                return presentation;
            }
        }
        return this.fPresentations.iterator().next();
    }

    public Object getAdapter(Class adapter) {
        WorkItemUIWorkingCopy uiWorkingCopy;
        WorkItemWorkingCopy workingCopy;
        if (IWorkbenchPart.class.isAssignableFrom(adapter)) {
            return this.fWorkbenchPart;
        }
        if (ContextProvider.class.equals((Object)adapter)) {
            return this.fContextProvider;
        }
        if (UIWorkItemListener.class.isAssignableFrom(adapter) && this.fEditorInput != null && (workingCopy = this.fEditorInput.getWorkingCopy()) != null && (uiWorkingCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(WorkItemUIWorkingCopy.class)) != null) {
            return uiWorkingCopy.getUIWorkItemListener();
        }
        if (IServiceLocator.class.equals((Object)adapter)) {
            return this.fWorkbenchPart.getSite();
        }
        if (ActiveControlTracker.class.equals((Object)adapter)) {
            return this.fActiveControlTracker;
        }
        return super.getAdapter(adapter);
    }

    public Control getControl() {
        return this.fContentStack;
    }

    private Control getCurrentContent() {
        return ((StackLayout)this.fContentStack.getLayout()).topControl;
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        if (copy != null) {
            return (WorkItemUIWorkingCopy)copy.getAdapter(IWorkItemUIWorkingCopy.class);
        }
        return null;
    }

    public WorkItemWorkingCopy getWorkingCopy() {
        if (this.fEditorInput != null) {
            return this.fEditorInput.getWorkingCopy();
        }
        return null;
    }

    public void setInput(PlanItem planItem) {
        this.setInput(planItem, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(final PlanItem planItem, boolean force) {
        if (planItem == this.fPlanItem && !force) {
            return;
        }
        Object object = this.fLoadJobGuard;
        synchronized (object) {
            if (this.fEditorInput != null) {
                this.fEditorInput.release();
                this.fEditorInput = null;
            }
            if (this.fPlanItem != null && this.fIsWriteTracked) {
                this.fPlanItem.endWriteTracking();
            }
            this.fPlanItem = planItem;
            this.fIsWriteTracked = false;
            if (this.fLoadJob != null) {
                this.fLoadJob.cancel();
                this.fLoadJob = null;
            }
            if (this.fIsVisible && planItem != null) {
                planItem.startWriteTracking();
                this.fIsWriteTracked = true;
                this.showLoadingLabel(0L);
                this.fLoadJob = new Job(Messages.PreviewPane_JOB_LOAD_PLAN_ITEM){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(final IProgressMonitor monitor) {
                        final WorkItemEditorInput editorInput = new WorkItemEditorInput(planItem.getWorkItemHandle());
                        PreviewPane.this.fEditorInput = editorInput;
                        editorInput.acquire();
                        editorInput.acquire();
                        try {
                            IProjectArea projectArea = planItem.getPlan().getProjectArea();
                            editorInput.getWorkItem();
                            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectArea);
                            final IWorkItemType workItemType = workItemClient.findWorkItemType((IProjectAreaHandle)projectArea, planItem.getItemType(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            final PreviewPanePresentation presentation = PreviewPane.this.findPresentation(workItemType);
                            if (presentation != null) {
                                final Composite control = presentation.getControl();
                                UI.syncExec((Control)control, new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        Object object = PreviewPane.this.fLoadJobGuard;
                                        synchronized (object) {
                                            if (!monitor.isCanceled() && editorInput.isResolved()) {
                                                presentation.setInput(editorInput, workItemType, planItem.getWorkItem(false));
                                                PreviewPane.this.showContainer(control, false);
                                            }
                                        }
                                    }
                                });
                            }
                            Object object = PreviewPane.this.fLoadJobGuard;
                            synchronized (object) {
                                PreviewPane.this.fLoadJob = null;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (TeamRepositoryException e) {
                            PlanningUIPlugin.log(e);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            editorInput.release();
                        }
                    }
                };
                this.fLoadJob.schedule();
            } else {
                for (PreviewPanePresentation presentation : this.fPresentations) {
                    presentation.setInput(null, null, null);
                }
                if (this.fEditorInput != null) {
                    this.fEditorInput.release();
                    this.fEditorInput = null;
                }
                this.showMessage(Messages.PreviewPane_NO_ITEM_SELECTED);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.fIsVisible == visible) {
            return;
        }
        this.fIsVisible = visible;
        this.fPreviewSash.setVisible(visible);
        this.fContentStack.setVisible(visible);
        if (visible) {
            ((FormData)this.fOutlineControl.getLayoutData()).right = new FormAttachment(50);
            if (this.fPlanItem != null) {
                this.setInput(this.fPlanItem, true);
            }
            this.showContainer((Composite)this.getCurrentContent(), true);
        } else {
            ((FormData)this.fOutlineControl.getLayoutData()).right = new FormAttachment(100);
        }
        this.fContainer.layout(true, true);
    }

    private void showContainer(Composite content, boolean force) {
        if (!force && this.getCurrentContent() == content) {
            return;
        }
        if (content != this.fLoadingLabelContainer) {
            this.fLoadingLabel.stop();
        }
        ((StackLayout)this.fContentStack.getLayout()).topControl = content;
        if (this.fIsVisible) {
            this.fContentStack.layout(true, true);
        }
    }

    private void showLoadingLabel(long timeout) {
        this.fLoadingLabel.start(0);
        this.showContainer(this.fLoadingLabelContainer, false);
    }

    private void showMessage(String message) {
        this.fStatusLabel.setText(message);
        this.showContainer(this.fMessageContainer, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PreviewPanePresentation
    implements IAdaptable {
        static final int STYLE_COMPLEXITY = 1;
        static final int STYLE_NONE = 0;
        static final int STYLE_PROGRESS = 2;
        private final Map<String, IAttribute> fCachedAttributes = new HashMap<String, IAttribute>(32);
        private final Map<String, String> fCachedKinds = new HashMap<String, String>(32);
        private Composite fContainer;
        private final Collection<TeamFormPart> fEditorParts = new ArrayList<TeamFormPart>(8);
        private ManagedForm fForm;
        private CLabel fLabel;
        private ILabelProvider fLabelProvider;
        private int fStyle = 0;
        private final IWorkItemListener fWorkItemListener = new WorkItemListener();

        PreviewPanePresentation(Composite parent, int style) {
            this.fStyle = style;
            this.fLabelProvider = WorkItemUI.createWorkItemLabelProvider();
            this.createControls(parent);
        }

        private void addListeners() {
            UIWorkItemListener listener;
            WorkItemUIWorkingCopy copy = PreviewPane.this.getUIWorkingCopy();
            if (copy != null && (listener = copy.getUIWorkItemListener()) != null) {
                listener.addListener(this.fWorkItemListener, IWorkItem.ID_PROPERTY);
                listener.addListener(this.fWorkItemListener, IWorkItem.TYPE_PROPERTY);
            }
        }

        private FormData addPart(TeamFormSectionPart part) {
            FormData result = new FormData();
            result.left = new FormAttachment(0);
            result.right = new FormAttachment(100, -3);
            part.getSection().setLayoutData((Object)result);
            this.fForm.addPart((IFormPart)part);
            part.setFormInput((Object)PreviewPane.this.fEditorInput);
            return result;
        }

        private void createControls(Composite parent) {
            this.fLabelProvider = WorkItemUI.createWorkItemLabelProvider();
            this.fContainer = PreviewPane.this.fToolkit.createComposite(parent);
            GridLayoutFactory.fillDefaults().spacing(0, 3).margins(3, 3).numColumns(1).applyTo(this.fContainer);
            new UIUpdaterJob(Messages.PreviewPane_JOB_LOADING_PRESENTATION){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        PreviewPanePresentation.this.fetchConfiguration(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, PlanningUIPlugin.getPluginId(), Messages.PreviewPane_INITIALIZE_PREVIEWPANE_FAILED, (Throwable)e);
                    }
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    try {
                        if (!PreviewPanePresentation.this.fContainer.isDisposed()) {
                            PreviewPanePresentation.this.createParts();
                            PreviewPane.this.showMessage(Messages.PreviewPane_NO_ITEM_SELECTED);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, PlanningUIPlugin.getPluginId(), Messages.PreviewPane_CREATE_PREVIEWPANE_FAILED, (Throwable)e);
                    }
                }
            }.schedule();
        }

        private void createFormContent() throws TeamRepositoryException {
            TeamFormSectionPart summaryPart = this.createSection(null, this.findFormParts((Collection<Identifier<IAttribute>>)Collections.singleton(WorkItemAttributes.SUMMARY)), 4096);
            FormData formData = this.addPart(summaryPart);
            formData.top = new FormAttachment(0);
            formData.left = new FormAttachment(0, 6);
            formData.right = new FormAttachment(100, -10);
            TeamFormSectionPart detailsPart = this.createSection(Messages.PreviewPane_SECTION_DETAILS, this.findFormParts(fDetailsAttributes), 322);
            detailsPart.getSection().setExpanded(false);
            formData = this.addPart(detailsPart);
            formData.top = new FormAttachment((Control)summaryPart.getSection(), 3);
            TeamFormSectionPart descriptionPart = this.createSection(Messages.PreviewPane_SECTION_DESCRIPTION, this.findFormParts((Collection<Identifier<IAttribute>>)Collections.singleton(WorkItemAttributes.DESCRIPTION)), 320);
            formData = this.addPart(descriptionPart);
            formData.top = new FormAttachment((Control)detailsPart.getSection(), 3);
            Composite[] compositeArray = new Composite[2];
            compositeArray[0] = descriptionPart.getSection();
            Composite[] boundsControls = compositeArray;
            Sash sash = PreviewPane.this.createSash(this.fForm.getForm().getBody(), boundsControls);
            formData.bottom = new FormAttachment((Control)sash);
            TeamFormSectionPart discussionPart = this.createSection(Messages.PreviewPane_SECTION_DISCUSSION, this.findFormParts((Collection<Identifier<IAttribute>>)Collections.singleton(WorkItemAttributes.COMMENTS)), 320);
            formData = this.addPart(discussionPart);
            formData.top = new FormAttachment((Control)sash);
            formData.bottom = new FormAttachment(100);
            boundsControls[1] = discussionPart.getSection();
        }

        private void createParts() throws TeamRepositoryException {
            this.fLabel = new CLabel(this.fContainer, 0);
            this.fLabel.setBackground(this.fContainer.getBackground());
            new DragSupport((Control)this.fLabel, 4){

                public ISelection getSelection() {
                    return new StructuredSelection((Object)PreviewPane.this.fPlanItem.getWorkItem(false));
                }
            };
            GridDataFactory.fillDefaults().span(2, 0).grab(false, false).applyTo((Control)this.fLabel);
            Font font = this.fContainer.getFont();
            FontData[] datas = font.getFontData();
            FontData[] newDatas = new FontData[datas.length];
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[i];
                newDatas[i] = new FontData(data.getName(), Math.max(6, data.getHeight() + 2), data.getStyle() | 1);
                ++i;
            }
            FormColors formColors = new FormColors(this.fContainer.getDisplay());
            RGB titleColorRGB = formColors.getColor("org.eclipse.ui.forms.TITLE").getRGB();
            formColors.dispose();
            Font titleFont = JazzResources.getFont((ResourceManager)PreviewPane.this.fResourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
            Color titleColor = JazzResources.getColor((ResourceManager)PreviewPane.this.fResourceManager, (RGB)titleColorRGB);
            this.fLabel.setFont(titleFont);
            this.fLabel.setForeground(titleColor);
            ScrolledForm scrollableForm = PreviewPane.this.fToolkit.createScrolledForm(this.fContainer);
            scrollableForm.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fForm = new ManagedForm(PreviewPane.this.fToolkit, scrollableForm);
            this.fForm.setContainer((Object)this);
            scrollableForm.getBody().setLayout((Layout)new FormLayout());
            this.fForm.getToolkit().decorateFormHeading(scrollableForm.getForm());
            this.createFormContent();
        }

        private TeamFormSectionPart createSection(String label, Collection<TeamFormPart> parts, int style) {
            return new TeamFormSectionPart((IManagedForm)this.fForm, style, label, parts.toArray(new TeamFormPart[parts.size()]));
        }

        public void dispose() {
            this.removeListeners();
            if (this.fForm != null) {
                this.fForm.setInput(null);
                this.fForm.dispose();
                this.fForm = null;
            }
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
                this.fLabelProvider = null;
            }
        }

        private void fetchConfiguration(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor.beginTask(Messages.PreviewPane_MONITOR_FETCHING_CONFIGURATION, 100);
            try {
                IWorkItemClient client = (IWorkItemClient)PreviewPane.this.fPlanData.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                List attributes = client.findAttributes((IProjectAreaHandle)PreviewPane.this.fPlanData.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                for (IAttribute attribute : attributes) {
                    String identifier = attribute.getIdentifier();
                    this.fCachedAttributes.put(identifier, attribute);
                    if (!this.hasStyle(1) && identifier.equals(COMPLEXITY_ATTRIBUTE.getStringIdentifier())) continue;
                    String kind = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
                    if (kind != null) {
                        this.fCachedKinds.put(identifier, kind);
                        continue;
                    }
                    if (WorkItem.DURATION_PROPERTY.equals(identifier)) {
                        this.fCachedKinds.put(identifier, "com.ibm.team.apt.kind.internal.estimate");
                        continue;
                    }
                    if (WorkItem.TIME_SPENT_PROPERTY.equals(identifier)) {
                        this.fCachedKinds.put(identifier, "com.ibm.team.apt.kind.internal.timespent");
                        continue;
                    }
                    if (WorkItem.TAGS_PROPERTY.equals(identifier)) {
                        this.fCachedKinds.put(identifier, "com.ibm.team.workitem.kind.internal.tags");
                        continue;
                    }
                    if (WorkItem.COMMENTS_PROPERTY.equals(identifier)) {
                        this.fCachedKinds.put(identifier, "com.ibm.team.workitem.kind.internal.discussion");
                        continue;
                    }
                    if (!WorkItem.TARGET_PROPERTY.equals(identifier)) continue;
                    this.fCachedKinds.put(identifier, "com.ibm.team.workitem.kind.internal.target");
                }
            }
            finally {
                monitor.done();
            }
        }

        private Collection<TeamFormPart> findFormParts(Collection<Identifier<IAttribute>> identifiers) {
            ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>(8);
            if (this.hasStyle(2) && identifiers.contains(WorkItemAttributes.DURATION)) {
                WorkItemProgressPresentationPart part = new WorkItemProgressPresentationPart();
                part.initialize(new PresentationDescriptor(null, "com.ibm.team.apt.kind.internal.progress", null, Collections.emptyMap()));
                parts.add((TeamFormPart)part);
            }
            for (Identifier<IAttribute> identifier : identifiers) {
                String kind;
                String id = WorkItemAttributes.getAttributeId(identifier);
                IAttribute attribute = this.fCachedAttributes.get(id);
                if (attribute == null || (kind = this.fCachedKinds.get(id)) == null) continue;
                PresentationPart part = PresentationsManager.getPresentation((String)kind);
                if (part == null) {
                    WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PreviewPane_NO_CLASS_FOUND, (Object[])new Object[]{kind})));
                    return null;
                }
                if (part instanceof AttributePart) {
                    AttributePart extended = (AttributePart)part;
                    extended.initialize(attribute, new PresentationDescriptor(null, kind, identifier, Collections.emptyMap()));
                    parts.add((TeamFormPart)extended);
                    continue;
                }
                part.initialize(new PresentationDescriptor(null, kind, null, Collections.emptyMap()));
                parts.add((TeamFormPart)part);
            }
            PresentationPart separator = PresentationsManager.getPresentation((String)"com.ibm.team.workitem.kind.separator");
            if (separator == null) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PreviewPane_NO_CLASS_FOUND, (Object[])new Object[]{"com.ibm.team.workitem.kind.separator"})));
                return null;
            }
            parts.add((TeamFormPart)separator);
            this.fEditorParts.addAll(parts);
            return parts;
        }

        public Object getAdapter(Class adapter) {
            return PreviewPane.this.getAdapter(adapter);
        }

        public Composite getControl() {
            return this.fContainer;
        }

        public int getStyle() {
            return this.fStyle;
        }

        public boolean hasStyle(int style) {
            return (this.fStyle & style) == style;
        }

        private void removeListeners() {
            UIWorkItemListener listener;
            WorkItemUIWorkingCopy copy = PreviewPane.this.getUIWorkingCopy();
            if (copy != null && (listener = copy.getUIWorkItemListener()) != null) {
                listener.removeListener(this.fWorkItemListener, IWorkItem.ID_PROPERTY);
                listener.removeListener(this.fWorkItemListener, IWorkItem.TYPE_PROPERTY);
            }
        }

        public void setInput(WorkItemEditorInput input, IWorkItemType type, IWorkItem item) {
            this.removeListeners();
            if (this.fForm != null) {
                if (input != null) {
                    this.addListeners();
                    this.fLabel.setImage(this.fLabelProvider.getImage((Object)item));
                    this.fLabel.setText(NLS.bind((String)Messages.PreviewPane_PREVIEW_TITLE, (Object[])new Object[]{type.getDisplayName(), WorkItemTextUtilities.getWorkItemId((IWorkItem)item)}));
                }
                this.fForm.setInput((Object)input);
                for (TeamFormPart part : this.fEditorParts) {
                    part.setInput((Object)input);
                }
            }
        }

        private final class WorkItemListener
        implements IWorkItemListener {
            private WorkItemListener() {
            }

            public void workItemAttributeChanged(WorkItemChangeEvent event) {
                if (!event.affects((IWorkItemHandle)PreviewPane.this.fPlanItem.getWorkItem(false))) {
                    return;
                }
                if ((event.affects(IWorkItem.TYPE_PROPERTY) || event.affects(IWorkItem.ID_PROPERTY)) && !PreviewPanePresentation.this.fLabel.isDisposed()) {
                    final IWorkItem item = event.getWorkItem();
                    UIUpdaterJob job = new UIUpdaterJob(Messages.PreviewPane_UPDATING_TITLE){
                        private IWorkItemType fType;
                        {
                            super($anonymous0);
                            this.fType = null;
                        }

                        public IStatus runInBackground(IProgressMonitor monitor) {
                            IProjectArea projectArea = PreviewPane.this.fPlanItem.getPlan().getProjectArea();
                            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectArea);
                            try {
                                this.fType = workItemClient.findWorkItemType((IProjectAreaHandle)projectArea, PreviewPane.this.fPlanItem.getItemType(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            catch (TeamRepositoryException e) {
                                PlanningUIPlugin.log(e);
                            }
                            return Status.OK_STATUS;
                        }

                        public IStatus runInUI(IProgressMonitor monitor) {
                            PreviewPanePresentation.this.fLabel.setImage(PreviewPanePresentation.this.fLabelProvider.getImage((Object)item));
                            if (this.fType != null) {
                                PreviewPanePresentation.this.fLabel.setText(NLS.bind((String)Messages.PreviewPane_PREVIEW_TITLE, (Object[])new Object[]{this.fType.getDisplayName(), WorkItemTextUtilities.getWorkItemId((IWorkItem)item)}));
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }

            public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
            }
        }
    }
}

