/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.actions.AddSiblingFolderAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignActionFactory;
import com.ibm.team.apt.internal.ide.ui.actions.DeleteDraftItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.DeleteFolderAction;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemDownAction;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemUpAction;
import com.ibm.team.apt.internal.ide.ui.actions.OpenAbsenceAction;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.RenameFolderAction;
import com.ibm.team.apt.internal.ide.ui.actions.RevertPlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.SelectAllAction;
import com.ibm.team.apt.internal.ide.ui.actions.WorkItemTypeSelectionAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.DefaultRootElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupFolderElement;
import com.ibm.team.apt.internal.ide.ui.editor.CancelEditSessionAction;
import com.ibm.team.apt.internal.ide.ui.editor.DecreaseIndentAction;
import com.ibm.team.apt.internal.ide.ui.editor.IncreaseIndentAction;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.StartEditSessionAction;
import com.ibm.team.apt.internal.ide.ui.editor.StopEditSessionAction;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.CopyTextAction;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.CutTextAction;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.GroupByNoneDescription;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PasteTextAction;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private AssignActionFactory fAssignActionFactory;
    private OpenAbsenceAction fOpenAbsenceAction;
    private SelectAllAction fSelectAllAction;
    private RevertPlanItemAction fRevertPlanItemAction;
    private IHandlerService fHandlerService;
    private WorkItemTypeSelectionAction fWorkItemSelectionAction;
    private MovePlanItemUpAction fMovePlanItemUpAction;
    private MovePlanItemDownAction fMovePlanItemDownAction;
    private IncreaseIndentAction fIncreaseIndentAction;
    private DecreaseIndentAction fDecreaseIndentAction;
    private DeleteDraftItemAction fDeleteDraftItemAction;
    private StartEditSessionAction fStartEditSessionAction;
    private CancelEditSessionAction fCancelEditSessionAction;
    private StopEditSessionAction fStopEditSessionAction;
    private CutTextAction fCutAction;
    private CopyTextAction fCopyAction;
    private PasteTextAction fPasteAction;
    private AddSiblingFolderAction fAddSiblingFolderAction;
    private RenameFolderAction fRenameFolderAction;
    private DeleteFolderAction fDeleteFolderAction;
    private Map<String, Action> fActions;
    private final PlanViewModel fViewModel;
    private ISelectionProvider fSelectionProvider;

    public PlanItemActionGroup(IWorkbenchSite site, PlanViewModel viewModel) {
        this.fSite = site;
        this.fViewModel = viewModel;
        this.fActions = new HashMap<String, Action>();
        this.fSelectionProvider = viewModel.getSelectionProvider();
        this.fRevertPlanItemAction = new RevertPlanItemAction(this.fSite, viewModel);
        this.initAction(this.fRevertPlanItemAction, null);
        this.fSelectAllAction = new SelectAllAction(this.fSite, viewModel);
        this.initAction(this.fSelectAllAction, ActionFactory.SELECT_ALL.getId());
        this.fOpenAbsenceAction = new OpenAbsenceAction(this.fSite, viewModel);
        this.initAction(this.fOpenAbsenceAction, null);
        this.fMovePlanItemUpAction = new MovePlanItemUpAction(this.fSite, viewModel);
        this.initAction(this.fMovePlanItemUpAction, "com.ibm.team.apt.actions.iterationPlan.move.up");
        this.fMovePlanItemDownAction = new MovePlanItemDownAction(this.fSite, viewModel);
        this.initAction(this.fMovePlanItemDownAction, "com.ibm.team.apt.actions.iterationPlan.move.down");
        this.fIncreaseIndentAction = new IncreaseIndentAction(this.fSite, viewModel);
        this.initAction(this.fIncreaseIndentAction, "com.ibm.team.apt.actions.iterationPlan.increaseIndent");
        this.fDecreaseIndentAction = new DecreaseIndentAction(this.fSite, viewModel);
        this.initAction(this.fDecreaseIndentAction, "com.ibm.team.apt.actions.iterationPlan.decreaseIndent");
        this.fDeleteDraftItemAction = new DeleteDraftItemAction(this.fSite, viewModel);
        this.initAction(this.fDeleteDraftItemAction, null);
        this.fStartEditSessionAction = new StartEditSessionAction(this.fSite, viewModel);
        this.initAction(this.fStartEditSessionAction, "com.ibm.team.apt.actions.iterationPlan.startEditSession");
        this.fCancelEditSessionAction = new CancelEditSessionAction(this.fSite, viewModel);
        this.initAction(this.fCancelEditSessionAction, "com.ibm.team.apt.actions.iterationPlan.cancelEditSession");
        this.fStopEditSessionAction = new StopEditSessionAction(this.fSite, viewModel);
        this.initAction(this.fStopEditSessionAction, "com.ibm.team.apt.actions.iterationPlan.stopEditSession");
        this.fCutAction = new CutTextAction((PlanItemOutlineViewer)viewModel.getViewer());
        this.initTextAction(this.fCutAction, ActionFactory.CUT.getId());
        this.fCopyAction = new CopyTextAction((PlanItemOutlineViewer)viewModel.getViewer());
        this.initTextAction(this.fCopyAction, ActionFactory.COPY.getId());
        this.fPasteAction = new PasteTextAction((PlanItemOutlineViewer)viewModel.getViewer());
        this.initTextAction(this.fPasteAction, ActionFactory.PASTE.getId());
        this.fAddSiblingFolderAction = new AddSiblingFolderAction(this.fSite, viewModel);
        this.initAction(this.fAddSiblingFolderAction, null);
        this.fDeleteFolderAction = new DeleteFolderAction(this.fSite, viewModel);
        this.initAction(this.fDeleteFolderAction, null);
        this.fRenameFolderAction = new RenameFolderAction(this.fSite, viewModel);
        this.initAction(this.fRenameFolderAction, null);
        this.installQuickAccessAction();
    }

    public void inputChanged(Object oldInput, Object newInput) {
        this.fAssignActionFactory = null;
        if (newInput instanceof ResolvedIterationPlan) {
            this.fAssignActionFactory = new AssignActionFactory(this.fSite, this.fViewModel);
        }
    }

    public Action getAction(String id) {
        return this.fActions.get(id);
    }

    public Action[] getActions() {
        Collection<Action> values = this.fActions.values();
        return values.toArray(new Action[values.size()]);
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            this.fWorkItemSelectionAction = new WorkItemTypeSelectionAction(this.fSite, this.fViewModel, "com.ibm.team.apt.actions.iterationPlan.add.below");
            this.fWorkItemSelectionAction.activate(this.fHandlerService);
        }
    }

    private void initAction(PlanViewModelAction<?> action, String id) {
        this.fSelectionProvider.addSelectionChangedListener(action);
        action.setActionDefinitionId(id);
        action.setId(id);
        action.update();
        if (id != null) {
            this.fActions.put(id, action);
        }
    }

    private void initTextAction(Action action, String id) {
        action.setActionDefinitionId(id);
        action.setId(id);
        if (id != null) {
            this.fActions.put(id, action);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IMenuManager assignToFolderMenu;
        boolean myFolderMode;
        super.fillContextMenu(menu);
        IPlanOutlineSettings settings = (IPlanOutlineSettings)this.fViewModel.getViewer().getSettings();
        this.addAction(menu, (IAction)this.fOpenAbsenceAction);
        this.addAction(menu, (IAction)this.fRevertPlanItemAction);
        this.addAction(menu, (IAction)this.fDeleteDraftItemAction);
        this.fStartEditSessionAction.update();
        this.addAction(menu, (IAction)this.fStartEditSessionAction);
        menu.add((IContributionItem)new Separator());
        IMenuManager addItemMenu = this.fWorkItemSelectionAction.buildContextMenu(menu);
        if (addItemMenu != null) {
            menu.add((IContributionItem)addItemMenu);
        }
        boolean bl = myFolderMode = settings != null && "NONE".equals(settings.getGroupMode().getId());
        if (myFolderMode) {
            menu.add((IContributionItem)new Separator());
            MenuManager folderMenu = new MenuManager(Messages.PlanItemActionGroup_MENU_MY_FOLDERS);
            int added = 0;
            added += this.addAction((IMenuManager)folderMenu, (IAction)this.fAddSiblingFolderAction);
            added += this.addAction((IMenuManager)folderMenu, (IAction)this.fDeleteFolderAction);
            if ((added += this.addAction((IMenuManager)folderMenu, (IAction)this.fRenameFolderAction)) > 0) {
                menu.add((IContributionItem)folderMenu);
            }
        }
        menu.add((IContributionItem)new Separator());
        if (this.fAssignActionFactory != null && this.fAssignActionFactory.isEnabled()) {
            if (settings != null && "TIMELINE".equals(settings.getGroupMode().getId())) {
                menu.add((IContributionItem)this.fAssignActionFactory.getPlanningMenu());
            } else {
                menu.add((IContributionItem)this.fAssignActionFactory.getAssignTargetMenu());
            }
            menu.add((IContributionItem)this.fAssignActionFactory.getAssignOwnerMenu());
            menu.add((IContributionItem)this.fAssignActionFactory.getAssignCategoryMenu());
            menu.add((IContributionItem)this.fAssignActionFactory.getAssignTagMenu());
        }
        if (myFolderMode && (assignToFolderMenu = this.buildAssignToFolderMenu(menu)) != null) {
            menu.add((IContributionItem)assignToFolderMenu);
        }
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, (IAction)this.fMovePlanItemUpAction);
        this.addAction(menu, (IAction)this.fMovePlanItemDownAction);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, (IAction)this.fIncreaseIndentAction);
        this.addAction(menu, (IAction)this.fDecreaseIndentAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (!action.isEnabled()) {
            return 0;
        }
        menu.add(action);
        return 1;
    }

    public void dispose() {
        super.dispose();
        for (Action action : this.fActions.values()) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            this.disposeAction((ISelectionChangedListener)action);
        }
        if (this.fHandlerService != null) {
            this.fWorkItemSelectionAction.deactivate(this.fHandlerService);
        }
    }

    private void disposeAction(ISelectionChangedListener action) {
        if (action != null) {
            this.fSelectionProvider.removeSelectionChangedListener(action);
        }
    }

    private IMenuManager buildAssignToFolderMenu(IMenuManager parent) {
        MenuManager result = new MenuManager(Messages.PlanItemActionGroup_MENU_MOVE_TO_FOLDER);
        return this.fViewModel.readModel(new ModelReadRunnable<Boolean, RuntimeException>((IMenuManager)result){
            private final /* synthetic */ IMenuManager val$result;
            {
                this.val$result = iMenuManager;
            }

            @Override
            public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                return this.buildMenu(readAccessor.getRootEntry(), readAccessor.getEntryNavigator(true), -1);
            }

            private boolean buildMenu(OutlineEntry<?> entry, EntryNavigator n, int indent) {
                boolean created = false;
                boolean visit = false;
                if (entry.getElement() instanceof DefaultRootElement) {
                    visit = true;
                } else if (entry.getElement() instanceof GroupFolderElement) {
                    GroupFolderElement folder = (GroupFolderElement)entry.getElement();
                    StringBuilder label = new StringBuilder();
                    int i = indent;
                    while (i > 0) {
                        label.append(Messages.PlanItemActionGroup_MENUITEM_FOLDER_INDENTATION);
                        --i;
                    }
                    label.append(folder.getLabel());
                    AssignToGroupFolderAction action = new AssignToGroupFolderAction(PlanItemActionGroup.this.fSite, PlanItemActionGroup.this.fViewModel, entry, label.toString());
                    action.update();
                    if (action.isEnabled()) {
                        this.val$result.add((IAction)action);
                        created = true;
                    }
                    visit = true;
                }
                if (visit) {
                    List<OutlineEntry<?>> children = n.childEntries(entry);
                    for (OutlineEntry<?> child : children) {
                        created |= this.buildMenu(child, n, indent + 1);
                    }
                }
                return created;
            }
        }) != false ? result : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssignToGroupFolderAction
    extends PlanViewModelAction<IterationPlanItem> {
        private OutlineEntry<GroupFolderElement> fFolder;

        public AssignToGroupFolderAction(IWorkbenchSite site, PlanViewModel viewModel, OutlineEntry<GroupFolderElement> folder, String text) {
            super(site, viewModel, IterationPlanItem.class, ONE_OR_MORE);
            this.fFolder = folder;
            this.setText(text);
        }

        @Override
        protected boolean checkElement(OutlineEntry<IterationPlanItem> selectedEntry) {
            return !selectedEntry.getElement().isProgressPlanItem();
        }

        @Override
        protected void updateAction(Collection<OutlineEntry<IterationPlanItem>> selectedEntries) {
            boolean checked = false;
            if (selectedEntries.size() == 1) {
                IterationPlanItem item = (IterationPlanItem)EntryUtils.firstEntry(selectedEntries).getElement();
                if (this.fFolder.getElement().getId().equals((Object)item.getFolderId())) {
                    checked = true;
                }
            }
            this.setChecked(checked);
        }

        @Override
        public void run(Collection<OutlineEntry<IterationPlanItem>> selectedEntries) {
            ((GroupByNoneDescription.MyFolderItemMovePolicy)this.getPlanViewModel().getOutlineSettings().getItemMovePolicy()).adopt(this.fFolder, selectedEntries);
        }
    }
}

