/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanEditorInput
extends PlatformObject
implements IEditorInput {
    private IIterationPlanRecordHandle fHandle;
    private TeamFuture<IterationPlanData> fFuture;
    private IterationPlanData fIterationPlanData;
    private String fName;

    public IterationPlanEditorInput(IIterationPlanRecordHandle handle) {
        this.fHandle = handle;
        this.fFuture = this.createFuture();
    }

    public TeamFuture<IterationPlanData> getFuture() {
        if (this.fFuture == null) {
            this.fFuture = this.createFuture();
        }
        return this.fFuture;
    }

    public IIterationPlanRecordHandle getHandle() {
        return this.fHandle;
    }

    public void clear() {
        this.fFuture = null;
        this.fIterationPlanData = null;
    }

    public synchronized IterationPlanData getIterationPlanData() {
        return this.fIterationPlanData;
    }

    synchronized void setIterationPlan(IterationPlanData data) {
        this.fIterationPlanData = data;
        this.fName = NLS.bind((String)Messages.IterationPlanEditorInput_NAME, (Object[])new Object[]{this.fIterationPlanData.getPlanRecord().getName(), this.fIterationPlanData.getIteration().getLabel()});
    }

    synchronized void handlePlanDeleted() {
        this.clear();
        this.fHandle = null;
    }

    public boolean exists() {
        return this.fHandle != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlanningUIPlugin.getImageDescriptor("icons/view16/iteration_plan_editor.gif");
    }

    public String getName() {
        if (this.fName != null) {
            return this.fName;
        }
        return "";
    }

    public String getToolTipText() {
        if (this.fName != null) {
            return NLS.bind((String)Messages.IterationPlanEditorInput_TOOLTIP, (Object[])new Object[]{this.fName});
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IterationPlanEditorInput)) {
            return false;
        }
        IterationPlanEditorInput other = (IterationPlanEditorInput)((Object)obj);
        if (this.fHandle == null || other.fHandle == null) {
            return false;
        }
        return this.fHandle.sameItemId((IItemHandle)other.fHandle);
    }

    private TeamFuture<IterationPlanData> createFuture() {
        return new TeamFuture<IterationPlanData>(true){

            public IterationPlanData resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    IterationPlanClient client = (IterationPlanClient)((ITeamRepository)IterationPlanEditorInput.this.fHandle.getOrigin()).getClientLibrary(IIterationPlanClient.class);
                    IterationPlanData iterationPlanData = client.fetchIterationPlanData(IterationPlanEditorInput.this.fHandle, monitor);
                    IterationPlanEditorInput.this.setIterationPlan(iterationPlanData);
                    return iterationPlanData;
                }
                catch (ItemNotFoundException e) {
                    IterationPlanEditorInput.this.handlePlanDeleted();
                    throw e;
                }
            }
        };
    }
}

