/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.util.NLS;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AttachmentsViewer
extends TableViewer {
    public AttachmentsViewer(Table table) {
        super(table);
        this.setLabelProvider((IBaseLabelProvider)new AttachmentsLabelProvider());
        this.setContentProvider((IContentProvider)new AttachmentsContentProvider());
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 0, true));
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.AttachmentsViewer_COLUMN_NAME);
        column.setMoveable(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 0, true));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AttachmentsViewer_COLUMN_DESCRIPTION);
        column.setMoveable(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 0, true));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AttachmentsViewer_COLUMN_CREATOR);
        column.setMoveable(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 0, true));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AttachmentsViewer_COLUMN_SIZE);
        column.setMoveable(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 0, true));
        column = new TableColumn(table, 16384);
        column.setText(Messages.AttachmentsViewer_COLUMN_CONTENTTYPE);
        column.setMoveable(true);
        new ViewerDragSupport((Viewer)this, 7);
    }

    public static class AttachmentsContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class AttachmentsLabelProvider
    extends CellLabelProvider
    implements ILabelProviderListener {
        private StandardLabelProvider fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        AttachmentsLabelProvider() {
            this.fLabelProvider.addListener((ILabelProviderListener)this);
        }

        String nonNull(String str, String dflt) {
            return str != null ? str : dflt;
        }

        public void dispose() {
            this.fLabelProvider.removeListener((ILabelProviderListener)this);
            this.fLabelProvider.dispose();
            super.dispose();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            AttachmentsViewer.this.refresh();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof ResolvedWikiPageAttachment) {
                ResolvedWikiPageAttachment attachment = (ResolvedWikiPageAttachment)element;
                switch (cell.getColumnIndex()) {
                    case 0: {
                        String name = attachment.getAttachment().getName();
                        cell.setText(this.nonNull(name, Messages.AttachmentsViewer_UNKNOWN_NAME));
                        cell.setImage(null);
                        break;
                    }
                    case 1: {
                        String desc = attachment.getAttachment().getDescription();
                        cell.setText(this.nonNull(desc, Messages.AttachmentsViewer_UNKNOWN_DESCRIPTION));
                        cell.setImage(null);
                        break;
                    }
                    case 2: {
                        if (attachment.isPredefined()) {
                            cell.setText(Messages.AttachmentsViewer_PREDEFINED_CREATOR);
                            cell.setImage(null);
                            cell.setForeground(null);
                            cell.setFont(null);
                            break;
                        }
                        IContributor creator = attachment.getCreator();
                        String text = this.fLabelProvider.getText((Object)creator);
                        cell.setText(this.nonNull(text, Messages.AttachmentsViewer_UNKNOWN_CREATOR));
                        cell.setImage(this.fLabelProvider.getImage((Object)creator));
                        ViewerLabel viewerLabel = new ViewerLabel(null, null);
                        this.fLabelProvider.updateLabel(viewerLabel, (Object)creator);
                        cell.setForeground(viewerLabel.getForeground());
                        cell.setFont(viewerLabel.getFont());
                        break;
                    }
                    case 3: {
                        IContent content = attachment.getAttachment().getContent();
                        long bytes = content.getRawLength();
                        long size = bytes / 1024L;
                        if (bytes != 0L) {
                            size = Math.max(1L, size);
                        }
                        cell.setText(this.nonNull(content != null ? NLS.bind((String)Messages.AttachmentsViewer_FILESIZE, (Object[])new Object[]{size}) : null, Messages.AttachmentsViewer_UNKNOWN_FILESIZE));
                        cell.setImage(null);
                        break;
                    }
                    case 4: {
                        IContent content = attachment.getAttachment().getContent();
                        cell.setText(this.nonNull(content != null ? content.getContentType() : null, Messages.AttachmentsViewer_UNKNOWN_CONTENTTYPE));
                        cell.setImage(null);
                    }
                }
            }
        }
    }
}

