/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceItemMovePolicy
extends ItemMovePolicy {
    @Override
    public ItemMovePolicy.DropLocation validateDrop(final IStructuredSelection sourceSelection, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, DropTargetEvent event) {
        return targetEntry.getModel().readModel(new ModelReadRunnable<ItemMovePolicy.DropLocation, RuntimeException>(){

            @Override
            public ItemMovePolicy.DropLocation run(IOutlineModelReader readAccessor) throws RuntimeException {
                EntryNavigator n = readAccessor.getEntryNavigator(true);
                ItemMovePolicy.DropLocation result = location;
                boolean hasValidAdoptions = false;
                Object target = targetEntry.getElement();
                ResolvedPlan plan = SequenceItemMovePolicy.this.getPlan(targetEntry);
                Object[] objectArray = sourceSelection.toArray();
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object source = objectArray[n3];
                    if (SequenceItemMovePolicy.this.isIncompatibleProjectArea(source, targetEntry)) {
                        result = ItemMovePolicy.DropLocation.None;
                    } else if (source instanceof IWorkItemHandle || source instanceof PlanItem) {
                        Object parentElement;
                        IWorkItemHandle sourceHandle = source instanceof PlanItem ? ((PlanItem)source).getWorkItemHandle() : (IWorkItemHandle)source;
                        PlanItem sourceItem = (PlanItem)(source instanceof PlanItem ? source : plan.getPlanItem((IWorkItemHandle)source));
                        if (source instanceof IWorkItem && this.isClosed((IWorkItem)source, plan) || sourceItem != null && sourceItem.isResolved()) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (target instanceof MessageElement) {
                            result = ItemMovePolicy.DropLocation.OntoParent;
                            hasValidAdoptions = true;
                        } else if (location != ItemMovePolicy.DropLocation.Onto) {
                            if (target instanceof PlanItem && ((PlanItem)target).getWorkItemHandle().sameItemId((IItemHandle)sourceHandle)) {
                                result = ItemMovePolicy.DropLocation.None;
                            } else {
                                parentElement = n.parentElement(targetEntry);
                                if (parentElement instanceof TimeElement) {
                                    TimeSpanDefinition timeSpan = ((TimeElement)parentElement).getTimeSpan();
                                    if (timeSpan == null) {
                                        result = ItemMovePolicy.DropLocation.None;
                                    } else if (timeSpan == TimeSpanDefinition.UNSCHEDULED) {
                                        result = ItemMovePolicy.DropLocation.OntoParent;
                                        boolean isValidAdoption = true;
                                        if (sourceItem != null) {
                                            isValidAdoption = sourceItem.getTarget() == null || !plan.getPlannedIterations().contains((Object)sourceItem.getTarget()) || sourceItem.getScheduledTime() != null;
                                        }
                                        hasValidAdoptions |= isValidAdoption;
                                    } else {
                                        Object nextSibling = location == ItemMovePolicy.DropLocation.Before ? n.predecessor(targetEntry) : n.successor(targetEntry);
                                        if (nextSibling == null && target instanceof PlanItem && !((PlanItem)target).isResolved()) {
                                            hasValidAdoptions = true;
                                        } else if (nextSibling instanceof PlanItem && !((PlanItem)nextSibling).isResolved() && !sourceHandle.sameItemId((IItemHandle)((PlanItem)nextSibling).getWorkItemHandle())) {
                                            hasValidAdoptions = true;
                                        }
                                    }
                                }
                            }
                        } else if (target instanceof PlanItem) {
                            TimeSpanDefinition timeSpan;
                            result = ItemMovePolicy.DropLocation.None;
                            parentElement = n.parentElement(targetEntry);
                            if (parentElement instanceof TimeElement && (timeSpan = ((TimeElement)parentElement).getTimeSpan()) == TimeSpanDefinition.UNSCHEDULED) {
                                result = ItemMovePolicy.DropLocation.OntoParent;
                                hasValidAdoptions = true;
                            }
                        } else if (target instanceof TimeElement) {
                            TimeSpanDefinition timeSpan = ((TimeElement)target).getTimeSpan();
                            if (timeSpan == TimeSpanDefinition.UNSCHEDULED || !timeSpan.getStartTime().before(plan.getReferenceTime())) {
                                result = ItemMovePolicy.DropLocation.OntoUnderlayChildern;
                                boolean isValidAdoption = true;
                                if (timeSpan == TimeSpanDefinition.UNSCHEDULED && sourceItem != null) {
                                    isValidAdoption = sourceItem.getTarget() == null || !plan.getPlannedIterations().contains((Object)sourceItem.getTarget()) || sourceItem.getScheduledTime() != null;
                                }
                                hasValidAdoptions |= isValidAdoption;
                            }
                        } else if (target instanceof GroupElement) {
                            hasValidAdoptions = true;
                        } else {
                            result = ItemMovePolicy.DropLocation.None;
                        }
                    }
                    if (result == ItemMovePolicy.DropLocation.None) break;
                    ++n3;
                }
                return hasValidAdoptions ? result : ItemMovePolicy.DropLocation.None;
            }

            private boolean isClosed(IWorkItem workItem, ResolvedPlan plan) {
                if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) && plan.getProjectAreaHandle().sameItemId((IItemHandle)workItem.getProjectArea())) {
                    return plan.getCombinedWorkflowInfos().getStateGroup(workItem.getState2()) == 2;
                }
                return false;
            }
        });
    }

    @Override
    public boolean drop(IStructuredSelection sourceSelection, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, DropTargetEvent event, IProgressService progressService) {
        final OutlineEntry<GroupElement> groupEntry = targetEntry.getModel().readModel(new ModelReadRunnable<OutlineEntry<GroupElement>, RuntimeException>(){

            @Override
            public OutlineEntry<GroupElement> run(IOutlineModelReader readAccessor) throws RuntimeException {
                return readAccessor.getEntryNavigator(true).parentEntryOfType(targetEntry, GroupElement.class);
            }
        });
        boolean result = this.doResolveAndDrop(sourceSelection, new IPlanItemAttributeSetter(){

            public String getWorkItemTypeIdentifier() {
                return null;
            }

            public void setAttributes(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", 1);
                try {
                    if (!planItem.isResolved()) {
                        ((GroupElement)groupEntry.getElement()).adopt((PlanElement)planItem, groupEntry, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        Object element = targetEntry.getElement();
                        if (element instanceof PlanItem) {
                            PlanItem before = location == ItemMovePolicy.DropLocation.After ? (PlanItem)element : null;
                            PlanItem after = location == ItemMovePolicy.DropLocation.Before ? (PlanItem)element : null;
                            planItem.schedule(before, after);
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, this.getViewModel(targetEntry), event, progressService);
        if (result) {
            this.doSelect(sourceSelection, groupEntry);
        }
        return result;
    }

    @Override
    public boolean canIncreaseIndent(OutlineEntry<?> entry) {
        return false;
    }

    @Override
    public void increaseIndent(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canDecreaseIndent(OutlineEntry<?> entry) {
        return false;
    }

    @Override
    public void decreaseIndent(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canMoveUp(OutlineEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return false;
        }
        PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return false;
        }
        ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        try {
            return sequenceManager.getIndexOf(item) > 0;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    @Override
    public void moveUp(OutlineEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final PlanItem[] scheduleBefore = new PlanItem[1];
        sequenceManager.executeLocked(new Runnable(){

            public void run() {
                int scheduleIndex = sequenceManager.getIndexOf(item);
                if (scheduleIndex > 0) {
                    scheduleBefore[0] = sequenceManager.getAt(scheduleIndex - 1);
                }
            }
        });
        if (scheduleBefore[0] == null) {
            return;
        }
        sequenceManager.schedule(item, null, scheduleBefore[0]);
        this.getViewModel(entry).setSelectedElements(new PlanElement[]{item});
    }

    @Override
    public boolean canMoveDown(OutlineEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return false;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return false;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final boolean[] result = new boolean[1];
        sequenceManager.executeLocked(new Runnable(){

            public void run() {
                try {
                    result[0] = sequenceManager.getIndexOf(item) < sequenceManager.getUnresolvedItemCount() - 1;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        });
        return result[0];
    }

    @Override
    public void moveDown(OutlineEntry<?> entry) {
        if (!(entry.getElement() instanceof PlanItem)) {
            return;
        }
        final PlanItem item = (PlanItem)entry.getElement();
        if (item.isResolved() || item.getScheduledTime() == null || item.getOwner().equals((Object)item.getPlan().getNullOwner())) {
            return;
        }
        final ItemSequenceManager sequenceManager = item.getSequenceManager();
        Assert.isNotNull((Object)sequenceManager);
        final PlanItem[] scheduleAfter = new PlanItem[1];
        sequenceManager.executeLocked(new Runnable(){

            public void run() {
                int scheduleIndex = sequenceManager.getIndexOf(item);
                if (sequenceManager.getIndexOf(item) < sequenceManager.getUnresolvedItemCount() - 1) {
                    scheduleAfter[0] = sequenceManager.getAt(scheduleIndex + 1);
                }
            }
        });
        if (scheduleAfter[0] == null) {
            return;
        }
        sequenceManager.schedule(item, scheduleAfter[0], null);
        this.getViewModel(entry).setSelectedElements(new PlanElement[]{item});
    }

    @Override
    public boolean canAddItemAbove(OutlineEntry<?> entry) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        PlanItem planItem = (PlanItem)entry.getElement();
        return !planItem.isResolved() && planItem.getScheduledTime() != null;
    }

    @Override
    public void addItemAbove(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, true, context);
    }

    @Override
    public boolean canAddItemBelow(OutlineEntry<?> entry) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        PlanItem planItem = (PlanItem)entry.getElement();
        return !planItem.isResolved() && planItem.getScheduledTime() != null;
    }

    @Override
    public void addItemBelow(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, false, context);
    }

    @Override
    public boolean canAddItemToGroup(OutlineEntry<GroupElement> groupEntry) {
        TimeSpanDefinition timeSpan;
        if (!super.canAddItemToGroup(groupEntry)) {
            return false;
        }
        GroupElement group = groupEntry.getElement();
        ResolvedPlan plan = this.getPlan(groupEntry);
        return !(group instanceof TimeElement) || (timeSpan = ((TimeElement)group).getTimeSpan()) == TimeSpanDefinition.UNSCHEDULED || timeSpan != null && timeSpan.getEndTime().after(plan.getReferenceTime());
    }

    private void addSibling(final OutlineEntry<PlanItem> entry, final String workItemType, final boolean before, final IRunnableContext context) throws TeamRepositoryException {
        final ResolvedPlan plan = this.getPlan(entry);
        final PlanViewModel viewModel = (PlanViewModel)entry.getModel();
        viewModel.updateModel(new ModelUpdateRunnable<Void, TeamRepositoryException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws TeamRepositoryException {
                OutlineEntry<?> candidateEntry;
                EntryNavigator n = updateAccessor.getEntryNavigator(true);
                Object parentElement = n.parentElement(entry);
                final PlanItem sibling = (PlanItem)entry.getElement();
                PlanElement modelParent = parentElement instanceof PlanElement ? (PlanElement)parentElement : plan;
                final OutlineEntry<GroupElement> groupEntry = n.parentEntryOfType(entry, GroupElement.class);
                OutlineEntry<?> successorEntry = entry;
                if (!before && EntryUtils.isType(candidateEntry = n.successorEntry(entry), PlanElement.class)) {
                    successorEntry = candidateEntry;
                }
                SequenceItemMovePolicy.this.addItem(viewModel, modelParent, new IPlanItemAttributeSetter(){

                    public String getWorkItemTypeIdentifier() {
                        return workItemType;
                    }

                    public void setAttributes(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
                        ((GroupElement)groupEntry.getElement()).adopt((PlanElement)item, groupEntry, monitor);
                        Assert.isTrue((boolean)item.getOwner().sameItemId((IItemHandle)sibling.getOwner()));
                        if (sibling.getCategory() != null) {
                            item.setCategory(sibling.getCategory());
                        }
                        if (sibling.getScheduledTime() != null) {
                            item.schedule(before ? null : sibling, before ? sibling : null);
                        } else {
                            item.markAsNewItem(sibling.isNewItem());
                        }
                    }
                }, successorEntry, updateAccessor, context);
                return null;
            }
        });
    }
}

