/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.OutplaceLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelRebuilder;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.DefaultRootElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanModelTransformer
implements IModelTransformer<ResolvedPlan, PlanViewModel> {
    protected static final Collection<GroupElement[]> NO_GROUP = Collections.singleton(new GroupElement[0]);
    protected static final Object[] EMPTY_PATH = new Object[0];
    protected static final EntryTag[] NO_TAGS = new EntryTag[0];
    protected static final EntryTag[] DEFAULT_TAGS = new EntryTag[]{PrimaryLocationTag.INSTANCE};
    private final List<Attribute> fStructureAttributes;
    private final int fStructureAttributesCount;
    private PlanViewModel fViewModel;
    private ResolvedPlan fPlan;
    private final IPlanElementListener fListener;
    private Map<PlanElement, ElementInfo> fElementInfos = new HashMap<PlanElement, ElementInfo>();

    public PlanModelTransformer(Collection<Attribute> structureAttributes) {
        this.fStructureAttributes = Collections.unmodifiableList(new ArrayList<Attribute>(structureAttributes));
        this.fStructureAttributesCount = this.fStructureAttributes.size();
        this.fListener = new PlanElementListener();
    }

    public List<OutlineEntry<?>> getElementsToExpandInitially() {
        return (List)this.fViewModel.readModel(new ModelReadRunnable<List<OutlineEntry<?>>, RuntimeException>(){

            @Override
            public List<OutlineEntry<?>> run(IOutlineModelReader reader) {
                OutlineEntry<?> rootEntry = reader.getRootEntry();
                return rootEntry != null ? reader.getChildren(rootEntry) : Collections.EMPTY_LIST;
            }
        });
    }

    public LocationMarker calculateLocationMarker(OutlineEntry<?> entry) {
        if (EntryUtils.isType(entry, PlanItem.class) && ((PlanItem)entry.getElement()).isAuxiliaryPlanItem()) {
            return new OutplaceLocationMarker((PlanItem)entry.getElement());
        }
        return null;
    }

    protected ResolvedPlan getPlan() {
        return this.fPlan;
    }

    protected PlanViewModel getViewModel() {
        return this.fViewModel;
    }

    @Override
    public void inputChanged(PlanViewModel model, ResolvedPlan newInput) {
        this.fViewModel = model;
        if (this.fPlan != null) {
            this.fPlan.removeListener(this.fListener);
        }
        this.fPlan = newInput;
        this.fElementInfos.clear();
        if (this.fPlan != null) {
            this.fPlan.addListener(this.fListener);
        }
    }

    @Override
    public void refreshModel(IOutlineModelRebuilder rebuilder) {
        this.onBeginRefresh();
        try {
            this.fElementInfos.clear();
            rebuilder.createRootEntry(this.getRootGroup());
            for (GroupElement[] defaultGroup : this.getDefaultGroups()) {
                Assert.isTrue((defaultGroup.length > 0 ? 1 : 0) != 0);
                Object[] path = new Object[defaultGroup.length - 1];
                System.arraycopy(defaultGroup, 0, path, 0, defaultGroup.length - 1);
                rebuilder.addEntry(path, defaultGroup[defaultGroup.length - 1]);
            }
            Collection<? extends PlanElement> allPlanElements = this.getAllPlanElements();
            for (PlanElement planElement : allPlanElements) {
                ElementInfo pathElementInfo = new ElementInfo(planElement);
                this.fElementInfos.put(planElement, pathElementInfo);
            }
            for (PlanElement planElement : allPlanElements) {
                if (!this.isElementInitiallyIncluded(planElement)) continue;
                ArrayList<ElementInfo> path = new ArrayList<ElementInfo>();
                PlanElement pathElement = planElement;
                while (pathElement != null && !(pathElement instanceof ResolvedPlan)) {
                    ElementInfo pathElementInfo = this.fElementInfos.get(pathElement);
                    Assert.isNotNull((Object)pathElementInfo);
                    path.add(pathElementInfo);
                    pathElement = pathElement.getParent();
                }
                this.doAddElement(path, rebuilder);
            }
            rebuilder.executeAfterUpdate(new Runnable(){

                public void run() {
                    PlanModelTransformer.this.fViewModel.expandEntries(PlanModelTransformer.this.getElementsToExpandInitially());
                }
            });
        }
        finally {
            this.onEndRefresh();
        }
    }

    protected void onBeginRefresh() {
    }

    protected void onEndRefresh() {
    }

    protected Collection<? extends PlanElement> getAllPlanElements() {
        return this.getPlan().getAllPlanItems();
    }

    protected boolean isElementInitiallyIncluded(PlanElement element) {
        return this.isElementIncluded(element) && (!(element instanceof PlanItem) || ((PlanItem)element).isPrimaryPlanItem());
    }

    protected boolean isElementIncluded(PlanElement element) {
        return element instanceof PlanItem;
    }

    protected GroupElement getRootGroup() {
        return DefaultRootElement.INSTANCE;
    }

    protected Collection<GroupElement[]> getDefaultGroups() {
        return Collections.EMPTY_LIST;
    }

    protected Collection<GroupElement[]> getGroups(List<ElementInfo> elementInfoPath) {
        return NO_GROUP;
    }

    protected List<PlanElement> doTransformElementPath(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        ArrayList<PlanElement> result = new ArrayList<PlanElement>(elementInfoPath.size() - 1);
        int i = elementInfoPath.size() - 1;
        while (i > 0) {
            result.add(elementInfoPath.get(i).getPlanElement());
            --i;
        }
        return result;
    }

    protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        return DEFAULT_TAGS;
    }

    private Object[] calculatePath(GroupElement[] groupPath, List<ElementInfo> elementInfoPath) {
        ArrayList<PlanElement> path = new ArrayList<PlanElement>((Collection)Arrays.asList(groupPath));
        path.addAll(this.doTransformElementPath(groupPath, elementInfoPath));
        return path.toArray();
    }

    protected void aboutToRefreshModel(IOutlineModelReader reader) {
    }

    protected void doElementAdded(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
    }

    protected void doElementRemoved(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
    }

    protected void doElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IOutlineModelUpdater updateAccessor) {
    }

    protected void doElementChanged(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
    }

    protected boolean doProcessPlanChanged(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        return true;
    }

    private boolean processElementAdded(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        this.doAddElement(this.getElementInfoPath(delta, true), updateAccessor);
        this.doElementAdded(delta, updateAccessor);
        return true;
    }

    private boolean processElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IOutlineModelUpdater updateAccessor) {
        Assert.isTrue((removeDelta.getOtherMoveDelta() == addDelta && addDelta.getOtherMoveDelta() == removeDelta ? 1 : 0) != 0);
        Assert.isTrue((removeDelta.getPlanElement() == addDelta.getPlanElement() ? 1 : 0) != 0);
        this.recomputeSubtree(removeDelta, addDelta, updateAccessor);
        this.doElementMoved(removeDelta, addDelta, updateAccessor);
        return true;
    }

    private boolean processElementRemoved(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        this.doRemoveElement(this.getElementInfoPath(delta, false), updateAccessor);
        this.doElementRemoved(delta, updateAccessor);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processElementChanged(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        boolean visitChildren = true;
        boolean needsUpdate = false;
        if (delta.isContentChange()) {
            IPlanAttributeDelta[] iPlanAttributeDeltaArray = delta.getAttributeDeltas();
            int n = iPlanAttributeDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
                if (this.fStructureAttributes.contains(attributeDelta.getAttribute())) {
                    if (this.getElementInfo(delta, false).equals(this.getElementInfo(delta, true))) break;
                    this.recomputeSubtree(delta, delta, updateAccessor);
                    visitChildren = false;
                    break;
                }
                ++n2;
            }
            needsUpdate = true;
        }
        if (delta.affectsAttribute(PlanElement.PROBLEM_REPORT)) {
            needsUpdate = true;
        }
        this.doElementChanged(delta, updateAccessor);
        if (needsUpdate) {
            void var7_8;
            IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
            String[] attributes = new String[deltas.length];
            boolean bl = false;
            while (var7_8 < deltas.length) {
                attributes[var7_8] = deltas[var7_8].getAttribute().getName();
                ++var7_8;
            }
            for (OutlineEntry outlineEntry : updateAccessor.getElementEntries(delta.getPlanElement())) {
                updateAccessor.update(outlineEntry, attributes);
            }
        }
        return visitChildren;
    }

    private void recomputeSubtree(IPlanElementDelta oldDelta, IPlanElementDelta newDelta, final IOutlineModelUpdater updateAccessor) {
        EntryNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement planElement = oldDelta.getPlanElement();
        OutlineEntry<PlanElement> sourceEntry = n.findPrimaryEntry(planElement);
        Assert.isNotNull(sourceEntry);
        ModelSnapshotNode structureSnapshot = new ModelSnapshotNode(sourceEntry, updateAccessor);
        structureSnapshot.walkSnapshot(newDelta, true, new ISnapshotVisitor(){

            @Override
            public void visit(List<ElementInfo> elementInfoPath) {
                PlanModelTransformer.this.doAddElement(elementInfoPath, updateAccessor);
            }
        });
        structureSnapshot.walkSnapshot(oldDelta, false, new ISnapshotVisitor(){

            @Override
            public void visit(List<ElementInfo> elementInfoPath) {
                PlanModelTransformer.this.doRemoveElement(elementInfoPath, updateAccessor);
            }
        });
    }

    private OutlineEntry<PlanElement> doAddElement(List<ElementInfo> elementInfoPath, IOutlineModelUpdater updateAccessor) {
        Assert.isLegal((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
        EntryNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        OutlineEntry<PlanElement> result = null;
        for (GroupElement[] groupPath : this.getGroups(elementInfoPath)) {
            OutlineEntry<GroupElement> candidateParent;
            boolean shouldExpandGroup = groupPath.length > 0 && !updateAccessor.containsElement(groupPath[groupPath.length - 1]);
            OutlineEntry<PlanElement> newEntry = updateAccessor.addEntry(this.calculatePath(groupPath, elementInfoPath), element);
            EntryTag[] entryTagArray = this.doCalculateTags(groupPath, elementInfoPath);
            int n2 = entryTagArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EntryTag tag = entryTagArray[n3];
                updateAccessor.setTag(newEntry, tag);
                ++n3;
            }
            if (newEntry.hasTag(PrimaryLocationTag.INSTANCE)) {
                result = newEntry;
            }
            if ((candidateParent = n.parentEntryOfType(newEntry, GroupElement.class)) != null && !candidateParent.isRootEntry()) {
                updateAccessor.update(candidateParent, null);
            }
            if (!shouldExpandGroup) continue;
            final OutlineEntry<GroupElement> toExpand = n.parentEntryOfType(newEntry, GroupElement.class);
            updateAccessor.executeAfterUpdate(new Runnable(){

                public void run() {
                    PlanModelTransformer.this.fViewModel.setEntryExpandState(toExpand, true);
                }
            });
        }
        return result;
    }

    private void doRemoveElement(List<ElementInfo> elementInfoPath, IOutlineModelUpdater updateAccessor) {
        Assert.isLegal((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
        EntryNavigator n = updateAccessor.getEntryNavigator(false);
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        block0: for (GroupElement[] groupPath : this.getGroups(elementInfoPath)) {
            Object[] path = this.calculatePath(groupPath, elementInfoPath);
            Collection<OutlineEntry<PlanElement>> candidateEntries = updateAccessor.getElementEntries(element);
            for (OutlineEntry<PlanElement> candidateEntry : candidateEntries) {
                boolean pathEqual = true;
                OutlineEntry<?> chainEntry = n.parentEntry(candidateEntry);
                int level = path.length - 1;
                while (pathEqual && level >= 0 && chainEntry != null) {
                    pathEqual &= path[level--].equals(chainEntry.getElement());
                    chainEntry = n.parentEntry(chainEntry);
                }
                if (!pathEqual || level != -1 || n.parentEntry(chainEntry) != null) continue;
                OutlineEntry<GroupElement> candidateParent = n.parentEntryOfType(candidateEntry, GroupElement.class);
                if (candidateParent != null && !candidateParent.isRootEntry()) {
                    updateAccessor.update(candidateParent, null);
                }
                EntryTag[] entryTagArray = this.doCalculateTags(groupPath, elementInfoPath);
                int n2 = entryTagArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    EntryTag tag = entryTagArray[n3];
                    updateAccessor.clearTag(candidateEntry, tag);
                    ++n3;
                }
                updateAccessor.removeEntry(candidateEntry);
                continue block0;
            }
        }
    }

    protected DeltaKind computeDeltaKind(IPlanElementDelta delta, IOutlineModelReader readAccessor) {
        DeltaKind result = DeltaKind.Ignore;
        if (delta.isAdded()) {
            result = DeltaKind.Added;
        } else if (delta.isRemoved()) {
            result = DeltaKind.Removed;
        } else if (delta.isChanged()) {
            result = DeltaKind.Changed;
        }
        PlanElement element = delta.getPlanElement();
        boolean wasIncluded = !readAccessor.getElementEntries(element).isEmpty();
        boolean isIncluded = this.isElementIncluded(element);
        if (result == DeltaKind.Added && !isIncluded) {
            result = DeltaKind.Ignore;
        } else if (result == DeltaKind.Removed && !wasIncluded) {
            result = DeltaKind.Ignore;
        } else if (result == DeltaKind.Changed) {
            IPlanAttributeDelta[] attributeDeltas = delta.getAttributeDeltas();
            boolean isProblemChangeOnly = attributeDeltas.length == 1 && PlanItem.PROBLEM_REPORT.equals(attributeDeltas[0].getAttribute());
            if (wasIncluded != isIncluded && (isProblemChangeOnly &= !delta.isStructuralChange())) {
                result = DeltaKind.Ignore;
            } else if (wasIncluded && !isIncluded) {
                result = DeltaKind.Removed;
            } else if (!wasIncluded && isIncluded) {
                result = DeltaKind.Added;
            } else if (!wasIncluded && !isIncluded) {
                result = DeltaKind.Ignore;
            }
        }
        return result;
    }

    protected List<ElementInfo> getElementInfoPath(IPlanElementDelta delta, boolean newValues) {
        ArrayList<ElementInfo> result = new ArrayList<ElementInfo>();
        while (delta != null && !(delta.getPlanElement() instanceof ResolvedPlan)) {
            result.add(this.getElementInfo(delta, newValues));
            delta = delta.getParentDelta();
        }
        return result;
    }

    protected ElementInfo getElementInfo(IPlanElementDelta delta, boolean newValues) {
        PlanElement planElement = delta.getPlanElement();
        ElementInfo elementInfo = this.fElementInfos.get(planElement);
        if (elementInfo == null) {
            elementInfo = new ElementInfo(planElement);
        }
        return elementInfo.update(delta, newValues);
    }

    private boolean hasStructuralChange(IPlanElementDelta delta) {
        for (Attribute attribue : this.fStructureAttributes) {
            if (delta.getAttributeDelta(attribue) == null) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$3(PlanModelTransformer planModelTransformer, IPlanElementDelta iPlanElementDelta, IOutlineModelUpdater iOutlineModelUpdater) {
        return planModelTransformer.processElementAdded(iPlanElementDelta, iOutlineModelUpdater);
    }

    static /* synthetic */ boolean access$4(PlanModelTransformer planModelTransformer, IPlanElementDelta iPlanElementDelta, IPlanElementDelta iPlanElementDelta2, IOutlineModelUpdater iOutlineModelUpdater) {
        return planModelTransformer.processElementMoved(iPlanElementDelta, iPlanElementDelta2, iOutlineModelUpdater);
    }

    static /* synthetic */ boolean access$5(PlanModelTransformer planModelTransformer, IPlanElementDelta iPlanElementDelta, IOutlineModelUpdater iOutlineModelUpdater) {
        return planModelTransformer.processElementRemoved(iPlanElementDelta, iOutlineModelUpdater);
    }

    static /* synthetic */ boolean access$6(PlanModelTransformer planModelTransformer, IPlanElementDelta iPlanElementDelta, IOutlineModelUpdater iOutlineModelUpdater) {
        return planModelTransformer.processElementChanged(iPlanElementDelta, iOutlineModelUpdater);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DeltaKind {
        Added,
        Removed,
        Changed,
        Ignore,
        Refresh;

    }

    protected class ElementInfo {
        private final PlanElement fPlanElement;
        private final Object[] fStructureValues;

        public ElementInfo(PlanElement planElement) {
            this.fPlanElement = planElement;
            this.fStructureValues = new Object[PlanModelTransformer.this.fStructureAttributesCount];
            int i = 0;
            while (i < PlanModelTransformer.this.fStructureAttributesCount) {
                this.fStructureValues[i] = ((Attribute)PlanModelTransformer.this.fStructureAttributes.get(i)).getValue((Object)planElement);
                ++i;
            }
        }

        private ElementInfo(ElementInfo source, IPlanElementDelta delta, boolean newValue) {
            this.fPlanElement = source.fPlanElement;
            this.fStructureValues = new Object[PlanModelTransformer.this.fStructureAttributesCount];
            System.arraycopy(source.fStructureValues, 0, this.fStructureValues, 0, PlanModelTransformer.this.fStructureAttributesCount);
            int i = 0;
            while (i < PlanModelTransformer.this.fStructureAttributesCount) {
                IPlanAttributeDelta attributeDelta = delta.getAttributeDelta((Attribute)PlanModelTransformer.this.fStructureAttributes.get(i));
                if (attributeDelta != null) {
                    this.fStructureValues[i] = newValue ? attributeDelta.getNewValue() : attributeDelta.getOldValue();
                }
                ++i;
            }
        }

        public ElementInfo update(IPlanElementDelta delta, boolean newValue) {
            return new ElementInfo(this, delta, newValue);
        }

        public PlanElement getPlanElement() {
            return this.fPlanElement;
        }

        public Object[] getStructureValues() {
            return this.fStructureValues;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ElementInfo other = (ElementInfo)obj;
            return this.fPlanElement.equals(other.fPlanElement) && Arrays.equals(this.fStructureValues, other.fStructureValues);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ISnapshotVisitor {
        public void visit(List<ElementInfo> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelSnapshotNode {
        private final boolean fIsAddedExplicitly;
        private final ElementInfo fElementInfo;
        private final List<ModelSnapshotNode> fChildren;

        public ModelSnapshotNode(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
            this.fIsAddedExplicitly = entry.isAddedExplicitly();
            this.fElementInfo = (ElementInfo)PlanModelTransformer.this.fElementInfos.get(entry.getElement());
            EntryNavigator n = readAccessor.getEntryNavigator(false);
            this.fChildren = new ArrayList<ModelSnapshotNode>();
            for (OutlineEntry<?> childEntry : n.childEntries(entry)) {
                this.fChildren.add(new ModelSnapshotNode(childEntry, readAccessor));
            }
        }

        public void walkSnapshot(IPlanElementDelta delta, boolean newValues, ISnapshotVisitor visitor) {
            Assert.isTrue((boolean)this.fElementInfo.getPlanElement().equals(delta.getPlanElement()));
            this.accept(visitor, delta, newValues, new LinkedList<ElementInfo>(PlanModelTransformer.this.getElementInfoPath(delta, newValues)));
        }

        private void accept(ISnapshotVisitor visitor, IPlanElementDelta delta, boolean newValues, LinkedList<ElementInfo> elementInfoPath) {
            if (this.fIsAddedExplicitly) {
                visitor.visit(elementInfoPath);
            }
            for (ModelSnapshotNode childNode : this.fChildren) {
                PlanElementDelta childDelta;
                PlanElementDelta planElementDelta = childDelta = delta != null ? delta.getChild(childNode.fElementInfo.getPlanElement()) : null;
                if (childDelta != null && PlanModelTransformer.this.hasStructuralChange((IPlanElementDelta)childDelta)) {
                    elementInfoPath.addFirst(PlanModelTransformer.this.getElementInfo((IPlanElementDelta)childDelta, newValues));
                } else {
                    elementInfoPath.addFirst(childNode.fElementInfo);
                }
                childNode.accept(visitor, (IPlanElementDelta)childDelta, newValues, elementInfoPath);
                elementInfoPath.removeFirst();
            }
        }
    }

    private class PlanElementListener
    implements IPlanElementListener {
        private PlanElementListener() {
        }

        public void planElementChanged(final IPlanElementChangeEvent event) {
            PlanModelTransformer.this.fViewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){
                boolean refreshModel = false;

                @Override
                public Void run(final IOutlineModelUpdater updateAccessor) {
                    event.getDelta().accept(new IPlanElementDeltaVisitor(){
                        private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind;

                        /*
                         * Unable to fully structure code
                         */
                        public boolean visit(IPlanElementDelta delta) {
                            block21: {
                                block22: {
                                    block23: {
                                        if (refreshModel) {
                                            return false;
                                        }
                                        visitChildren = true;
                                        try {
                                            if (!(delta.getPlanElement() instanceof ResolvedPlan) || !delta.isChanged()) break block21;
                                            var5_3 = PlanElementListener.access$1(1.access$1(this)).doProcessPlanChanged(delta, updateAccessor);
                                            if (refreshModel) break block22;
                                            if (!visitChildren) break block23;
                                        }
                                        catch (Throwable var4_8) {
                                            if (!refreshModel) {
                                                if (visitChildren) {
                                                    planElement = delta.getPlanElement();
                                                    if (!(planElement instanceof ResolvedPlan)) {
                                                        PlanModelTransformer.access$2(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                                    }
                                                } else {
                                                    delta.accept(new IPlanElementDeltaVisitor(){

                                                        public boolean visit(IPlanElementDelta delta) {
                                                            PlanModelTransformer.this.fElementInfos.put(delta.getPlanElement(), PlanModelTransformer.this.getElementInfo(delta, true));
                                                            return true;
                                                        }
                                                    });
                                                }
                                            }
                                            throw var4_8;
                                        }
                                        planElement = delta.getPlanElement();
                                        if (!(planElement instanceof ResolvedPlan)) {
                                            PlanModelTransformer.access$2(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                        }
                                        break block22;
                                    }
                                    delta.accept(new /* invalid duplicate definition of identical inner class */);
                                }
                                return var5_3;
                            }
                            otherMoveDelta = delta.getOtherMoveDelta();
                            switch (PlanElementListener.1.$SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind()[PlanElementListener.access$1(1.access$1(this)).computeDeltaKind(delta, updateAccessor).ordinal()]) {
                                case 1: {
                                    if (otherMoveDelta == null) {
                                        visitChildren = PlanModelTransformer.access$3(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                        ** break;
                                    }
                                    visitChildren = PlanModelTransformer.access$4(PlanElementListener.access$1(1.access$1(this)), otherMoveDelta, delta, updateAccessor);
                                    ** break;
                                }
                                case 2: {
                                    if (otherMoveDelta == null) {
                                        visitChildren = PlanModelTransformer.access$5(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                        ** break;
                                    }
                                    break;
                                }
                                case 3: {
                                    visitChildren = PlanModelTransformer.access$6(PlanElementListener.access$1(1.access$1(this)), delta, updateAccessor);
                                    ** break;
                                }
                                case 5: {
                                    refreshModel = true;
                                    visitChildren = false;
                                }
                            }
                            if (!refreshModel) {
                                if (visitChildren) {
                                    planElement = delta.getPlanElement();
                                    if (!(planElement instanceof ResolvedPlan)) {
                                        PlanModelTransformer.access$2(PlanElementListener.access$1(1.access$1(this))).put(planElement, PlanElementListener.access$1(1.access$1(this)).getElementInfo(delta, true));
                                    }
                                } else {
                                    delta.accept(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            return visitChildren;
                        }

                        static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind() {
                            if ($SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind != null) {
                                return $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind;
                            }
                            int[] nArray = new int[DeltaKind.values().length];
                            try {
                                nArray[DeltaKind.Added.ordinal()] = 1;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Changed.ordinal()] = 3;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Ignore.ordinal()] = 4;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Refresh.ordinal()] = 5;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            try {
                                nArray[DeltaKind.Removed.ordinal()] = 2;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {}
                            $SWITCH_TABLE$com$ibm$team$apt$internal$ide$ui$common$structure$PlanModelTransformer$DeltaKind = nArray;
                            return nArray;
                        }
                    });
                    if (this.refreshModel) {
                        PlanModelTransformer.this.aboutToRefreshModel(updateAccessor);
                        PlanModelTransformer.this.fViewModel.viewerPreservingRefresh();
                    }
                    return null;
                }
            });
        }
    }
}

