/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.SiblingInitializer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalItemMovePolicy
extends ItemMovePolicy {
    @Override
    public ItemMovePolicy.DropLocation validateDrop(final IStructuredSelection sourceSelection, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, DropTargetEvent event) {
        return targetEntry.getModel().readModel(new ModelReadRunnable<ItemMovePolicy.DropLocation, RuntimeException>(){

            @Override
            public ItemMovePolicy.DropLocation run(IOutlineModelReader readAccessor) throws RuntimeException {
                EntryNavigator n = readAccessor.getEntryNavigator(true);
                ItemMovePolicy.DropLocation result = location;
                boolean hasValidAdoptions = false;
                Object target = targetEntry.getElement();
                Object[] objectArray = sourceSelection.toArray();
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object nextSibling;
                    boolean canHaveChildren;
                    boolean isParentGroup;
                    Object parentElement;
                    Object source = objectArray[n3];
                    if (HierarchicalItemMovePolicy.this.isIncompatibleProjectArea(source, targetEntry)) {
                        result = ItemMovePolicy.DropLocation.None;
                    } else if (source instanceof IContributor) {
                        if (HierarchicalItemMovePolicy.this.isIncompatibleTeamRepository(source, targetEntry)) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (sourceSelection.size() > 1) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (!(target instanceof PlanItem) || location != ItemMovePolicy.DropLocation.Onto) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else {
                            hasValidAdoptions = true;
                        }
                    } else if (source instanceof IWorkItemHandle) {
                        if (location != ItemMovePolicy.DropLocation.Onto) {
                            if (!(target instanceof PlanItem)) {
                                result = ItemMovePolicy.DropLocation.None;
                            } else {
                                parentElement = n.parentElement(targetEntry);
                                isParentGroup = parentElement instanceof GroupElement;
                                canHaveChildren = HierarchicalItemMovePolicy.this.canHaveChildren(parentElement);
                                if (isParentGroup || canHaveChildren) {
                                    if (canHaveChildren && HierarchicalItemMovePolicy.this.isWorkItemParentOfTarget((IWorkItemHandle)source, (PlanItem)parentElement)) {
                                        result = ItemMovePolicy.DropLocation.None;
                                    } else {
                                        nextSibling = location == ItemMovePolicy.DropLocation.Before ? n.predecessor(targetEntry) : n.successor(targetEntry);
                                        if (nextSibling == null || nextSibling instanceof PlanItem && !((IWorkItemHandle)source).sameItemId((IItemHandle)((PlanItem)nextSibling).getWorkItemHandle())) {
                                            hasValidAdoptions = true;
                                        }
                                    }
                                }
                            }
                        } else if (target instanceof PlanItem && !HierarchicalItemMovePolicy.this.canHaveChildren(target)) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (target instanceof PlanItem && HierarchicalItemMovePolicy.this.isWorkItemParentOfTarget((IWorkItemHandle)source, (PlanItem)target)) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else {
                            hasValidAdoptions = true;
                        }
                    } else if (source instanceof PlanItem) {
                        if (((PlanItem)source).isProgressPlanItem()) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (location != ItemMovePolicy.DropLocation.Onto) {
                            if (!(target instanceof PlanItem)) {
                                result = ItemMovePolicy.DropLocation.None;
                            } else {
                                parentElement = n.parentElement(targetEntry);
                                isParentGroup = parentElement instanceof GroupElement;
                                canHaveChildren = HierarchicalItemMovePolicy.this.canHaveChildren(parentElement);
                                if (isParentGroup || canHaveChildren) {
                                    if (canHaveChildren && HierarchicalItemMovePolicy.this.isPlanItemParentOfTarget((PlanItem)source, (PlanItem)parentElement)) {
                                        result = ItemMovePolicy.DropLocation.None;
                                    } else {
                                        nextSibling = location == ItemMovePolicy.DropLocation.Before ? n.predecessor(targetEntry) : n.successor(targetEntry);
                                        if (nextSibling == null || nextSibling instanceof PlanItem && !((PlanItem)source).getWorkItemHandle().sameItemId((IItemHandle)((PlanItem)nextSibling).getWorkItemHandle())) {
                                            hasValidAdoptions = true;
                                        }
                                    }
                                }
                            }
                        } else if (target instanceof PlanItem && !HierarchicalItemMovePolicy.this.canHaveChildren(target)) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else if (target instanceof PlanItem && HierarchicalItemMovePolicy.this.isPlanItemParentOfTarget((PlanItem)source, (PlanItem)target)) {
                            result = ItemMovePolicy.DropLocation.None;
                        } else {
                            hasValidAdoptions = true;
                        }
                    }
                    if (result == ItemMovePolicy.DropLocation.None) break;
                    ++n3;
                }
                return hasValidAdoptions ? result : ItemMovePolicy.DropLocation.None;
            }
        });
    }

    @Override
    public boolean drop(IStructuredSelection sourceSelection, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, DropTargetEvent event, IProgressService progressService) {
        final ResolvedPlan plan = this.getPlan(targetEntry);
        if (sourceSelection.size() == 1 && sourceSelection.getFirstElement() instanceof IContributor) {
            IContributor contributor = (IContributor)sourceSelection.getFirstElement();
            Assert.isTrue((boolean)(targetEntry.getElement() instanceof PlanItem));
            ((PlanItem)targetEntry.getElement()).setOwner(contributor);
            return true;
        }
        boolean result = this.doResolveAndDrop(sourceSelection, new IPlanItemAttributeSetter(){

            public String getWorkItemTypeIdentifier() {
                return null;
            }

            public void setAttributes(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
                HierarchicalItemMovePolicy.this.doDrop(plan, targetEntry, location, planItem, monitor);
            }
        }, this.getViewModel(targetEntry), event, progressService);
        if (result) {
            OutlineEntry<GroupElement> groupEntry = targetEntry.getModel().readModel(new ModelReadRunnable<OutlineEntry<GroupElement>, RuntimeException>(){

                @Override
                public OutlineEntry<GroupElement> run(IOutlineModelReader readAccessor) throws RuntimeException {
                    return readAccessor.getEntryNavigator(true).parentEntryOfType(targetEntry, GroupElement.class);
                }
            });
            this.doSelect(sourceSelection, groupEntry);
        }
        return result;
    }

    @Override
    public boolean canIncreaseIndent(final OutlineEntry<?> entry) {
        if (!this.isPlanItemInPrimaryGroup(entry)) {
            return false;
        }
        return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

            @Override
            public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                Object previous = readAccessor.getEntryNavigator(true).predecessor(entry);
                return previous instanceof PlanItem;
            }
        });
    }

    @Override
    public void increaseIndent(final OutlineEntry<?> entry) {
        final PlanViewModel viewModel = this.getViewModel(entry);
        viewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                HierarchicalItemMovePolicy.this.preservingEditor(entry, updateAccessor, new PreservingEditorRunnable(){

                    public OutlineEntry<PlanElement> run(OutlineEntry<PlanElement> entry, IOutlineModelUpdater updateAccessor) {
                        PlanElement planElement = entry.getElement();
                        EntryNavigator n = updateAccessor.getEntryNavigator(true);
                        final OutlineModel.ExpansionHull expansionHull = viewModel.getExpansionHull(entry);
                        OutlineEntry<?> predecessorEntry = n.predecessorEntry(entry);
                        OutlineEntry<PlanElement> newPrimaryEntry = null;
                        if (EntryUtils.isType(predecessorEntry, PlanItem.class)) {
                            PlanItem newParentItem = (PlanItem)predecessorEntry.getElement();
                            planElement.moveTo((PlanElement)newParentItem);
                            newPrimaryEntry = n.findPrimaryEntry(planElement);
                        }
                        final OutlineEntry<PlanElement> finalNewPrimaryEntry = newPrimaryEntry;
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                if (finalNewPrimaryEntry != null) {
                                    viewModel.setExpansionHull(finalNewPrimaryEntry, expansionHull);
                                    viewModel.revealEntry(finalNewPrimaryEntry);
                                    viewModel.setSelectedEntry(finalNewPrimaryEntry);
                                }
                            }
                        });
                        return finalNewPrimaryEntry;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public boolean canDecreaseIndent(final OutlineEntry<?> entry) {
        if (!this.isPlanItemInPrimaryGroup(entry)) {
            return false;
        }
        return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

            @Override
            public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                EntryNavigator n = readAccessor.getEntryNavigator(true);
                if (!((PlanItem)entry.getElement()).isProgressPlanItem() && EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void decreaseIndent(final OutlineEntry<?> entry) {
        final PlanViewModel viewModel = this.getViewModel(entry);
        viewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                HierarchicalItemMovePolicy.this.preservingEditor(entry, updateAccessor, new PreservingEditorRunnable(){

                    @Override
                    public OutlineEntry<? extends PlanElement> run(OutlineEntry<PlanElement> entry, IOutlineModelUpdater updateAccessor) {
                        PlanElement planElement = entry.getElement();
                        EntryNavigator n = updateAccessor.getEntryNavigator(true);
                        final OutlineModel.ExpansionHull expansionHull = viewModel.getExpansionHull(entry);
                        OutlineEntry<?> newParentEntry = n.parentEntry(entry, 2);
                        int targetIndex = n.index(n.parentEntry(entry)) + 1;
                        ArrayList<PlanElement> siblingsToMove = new ArrayList<PlanElement>();
                        OutlineEntry<?> candidateEntry = n.successorEntry(entry);
                        while (candidateEntry != null) {
                            if (EntryUtils.isType(candidateEntry, PlanElement.class)) {
                                siblingsToMove.add((PlanElement)candidateEntry.getElement());
                            }
                            candidateEntry = n.successorEntry(candidateEntry);
                        }
                        if (EntryUtils.isType(newParentEntry, PlanElement.class)) {
                            planElement.moveTo((PlanElement)newParentEntry.getElement());
                        } else if (EntryUtils.isType(newParentEntry, GroupElement.class)) {
                            planElement.moveTo((PlanElement)planElement.getPlan());
                        }
                        final OutlineEntry<PlanElement> primaryEntry = n.findPrimaryEntry(planElement);
                        Assert.isTrue((primaryEntry != null && n.parentEntry(primaryEntry) == newParentEntry ? 1 : 0) != 0);
                        if (primaryEntry != null) {
                            updateAccessor.move(primaryEntry, targetIndex);
                        }
                        for (PlanElement siblingToMove : siblingsToMove) {
                            siblingToMove.moveTo(planElement);
                        }
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                viewModel.setExpansionHull(primaryEntry, expansionHull);
                                viewModel.revealEntry(primaryEntry);
                                viewModel.setSelectedEntry(primaryEntry);
                            }
                        });
                        return primaryEntry;
                    }
                });
                return null;
            }
        });
    }

    @Override
    public boolean canMoveUp(final OutlineEntry<?> entry) {
        if (!this.isPlanItemInPrimaryGroup(entry)) {
            return false;
        }
        return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

            @Override
            public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                EntryNavigator n = readAccessor.getEntryNavigator(true);
                if (n.isFirst(entry) && !EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public void moveUp(final OutlineEntry<?> entry) {
        final PlanViewModel viewModel = this.getViewModel(entry);
        viewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                final OutlineEntry toReveal = HierarchicalItemMovePolicy.this.preservingEditor(entry, updateAccessor, new PreservingEditorRunnable(){

                    @Override
                    public OutlineEntry<? extends PlanElement> run(OutlineEntry<PlanElement> entry, IOutlineModelUpdater updateAccessor) {
                        PlanItem planItem = (PlanItem)entry.getElement();
                        EntryNavigator n = updateAccessor.getEntryNavigator(true);
                        OutlineEntry<?> predecessorEntry = n.predecessorEntry(entry);
                        if (EntryUtils.isType(predecessorEntry, PlanElement.class)) {
                            updateAccessor.move(entry, n.index(predecessorEntry));
                            return entry;
                        }
                        OutlineEntry<?> parentEntry = n.parentEntry(entry, 1);
                        OutlineEntry<?> grandParentEntry = n.parentEntry(entry, 2);
                        if (EntryUtils.isType(parentEntry, PlanElement.class)) {
                            int newIndex = n.index(parentEntry);
                            if (EntryUtils.isType(grandParentEntry, PlanElement.class)) {
                                planItem.moveTo((PlanElement)grandParentEntry.getElement());
                            } else if (EntryUtils.isType(grandParentEntry, GroupElement.class)) {
                                planItem.moveTo((PlanElement)planItem.getPlan());
                            }
                            OutlineEntry<PlanItem> primaryEntry = n.findPrimaryEntry(planItem);
                            Assert.isTrue((primaryEntry != null && n.parentEntry(primaryEntry) == grandParentEntry ? 1 : 0) != 0);
                            updateAccessor.move(primaryEntry, newIndex);
                            return primaryEntry;
                        }
                        OutlineEntry<Object> newGroupEntry = null;
                        if (EntryUtils.isType(predecessorEntry, GroupElement.class)) {
                            newGroupEntry = predecessorEntry;
                        } else if (EntryUtils.isType(parentEntry, GroupElement.class)) {
                            OutlineEntry<?> candidateEntry = n.predecessorEntry(parentEntry);
                            while (candidateEntry != null) {
                                if (EntryUtils.isType(candidateEntry, GroupElement.class)) {
                                    newGroupEntry = candidateEntry;
                                    break;
                                }
                                candidateEntry = n.predecessorEntry(candidateEntry);
                            }
                            if (newGroupEntry != null) {
                                OutlineEntry<GroupElement> lastChildGroup;
                                while ((lastChildGroup = EntryUtils.lastEntryOfType(n.childEntries(newGroupEntry), GroupElement.class)) != null) {
                                    newGroupEntry = lastChildGroup;
                                }
                            } else if (newGroupEntry == null && EntryUtils.isType(grandParentEntry, GroupElement.class)) {
                                newGroupEntry = grandParentEntry;
                            }
                        }
                        if (newGroupEntry == null) {
                            return null;
                        }
                        int index = n.index(EntryUtils.lastEntryOfType(n.childEntries(newGroupEntry), PlanElement.class));
                        planItem.moveTo((PlanElement)planItem.getPlan());
                        ((GroupElement)newGroupEntry.getElement()).adopt((PlanElement)planItem, newGroupEntry, (IProgressMonitor)new NullProgressMonitor());
                        OutlineEntry<PlanItem> primaryEntry = n.findPrimaryEntry(planItem);
                        Assert.isTrue((primaryEntry != null && n.parentEntry(primaryEntry) == newGroupEntry ? 1 : 0) != 0);
                        updateAccessor.move(primaryEntry, index != -1 ? index + 1 : 0);
                        return primaryEntry;
                    }
                });
                if (toReveal != null) {
                    updateAccessor.executeAfterUpdate(new Runnable(){

                        public void run() {
                            viewModel.revealEntry(toReveal);
                            viewModel.setSelectedEntry(toReveal);
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public boolean canMoveDown(final OutlineEntry<?> entry) {
        if (!this.isPlanItemInPrimaryGroup(entry)) {
            return false;
        }
        return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

            @Override
            public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                return !readAccessor.getEntryNavigator(true).isLast(entry);
            }
        });
    }

    @Override
    public void moveDown(final OutlineEntry<?> entry) {
        final PlanViewModel viewModel = this.getViewModel(entry);
        viewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                final OutlineEntry toReveal = HierarchicalItemMovePolicy.this.preservingEditor(entry, updateAccessor, new PreservingEditorRunnable(){

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public OutlineEntry<? extends PlanElement> run(OutlineEntry<PlanElement> entry, IOutlineModelUpdater updateAccessor) {
                        block9: {
                            planItem = (PlanItem)entry.getElement();
                            n = updateAccessor.getEntryNavigator(true);
                            successorEntry = n.successorEntry(entry);
                            if (EntryUtils.isType(successorEntry, PlanElement.class)) {
                                updateAccessor.move(entry, n.index(successorEntry) + 1);
                                return entry;
                            }
                            parentEntry = n.parentEntry(entry, 1);
                            grandParentEntry = n.parentEntry(entry, 2);
                            if (EntryUtils.isType(parentEntry, PlanElement.class)) {
                                newIndex = n.index(parentEntry) + 1;
                                if (EntryUtils.isType(grandParentEntry, PlanElement.class)) {
                                    planItem.moveTo((PlanElement)grandParentEntry.getElement());
                                } else if (EntryUtils.isType(grandParentEntry, GroupElement.class)) {
                                    planItem.moveTo((PlanElement)planItem.getPlan());
                                }
                                primaryEntry = n.findPrimaryEntry(planItem);
                                Assert.isTrue((boolean)(primaryEntry != null && n.parentEntry(primaryEntry) == grandParentEntry));
                                updateAccessor.move(primaryEntry, newIndex);
                                return primaryEntry;
                            }
                            newGroupEntry = null;
                            if (!EntryUtils.isType(successorEntry, GroupElement.class)) ** GOTO lbl34
                            newGroupEntry = successorEntry;
                            break block9;
lbl-1000:
                            // 1 sources

                            {
                                candidateEntry = null;
                                candidateEntry = n.successorEntry(parentEntry);
                                while (candidateEntry != null) {
                                    if (EntryUtils.isType(candidateEntry, GroupElement.class)) {
                                        newGroupEntry = candidateEntry;
                                        break;
                                    }
                                    candidateEntry = n.successorEntry(candidateEntry);
                                }
                                parentEntry = n.parentEntry(parentEntry);
lbl34:
                                // 2 sources

                                ** while (newGroupEntry == null && EntryUtils.isType(parentEntry, GroupElement.class))
                            }
                        }
                        if (newGroupEntry == null) {
                            return null;
                        }
                        index = n.index(EntryUtils.firstEntryOfType(n.childEntries(newGroupEntry), PlanElement.class));
                        planItem.moveTo((PlanElement)planItem.getPlan());
                        ((GroupElement)newGroupEntry.getElement()).adopt((PlanElement)planItem, newGroupEntry, (IProgressMonitor)new NullProgressMonitor());
                        primaryEntry = n.findPrimaryEntry(planItem);
                        Assert.isTrue((boolean)(primaryEntry != null && n.parentEntry(primaryEntry) == newGroupEntry));
                        updateAccessor.move(primaryEntry, index != -1 ? index : 0);
                        return primaryEntry;
                    }
                });
                if (toReveal != null) {
                    updateAccessor.executeAfterUpdate(new Runnable(){

                        public void run() {
                            viewModel.revealEntry(toReveal);
                            viewModel.setSelectedEntry(toReveal);
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public boolean canAddItemAbove(OutlineEntry<?> entry) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        return true;
    }

    @Override
    public void addItemAbove(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, true, context);
    }

    @Override
    public boolean canAddItemBelow(OutlineEntry<?> entry) {
        Assert.isLegal((boolean)(entry.getElement() instanceof PlanItem));
        return true;
    }

    @Override
    public void addItemBelow(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        this.addSibling(entry, workItemType, false, context);
    }

    private void addSibling(final OutlineEntry<PlanItem> entry, final String workItemType, final boolean above, final IRunnableContext context) throws TeamRepositoryException {
        final ResolvedPlan plan = this.getPlan(entry);
        final PlanViewModel viewModel = (PlanViewModel)entry.getModel();
        viewModel.updateModel(new ModelUpdateRunnable<Void, TeamRepositoryException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws TeamRepositoryException {
                EntryNavigator n = updateAccessor.getEntryNavigator(true);
                Object parentElement = n.parentElement(entry);
                final PlanItem initializerSource = HierarchicalItemMovePolicy.this.computeInitializerSource(entry, n);
                PlanElement modelParent = parentElement instanceof PlanElement ? (PlanElement)parentElement : plan;
                final OutlineEntry<GroupElement> groupEntry = n.parentEntryOfType(entry, GroupElement.class);
                OutlineEntry<?> successorEntry = entry;
                if (!above) {
                    OutlineEntry<?> candidateEntry = n.successorEntry(entry);
                    while (candidateEntry != null && !EntryUtils.isType(candidateEntry, PlanElement.class)) {
                        candidateEntry = n.successorEntry(candidateEntry);
                    }
                    successorEntry = candidateEntry;
                }
                HierarchicalItemMovePolicy.this.addItem(viewModel, modelParent, new IPlanItemAttributeSetter(){

                    public String getWorkItemTypeIdentifier() {
                        return workItemType;
                    }

                    public void setAttributes(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
                        monitor.beginTask(Messages.HierarchicalItemMovePolicy_JOB_INITIALIZE_WORKITEM, 2);
                        try {
                            if (initializerSource != null) {
                                new SiblingInitializer(initializerSource).setAttributes(item, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            ((GroupElement)groupEntry.getElement()).adopt((PlanElement)item, groupEntry, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, successorEntry, updateAccessor, context);
                return null;
            }
        });
    }

    private PlanItem computeInitializerSource(OutlineEntry<PlanItem> entry, EntryNavigator n) {
        PlanItem planItem = entry.getElement();
        if (!planItem.isProgressPlanItem()) {
            return planItem;
        }
        OutlineEntry<?> p = n.parentEntry(entry);
        while (EntryUtils.isType(p, PlanItem.class) && ((PlanItem)p.getElement()).isProgressPlanItem()) {
            p = n.parentEntry(p);
        }
        if (p.getElement() instanceof PlanItem) {
            return (PlanItem)p.getElement();
        }
        return null;
    }

    private OutlineEntry<? extends PlanElement> preservingEditor(OutlineEntry<PlanElement> entry, IOutlineModelUpdater updateAccessor, PreservingEditorRunnable code) {
        PlanViewModel viewModel = this.getViewModel(entry);
        final PlanItemOutlineViewer viewer = (PlanItemOutlineViewer)viewModel.getViewer();
        final PlanCanvas outline = viewModel.getViewer().getOutline();
        AbstractTextEditor editor = outline.getCurrentTextEditor();
        boolean editingElementToBeIndented = false;
        String id = null;
        Point editorSelection = null;
        if (editor != null) {
            outline.storeData();
            editorSelection = editor.getSelection();
            editingElementToBeIndented = entry.equals(editor.getEntry());
            id = editor.getOwner().getId();
        }
        final OutlineEntry<? extends PlanElement> newEntry = code.run(entry, updateAccessor);
        if (editingElementToBeIndented && newEntry != null) {
            final Point finalSelection = editorSelection;
            final String finalId = id;
            updateAccessor.executeAfterUpdate(new Runnable(){

                public void run() {
                    OutlineItem newItem = viewer.findOutlineItem(newEntry);
                    PlanItemGadget content = (PlanItemGadget)newItem.getContent();
                    ((ITextEditor)outline.startEditSession(HierarchicalItemMovePolicy.this.getOwner(content, finalId))).setSelection(finalSelection);
                    viewer.startEditSession(newEntry);
                }
            });
        }
        return newEntry;
    }

    private GText getOwner(PlanItemGadget content, String id) {
        if ("summary".equals(id)) {
            return content.getSummary();
        }
        if ("description".equals(id)) {
            return content.getDescription();
        }
        return null;
    }

    private boolean isWorkItemParentOfTarget(IWorkItemHandle workItem, PlanItem target) {
        PlanItem subject = target;
        while (subject instanceof PlanItem) {
            if (subject.getWorkItemHandle().getItemId().equals((Object)workItem.getItemId())) {
                return true;
            }
            subject = subject.getParent();
        }
        return false;
    }

    private boolean isPlanItemParentOfTarget(PlanItem source, PlanItem target) {
        PlanItem current = target;
        while (current instanceof PlanItem) {
            if (current.getWorkItemHandle().sameItemId((IItemHandle)source.getWorkItemHandle())) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private boolean canHaveChildren(Object target) {
        if (!(target instanceof PlanItem)) {
            return false;
        }
        return ((PlanItem)target).canHaveChildren();
    }

    private boolean doDrop(final ResolvedPlan plan, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, final PlanItem sourcePlanItem, final IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 2);
        try {
            Assert.isNotNull((Object)sourcePlanItem);
            Assert.isLegal((boolean)(plan instanceof ResolvedIterationPlan));
            PlanViewModel viewModel = this.getViewModel(targetEntry);
            boolean bl = viewModel.updateModel(new ModelUpdateRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(true);
                    OutlineEntry<GroupElement> groupEntry = n.parentEntryOfType(targetEntry, GroupElement.class);
                    if (groupEntry != null) {
                        groupEntry.getElement().adopt((PlanElement)sourcePlanItem, groupEntry, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (location != ItemMovePolicy.DropLocation.Onto) {
                        int newIndex = n.index(targetEntry);
                        Object newParentElement = n.parentElement(targetEntry);
                        sourcePlanItem.moveTo((PlanElement)(newParentElement instanceof PlanElement ? (PlanElement)newParentElement : plan));
                        OutlineEntry<PlanItem> entry = n.findFirstEntryInSubtree(sourcePlanItem, groupEntry);
                        Assert.isTrue((n.parentEntry(entry) == n.parentEntry(targetEntry) ? 1 : 0) != 0);
                        if (location == ItemMovePolicy.DropLocation.After) {
                            ++newIndex;
                        }
                        if (newIndex >= 0 && newIndex < n.siblingEntries(entry).size()) {
                            updateAccessor.move(entry, newIndex);
                        }
                    } else if (EntryUtils.isType(targetEntry, PlanItem.class)) {
                        sourcePlanItem.moveTo((PlanElement)((PlanItem)targetEntry.getElement()));
                    }
                    return true;
                }
            });
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PreservingEditorRunnable {
        public OutlineEntry<? extends PlanElement> run(OutlineEntry<PlanElement> var1, IOutlineModelUpdater var2);
    }
}

