/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.quickquery.IParsedQuickQueryElement;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParsedAttributePredicate;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParsedKeywordPredicate;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickQueryHelper {
    public static Expression buildExpression(String query, IQuickQueryDefinition definition, IQuickQueryContext context, IProgressMonitor monitor) {
        return QuickQueryHelper.buildExpression(new QuickQueryParser(query).iterator(), definition, context, monitor);
    }

    public static Expression buildExpression(Iterator<IParsedQuickQueryElement> parsedQueryIterator, IQuickQueryDefinition definition, IQuickQueryContext context, IProgressMonitor monitor) {
        monitor.beginTask(Messages.QuickQueryHelper_MONITOR_BUILDING_EXPRESSION, -1);
        try {
            Term result = new Term(0, null);
            HashMap<IQuickQueryAttribute, Term> combinedAttributes = new HashMap<IQuickQueryAttribute, Term>();
            while (parsedQueryIterator.hasNext()) {
                IParsedQuickQueryElement parsedElement = parsedQueryIterator.next();
                try {
                    ParsedAttributePredicate parsedAttribute;
                    String attributeName;
                    IQuickQueryAttribute quickQueryAttribute;
                    Expression expression = null;
                    if (parsedElement instanceof ParsedKeywordPredicate) {
                        String word = ((ParsedKeywordPredicate)parsedElement).getKeyword();
                        expression = definition.buildWordExpression(context, word, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else if (parsedElement instanceof ParsedAttributePredicate && (quickQueryAttribute = definition.findAttribute(context, attributeName = (parsedAttribute = (ParsedAttributePredicate)parsedElement).getAttributeName())) != null && (expression = quickQueryAttribute.buildExpression(parsedAttribute.getOperator(), parsedAttribute.getParameter(), (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null && quickQueryAttribute.getAttributeCombination() == IQuickQueryAttribute.Mode.Or) {
                        Term term = (Term)combinedAttributes.get(quickQueryAttribute);
                        if (term == null) {
                            term = new Term(1, null);
                            combinedAttributes.put(quickQueryAttribute, term);
                        }
                        term.add(expression);
                        expression = null;
                    }
                    if (expression != null) {
                        result.add(expression);
                    }
                }
                catch (TeamRepositoryException e) {
                    PlanningUIPlugin.log(NLS.bind((String)"Failed to create filter for predicate [{0}]", (Object[])new Object[]{parsedElement.getInputSection().toString()}), e);
                }
                for (Term term : combinedAttributes.values()) {
                    result.add((Expression)term);
                }
            }
            Term term = result.getExpressions().isEmpty() ? null : result;
            return term;
        }
        finally {
            monitor.done();
        }
    }
}

