/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractSelectQuickColorizeColorAction;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryParticipant;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorizer;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryModeSelectionAction;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryTextField;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.common.expression.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.actions.ActionFactory;

public class QuickQueryBar
implements IActionProvider {
    private final IQuickQueryDefinition fQuickQueryDefinition;
    private final IQuickQueryContext fContext;
    private List<IQuickQueryParticipant> fParticipants = new ArrayList<IQuickQueryParticipant>();
    private QuickQueryMode fCurrentMode = QuickQueryMode.Find;
    private List<IQuickQueryParticipant> fCurrentParticipants = new ArrayList<IQuickQueryParticipant>();
    private Map<String, Action> fActions = new HashMap<String, Action>();
    private QuickQueryModeSelectionAction fModeSelectionAction = new QuickQueryModeSelectionAction(){

        @Override
        protected Collection<QuickQueryMode> getAvailableModes() {
            return Arrays.asList(QuickQueryMode.values());
        }

        @Override
        protected QuickQueryMode getCurrentMode() {
            return QuickQueryBar.this.fCurrentMode;
        }

        @Override
        protected void setCurrentMode(QuickQueryMode mode) {
            QuickQueryBar.this.setMode(mode);
        }
    };
    private ResourceManager fResourceManager;
    private Composite fQuickQueryArea;
    private QuickQueryTextField fQuickQueryInput;
    private ActionContributionItem fModeSelectionItem;
    private ToolItem[] fActionToolbarItems;
    private ToolBar fActionToolBar;

    public QuickQueryBar(Composite parent, IQuickQueryDefinition quickQueryDefinition, IQuickQueryContext context) {
        this.fContext = context;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fQuickQueryDefinition = quickQueryDefinition;
        this.initAction(new QuickFindAction(), ActionFactory.FIND.getId());
        this.initAction(new FindNextAction(), ActionFactory.NEXT.getId());
        this.initAction(new FindPreviousAction(), ActionFactory.PREVIOUS.getId());
        this.initAction(new QuickFilterAction(), "com.ibm.team.apt.actions.quickquery.filter");
        this.initAction(new QuickColorizeAction(), "com.ibm.team.apt.actions.quickquery.colorize");
        this.initAction(new SelectQuickColorizeColorAction(parent.getShell()), "com.ibm.team.apt.actions.quickquery.colorize.color");
        this.createQuickFilterArea(parent);
    }

    public void registerParticipant(IQuickQueryParticipant participant) {
        this.fParticipants.add(participant);
        if (this.fCurrentMode != null && this.fCurrentMode.equals((Object)participant.getMode())) {
            this.fCurrentParticipants.add(participant);
            participant.setEnabled(true);
        }
    }

    public void unregisterParticipant(IQuickQueryParticipant participant) {
        this.fParticipants.remove(participant);
        this.fCurrentParticipants.remove(participant);
        participant.setEnabled(false);
    }

    public void showQuickQuery(QuickQueryMode mode) {
        this.fQuickQueryArea.setVisible(true);
        this.fQuickQueryInput.getControl().setFocus();
        ((GridData)this.fQuickQueryArea.getLayoutData()).exclude = false;
        this.fQuickQueryArea.getParent().layout();
    }

    public void hideQuickQuery() {
        this.fQuickQueryArea.setVisible(false);
        ((GridData)this.fQuickQueryArea.getLayoutData()).exclude = true;
        this.fQuickQueryArea.getParent().layout();
        this.fQuickQueryInput.setText("");
    }

    public boolean isShown() {
        return this.fQuickQueryArea.getVisible();
    }

    public QuickQueryMode getCurrentMode() {
        return this.fCurrentMode;
    }

    public boolean isActive(QuickQueryMode mode) {
        if (!mode.equals((Object)this.fCurrentMode)) {
            return false;
        }
        for (IQuickQueryParticipant participant : this.fCurrentParticipants) {
            if (participant.isInstalled()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.fResourceManager.dispose();
        for (Action action : this.fActions.values()) {
            if (!(action instanceof IMenuCreator)) continue;
            ((IMenuCreator)action).dispose();
        }
    }

    public Action getAction(String id) {
        return this.fActions.get(id);
    }

    public Action[] getActions() {
        Collection<Action> values = this.fActions.values();
        return values.toArray(new Action[values.size()]);
    }

    private void initAction(Action action, String id) {
        action.setActionDefinitionId(id);
        action.setId(id);
        if (id != null) {
            this.fActions.put(id, action);
        }
    }

    private void setMode(QuickQueryMode mode) {
        for (IQuickQueryParticipant participant : this.fCurrentParticipants) {
            participant.setEnabled(false);
        }
        this.fCurrentMode = mode;
        this.fCurrentParticipants.clear();
        if (this.fCurrentMode != null) {
            for (IQuickQueryParticipant participant : this.fParticipants) {
                if (!this.fCurrentMode.equals((Object)participant.getMode())) continue;
                this.fCurrentParticipants.add(participant);
                participant.setEnabled(true);
                participant.setExpression(this.fQuickQueryInput.getFilterExpression((IProgressMonitor)new NullProgressMonitor()));
            }
            this.fQuickQueryInput.setExecutionDelay(this.fCurrentMode.getDelay());
        }
        this.fModeSelectionItem.update();
        this.updateModeSpecificToolbar();
    }

    public Control getControl() {
        return this.fQuickQueryArea;
    }

    private void createQuickFilterArea(Composite parent) {
        this.fQuickQueryArea = new Composite(parent, 0);
        this.fQuickQueryArea.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.fQuickQueryArea);
        ((GridData)this.fQuickQueryArea.getLayoutData()).exclude = true;
        this.fQuickQueryArea.setVisible(false);
        this.fQuickQueryArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (QuickQueryBar.this.fQuickQueryArea.isDisposed()) {
                    return;
                }
                GC gc = e.gc;
                Rectangle clArea = QuickQueryBar.this.fQuickQueryArea.getClientArea();
                gc.setForeground(gc.getDevice().getSystemColor(18));
                gc.drawLine(clArea.x, clArea.y, clArea.x + clArea.width, clArea.y);
                gc.setForeground(gc.getDevice().getSystemColor(20));
                gc.drawLine(clArea.x, clArea.y + 1, clArea.x + clArea.width, clArea.y + 1);
            }
        });
        GridLayoutFactory.fillDefaults().margins(3, 0).extendedMargins(0, 0, 4, 2).numColumns(3).applyTo(this.fQuickQueryArea);
        ToolBar queryTypeBar = new ToolBar(this.fQuickQueryArea, 0x820000);
        queryTypeBar.setBackground(this.fQuickQueryArea.getBackground());
        queryTypeBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        this.fModeSelectionItem = new ActionContributionItem((IAction)this.fModeSelectionAction);
        this.fModeSelectionItem.fill(queryTypeBar, 0);
        queryTypeBar.pack();
        this.fQuickQueryInput = new QuickQueryTextField(this.fQuickQueryArea, this.fQuickQueryDefinition, this.fContext);
        this.fQuickQueryInput.addListener(new IQuickQueryListener(){

            public void evaluateQuery(Expression expression) {
                for (IQuickQueryParticipant participant : QuickQueryBar.this.fCurrentParticipants) {
                    participant.setExpression(expression);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).indent(4, 0).align(4, 0x1000000).applyTo((Control)this.fQuickQueryInput.getControl());
        this.fQuickQueryInput.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    QuickQueryBar.this.hideQuickQuery();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fActionToolBar = new ToolBar(this.fQuickQueryArea, 0x820000);
        this.fActionToolBar.setBackground(this.fQuickQueryArea.getBackground());
        this.fActionToolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        if ((this.fQuickQueryInput.getControl().getStyle() & 0x100) == 0) {
            ToolItem clearItem = new ToolItem(this.fActionToolBar, 8);
            clearItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.QUICKFILTER_CLEAR_ICON));
            clearItem.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.QUICKFILTER_CLEAR_ICON_DISABLED));
            clearItem.setToolTipText(Messages.QuickQueryBar_CLEAR);
            clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QuickQueryBar.this.fQuickQueryInput.setText("");
                }
            });
            this.attachEnablementListener(clearItem);
        }
        ToolItem closeButton = new ToolItem(this.fActionToolBar, 8);
        closeButton.setImage(this.fResourceManager.createImage(ImagePool.QUICKFILTER_CLOSE));
        closeButton.setHotImage(this.fResourceManager.createImage(ImagePool.QUICKFILTER_CLOSE_HOT));
        closeButton.setToolTipText(Messages.QuickQueryBar_CLOSE_TOOLTIP);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickQueryBar.this.hideQuickQuery();
            }
        });
        this.updateModeSpecificToolbar();
        this.fQuickQueryInput.addListener(new IQuickQueryListener(){

            public void evaluateQuery(final Expression expression) {
                UI.asyncExec((Control)QuickQueryBar.this.fQuickQueryInput.getControl(), new Runnable(){

                    public void run() {
                        Action[] actionArray = QuickQueryBar.this.getActions();
                        int n = actionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Action action = actionArray[n2];
                            if (action instanceof IQuickQueryAction) {
                                ((IQuickQueryAction)action).update(expression);
                            }
                            ++n2;
                        }
                    }
                });
            }
        });
    }

    private void updateModeSpecificToolbar() {
        ToolItem item;
        int n;
        int n2;
        ToolItem[] toolItemArray;
        if (this.fActionToolbarItems != null) {
            toolItemArray = this.fActionToolbarItems;
            n2 = this.fActionToolbarItems.length;
            n = 0;
            while (n < n2) {
                item = toolItemArray[n];
                item.dispose();
                ++n;
            }
        }
        this.fActionToolbarItems = null;
        switch (this.fCurrentMode) {
            case Find: {
                toolItemArray = this.fActionToolbarItems = new ToolItem[]{this.addActionToolItem(ActionFactory.PREVIOUS.getId()), this.addActionToolItem(ActionFactory.NEXT.getId())};
                n2 = this.fActionToolbarItems.length;
                n = 0;
                while (n < n2) {
                    item = toolItemArray[n];
                    this.attachEnablementListener(item);
                    ++n;
                }
                break;
            }
            case Colorize: {
                this.fActionToolbarItems = new ToolItem[]{this.addActionToolItem("com.ibm.team.apt.actions.quickquery.colorize.color")};
            }
        }
        this.fActionToolBar.pack();
        this.fQuickQueryArea.layout(true);
    }

    private void attachEnablementListener(final ToolItem item) {
        item.setEnabled(this.fQuickQueryInput.getCurrentExpression() != null);
        final IQuickQueryListener enableListener = new IQuickQueryListener(){

            public void evaluateQuery(final Expression expression) {
                if (!item.isDisposed()) {
                    item.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!item.isDisposed()) {
                                item.setEnabled(expression != null);
                            }
                        }
                    });
                }
            }
        };
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QuickQueryBar.this.fQuickQueryInput.removeListener(enableListener);
            }
        });
        this.fQuickQueryInput.addListener(enableListener);
    }

    private ToolItem addActionToolItem(String actionId) {
        final Action action = this.getAction(actionId);
        int flags = 8;
        if (action.getStyle() == 4) {
            flags = 4;
        }
        final ToolItem result = new ToolItem(this.fActionToolBar, flags, 1);
        result.setImage(this.fResourceManager.createImage(action.getImageDescriptor()));
        result.setToolTipText(action.getToolTipText());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu m;
                IMenuCreator mc;
                if (e.detail == 4 && action.getStyle() == 4 && (mc = action.getMenuCreator()) != null && (m = mc.getMenu((Control)result.getParent())) != null) {
                    Rectangle b = result.getBounds();
                    Point p = result.getParent().toDisplay(new Point(b.x, b.y + b.height));
                    UI.showAndDisposeMenu(m, p);
                    return;
                }
                action.run();
            }
        });
        return result;
    }

    private class FindNextAction
    extends Action
    implements IQuickQueryAction {
        public FindNextAction() {
            super(Messages.QuickQueryBar_FIND_NEXT, ImagePool.QUICKFILTER_FIND_NEXT);
            this.setToolTipText(Messages.QuickQueryBar_NEXT_TOOLTIP);
        }

        public void update(Expression expression) {
            this.setEnabled(QuickQueryBar.this.isActive(QuickQueryMode.Find) && expression != null);
        }

        public void run() {
            for (IQuickQueryParticipant participant : QuickQueryBar.this.fCurrentParticipants) {
                if (!(participant instanceof IQuickQueryEntryFinder)) continue;
                ((IQuickQueryEntryFinder)participant).findNext(true);
            }
        }
    }

    private class FindPreviousAction
    extends Action
    implements IQuickQueryAction {
        public FindPreviousAction() {
            super(Messages.QuickQueryBar_FIND_PREVIOUS, ImagePool.QUICKFILTER_FIND_PREVIOUS);
            this.setToolTipText(Messages.QuickQueryBar_PREVIOUS_TOOLTIP);
        }

        public void update(Expression expression) {
            this.setEnabled(QuickQueryBar.this.isActive(QuickQueryMode.Find) && expression != null);
        }

        public void run() {
            for (IQuickQueryParticipant participant : QuickQueryBar.this.fCurrentParticipants) {
                if (!(participant instanceof IQuickQueryEntryFinder)) continue;
                ((IQuickQueryEntryFinder)participant).findPrevious(true);
            }
        }
    }

    private static interface IQuickQueryAction
    extends IAction {
        public void update(Expression var1);
    }

    private class QuickColorizeAction
    extends Action {
        public QuickColorizeAction() {
            this.setToolTipText(Messages.QuickQueryBar_COLORIZE_TOOLTIP);
        }

        public void run() {
            QuickQueryBar.this.showQuickQuery(QuickQueryMode.Colorize);
        }
    }

    private class QuickFilterAction
    extends Action {
        public QuickFilterAction() {
            this.setToolTipText(Messages.QuickQueryBar_FILTER_TOOLTIP);
        }

        public void run() {
            QuickQueryBar.this.showQuickQuery(QuickQueryMode.Filter);
        }
    }

    private class QuickFindAction
    extends Action {
        public QuickFindAction() {
            this.setToolTipText(Messages.QuickQueryBar_FIND_TOOLTIP);
        }

        public void run() {
            QuickQueryBar.this.showQuickQuery(QuickQueryMode.Find);
        }
    }

    private class SelectQuickColorizeColorAction
    extends AbstractSelectQuickColorizeColorAction
    implements IQuickQueryAction {
        public SelectQuickColorizeColorAction(Shell shell) {
            super(shell, new RGB(255, 255, 0));
            this.setToolTipText(Messages.QuickQueryBar_SELECT_TOOLTIP);
        }

        public void update(Expression expression) {
            this.setEnabled(QuickQueryBar.this.isActive(QuickQueryMode.Colorize) && expression != null);
        }

        protected void colorChanged(RGB color) {
            for (IQuickQueryParticipant participant : QuickQueryBar.this.fCurrentParticipants) {
                if (!(participant instanceof QuickQueryColorizer)) continue;
                ((QuickQueryColorizer)participant).setColor(color);
            }
            QuickQueryBar.this.fActionToolbarItems[0].setImage(QuickQueryBar.this.fResourceManager.createImage(this.getImageDescriptor()));
        }
    }
}

