/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import java.util.regex.Pattern;

public class ProposalMatcher {
    private final Pattern fCamelCasePattern;
    private final String fLowerCaseInput;

    public ProposalMatcher(String input) {
        String lowerCaseInput = null;
        Pattern camelCasePattern = null;
        if (input != null && input.length() > 0) {
            StringBuilder camelCaseRegExBuilder = new StringBuilder();
            int i = 0;
            while (i < input.length()) {
                int start = i;
                while (++i < input.length() && Character.isLowerCase(input.charAt(i))) {
                }
                camelCaseRegExBuilder.append(Pattern.quote(input.substring(start, i--)));
                camelCaseRegExBuilder.append("[^A-Z]*");
                ++i;
            }
            camelCaseRegExBuilder.append(".*");
            camelCasePattern = Pattern.compile(camelCaseRegExBuilder.toString());
            lowerCaseInput = input.toLowerCase();
        }
        this.fCamelCasePattern = camelCasePattern;
        this.fLowerCaseInput = lowerCaseInput;
    }

    public boolean matches(String proposal) {
        if (this.fLowerCaseInput == null) {
            return true;
        }
        if (proposal.toLowerCase().startsWith(this.fLowerCaseInput)) {
            return true;
        }
        return this.fCamelCasePattern.matcher(proposal).matches();
    }
}

