/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.PlanExpression;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import java.util.Iterator;

public class ExpressionMatcherHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(PlanItem planItem, Expression expression) {
        try {
            if (expression instanceof AttributeExpression) {
                ResolvedPlan plan = planItem.getPlan();
                AttributeExpression attributeExpression = (AttributeExpression)expression;
                IAttribute attribute = this.getAttribute(plan.getTeamRepository(), (IProjectAreaHandle)plan.getProjectArea(), attributeExpression.getAttributeIdentifier());
                if (!planItem.isAttributeSet(attribute)) {
                    return false;
                }
                Object left = planItem.getAttributeValue(attribute);
                Object right = attributeExpression.getResolvedValue((IEvaluationContext)new ClientEvaluationContext((IProjectAreaHandle)plan.getProjectArea()), null);
                return attributeExpression.getOperation().evaluate(left, right);
            }
            if (expression instanceof PlanExpression) {
                PlanExpression planExpression = (PlanExpression)expression;
                Object left = planExpression.getAttribute().getValue((Object)planItem);
                Object right = planExpression.getValue();
                return planExpression.getOperation().evaluate(left, right);
            }
            if (!(expression instanceof Term)) {
                throw new IllegalArgumentException(NLS.bind((String)"ViewerQuickFilter.matches: unexpected expression type: ", (Object[])new Object[]{expression.getClass().getName()}));
            }
            Term term = (Term)expression;
            switch (term.getOperator()) {
                case OR: {
                    Expression subExpression;
                    Iterator iterator = term.getExpressions().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return false;
                    } while (!this.matches(planItem, subExpression = (Expression)iterator.next()));
                    return true;
                }
                case AND: {
                    Expression subExpression;
                    Iterator iterator = term.getExpressions().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return true;
                    } while (this.matches(planItem, subExpression = (Expression)iterator.next()));
                    return false;
                }
            }
            throw new IllegalArgumentException("ViewerQuickFilter.matches: unexpected operator for Term");
        }
        catch (TeamRepositoryException e) {
            PlanningUIPlugin.log("Error evaluating expression", e);
            return false;
        }
    }

    private IAttribute getAttribute(ITeamRepository repository, IProjectAreaHandle projectArea, String identifier) throws TeamRepositoryException {
        IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        return client.findAttribute(projectArea, identifier, null);
    }
}

