/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractSelectQuickColorizeColorAction;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorSelectionImageDescriptor;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfiguration;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryTextField;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.common.expression.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorizeDialog
extends StatusDialog {
    private final IQuickQueryDefinition fQuickQueryDefinition;
    private final IQuickQueryContext fQuickQueryContext;
    private List<ColorizeConfiguration> fConfigurations;
    private Set<ColorizeConfiguration> fAdded = new HashSet<ColorizeConfiguration>();
    private Set<ColorizeConfiguration> fRemoved = new HashSet<ColorizeConfiguration>();
    private Set<ColorizeConfiguration> fChanged = new HashSet<ColorizeConfiguration>();
    private TableViewer fTableViewer;
    private ColorizeConfiguration fCurrentConfig;
    private Text fLabelField;
    private QuickQueryTextField fExpressionField;
    private Group fDetailGroup;
    private Button fEnableButton;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private SelectQuickColorizeColorAction fSelectColorAction;

    public ColorizeDialog(Shell parent, IQuickQueryDefinition queryDefiniton, final ResolvedPlan planContext, List<ColorizeConfiguration> configurations) {
        super(parent);
        this.fQuickQueryDefinition = queryDefiniton;
        this.fConfigurations = new ArrayList<ColorizeConfiguration>(configurations.size());
        for (ColorizeConfiguration configuration : configurations) {
            this.fConfigurations.add(new ColorizeConfiguration(configuration));
        }
        this.fQuickQueryContext = new IQuickQueryContext(){

            public IProjectAreaHandle getProjectArea() {
                return planContext.getProjectAreaHandle();
            }

            public Object getAdapter(Class adapter) {
                if (ResolvedPlan.class.equals((Object)adapter)) {
                    return planContext;
                }
                if (IProjectAreaHandle.class.equals((Object)adapter)) {
                    return this.getProjectArea();
                }
                return Platform.getAdapterManager().getAdapter((Object)this, adapter);
            }
        };
        this.setTitle(Messages.ColorizeDialog_TITLE);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public List<ColorizeConfiguration> getConfigurations() {
        return this.fConfigurations;
    }

    public Collection<ColorizeConfiguration> getAddedConfigurations() {
        return this.fAdded;
    }

    public Collection<ColorizeConfiguration> getChangedConfigurations() {
        return this.fChanged;
    }

    public Collection<ColorizeConfiguration> getRemovedConfigurations() {
        return this.fRemoved;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int width = Math.max(600, result.x);
        int height = Math.max((int)((double)width / 3.0) * 2, result.y);
        result.x = width;
        result.y = height;
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UI.hookHelpListener((Control)shell, "com.ibm.team.apt.ide.ui.dialog_colorize");
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        Composite tableGroup = new Composite(result, 0);
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(tableGroup);
        this.fTableViewer = new TableViewer(tableGroup, 68096);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        Table table = this.fTableViewer.getTable();
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.fTableViewer.setSorter((ViewerSorter)new ConfigurationSorter());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0x1000000);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(22));
        TableColumn labelColumn = new TableColumn(table, 0);
        labelColumn.setText(Messages.ColorizeDialog_COLUMN_LABEL);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn expression = new TableColumn(table, 0);
        expression.setText(Messages.ColorizeDialog_COLUMN_EXPRESSION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColorizeConfiguration config = (ColorizeConfiguration)((IStructuredSelection)event.getSelection()).getFirstElement();
                ColorizeDialog.this.setCurrentConfiguration(config);
            }
        });
        Composite buttonContainer = new Composite(tableGroup, 0);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        GridLayoutFactory.fillDefaults().applyTo(buttonContainer);
        this.fAddButton = new Button(buttonContainer, 0);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.setText(Messages.ColorizeDialog_BUTTON_ADD);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorizeConfiguration configuration = new ColorizeConfiguration();
                ColorizeDialog.this.added(configuration);
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 0);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.setText(Messages.ColorizeDialog_BUTTON_REMOVE);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorizeDialog.this.fCurrentConfig != null) {
                    ColorizeDialog.this.removed(ColorizeDialog.this.fCurrentConfig);
                }
            }
        });
        this.fUpButton = new Button(buttonContainer, 0);
        this.fUpButton.setLayoutData((Object)new GridData(768));
        this.fUpButton.setText(Messages.ColorizeDialog_BUTTON_UP);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorizeDialog.this.fCurrentConfig != null) {
                    int index = ColorizeDialog.this.fConfigurations.indexOf(ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.fConfigurations.remove(index);
                    ColorizeDialog.this.fConfigurations.add(index - 1, ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.fTableViewer.refresh();
                    ColorizeDialog.this.setCurrentConfiguration(ColorizeDialog.this.fCurrentConfig);
                }
            }
        });
        this.fDownButton = new Button(buttonContainer, 0);
        this.fDownButton.setLayoutData((Object)new GridData(768));
        this.fDownButton.setText(Messages.ColorizeDialog_BUTTON_DOWN);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorizeDialog.this.fCurrentConfig != null) {
                    int index = ColorizeDialog.this.fConfigurations.indexOf(ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.fConfigurations.remove(index);
                    ColorizeDialog.this.fConfigurations.add(index + 1, ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.fTableViewer.refresh();
                    ColorizeDialog.this.setCurrentConfiguration(ColorizeDialog.this.fCurrentConfig);
                }
            }
        });
        this.fDetailGroup = new Group(result, 0);
        this.fDetailGroup.setLayoutData((Object)new GridData(768));
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(7, LayoutConstants.getSpacing().y).applyTo((Composite)this.fDetailGroup);
        Label label = new Label((Composite)this.fDetailGroup, 0);
        label.setText(Messages.ColorizeDialog_LABEL_ENABLED);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fEnableButton = new Button((Composite)this.fDetailGroup, 32);
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 0x1000000).applyTo((Control)this.fEnableButton);
        this.fEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColorizeDialog.this.fCurrentConfig != null) {
                    ColorizeDialog.this.fCurrentConfig.setEnabled(ColorizeDialog.this.fEnableButton.getSelection());
                    ColorizeDialog.this.changed(ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.checkStatus();
                }
            }
        });
        label = new Label((Composite)this.fDetailGroup, 0);
        label.setText(Messages.ColorizeDialog_LABEL_LABEL);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fLabelField = new Text((Composite)this.fDetailGroup, 2048);
        this.fLabelField.setLayoutData((Object)new GridData(768));
        this.fLabelField.setEnabled(false);
        this.fLabelField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColorizeDialog.this.fCurrentConfig != null) {
                    ColorizeDialog.this.fCurrentConfig.setLabel(ColorizeDialog.this.fLabelField.getText());
                    ColorizeDialog.this.changed(ColorizeDialog.this.fCurrentConfig);
                    ColorizeDialog.this.checkStatus();
                }
            }
        });
        label = new Label((Composite)this.fDetailGroup, 0);
        label.setText(Messages.ColorizeDialog_LABEL_EXPRESSION);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fExpressionField = new QuickQueryTextField((Composite)this.fDetailGroup, this.fQuickQueryDefinition, this.fQuickQueryContext);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fExpressionField.getControl());
        this.fExpressionField.addListener(new IQuickQueryListener(){

            public void evaluateQuery(final Expression expression) {
                UI.syncExec((Control)ColorizeDialog.this.fExpressionField.getControl(), new Runnable(){

                    public void run() {
                        if (ColorizeDialog.this.fCurrentConfig != null) {
                            ColorizeDialog.this.fCurrentConfig.setQuery(ColorizeDialog.this.fExpressionField.getControl().getText());
                            ColorizeDialog.this.fCurrentConfig.setCachedExpression(expression);
                            ColorizeDialog.this.changed(ColorizeDialog.this.fCurrentConfig);
                            ColorizeDialog.this.checkStatus();
                        }
                    }
                });
            }
        });
        label = new Label((Composite)this.fDetailGroup, 0);
        label.setText(Messages.ColorizeDialog_LABEL_COLOR);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        ToolBar actionBar = new ToolBar((Composite)this.fDetailGroup, 0x804000);
        actionBar.setLayoutData((Object)new GridData(4, 16384, false, true));
        this.fSelectColorAction = new SelectQuickColorizeColorAction();
        new ActionContributionItem((IAction)this.fSelectColorAction).fill(actionBar, -1);
        this.fTableViewer.setInput(this.fConfigurations);
        this.setCurrentConfiguration(null);
        Dialog.applyDialogFont((Control)result);
        this.checkStatus();
        return result;
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.fConfigurations.size()) {
            ColorizeConfiguration configuration = this.fConfigurations.get(i);
            if (configuration.getPriority() != i) {
                configuration.setPriority(i);
                this.changed(configuration);
            }
            ++i;
        }
        super.okPressed();
    }

    private void setCurrentConfiguration(ColorizeConfiguration config) {
        int configIndex = this.fConfigurations.indexOf(config);
        Assert.isTrue((config == null || configIndex != -1 ? 1 : 0) != 0);
        this.fCurrentConfig = config;
        this.fDetailGroup.setEnabled(this.fCurrentConfig != null);
        this.fLabelField.setEnabled(this.fCurrentConfig != null);
        this.fExpressionField.getControl().setEnabled(this.fCurrentConfig != null);
        this.fSelectColorAction.setEnabled(this.fCurrentConfig != null);
        this.fRemoveButton.setEnabled(this.fCurrentConfig != null);
        this.fUpButton.setEnabled(this.fCurrentConfig != null && configIndex > 0);
        this.fDownButton.setEnabled(this.fCurrentConfig != null && configIndex < this.fConfigurations.size() - 1);
        if (this.fCurrentConfig != null) {
            this.fEnableButton.setSelection(this.fCurrentConfig.isEnabled());
            this.fLabelField.setText(this.fCurrentConfig.getLabel());
            this.fExpressionField.setText(this.fCurrentConfig.getQuery());
            this.fSelectColorAction.updateConfig();
        } else {
            this.fEnableButton.setSelection(false);
            this.fLabelField.setText("");
            this.fExpressionField.setText("");
        }
    }

    private void added(ColorizeConfiguration configuration) {
        this.fConfigurations.add(configuration);
        this.fAdded.add(configuration);
        this.fTableViewer.add((Object)configuration);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
    }

    private void changed(ColorizeConfiguration configuration) {
        if (!this.fAdded.contains(configuration)) {
            Assert.isTrue((!this.fRemoved.contains(configuration) ? 1 : 0) != 0);
            this.fChanged.add(configuration);
        }
        this.fTableViewer.update((Object)configuration, null);
    }

    private void removed(ColorizeConfiguration configuration) {
        this.fConfigurations.remove(configuration);
        if (!this.fAdded.remove(configuration)) {
            this.fChanged.remove(configuration);
            this.fRemoved.add(configuration);
        }
        this.fTableViewer.remove((Object)configuration);
    }

    private void checkStatus() {
        int i = 0;
        while (i < this.fConfigurations.size()) {
            ColorizeConfiguration configuration = this.fConfigurations.get(i);
            if (configuration.getQuery().trim().length() == 0) {
                this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, MessageFormat.format((String)Messages.ColorizeDialog_MESSAGE_MISSING_EXPRESSION, (Object[])new Object[]{i}), null));
            }
            ++i;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private static class ConfigurationContentProvider
    implements IStructuredContentProvider {
        private ConfigurationContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            List configurations = (List)inputElement;
            return configurations.toArray();
        }
    }

    private static class ConfigurationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLOR_COLUMN = 0;
        private static final int LABEL_COLUMN = 1;
        private static final int EXPRESSION_COLUMN = 2;
        private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private ConfigurationLabelProvider() {
        }

        public void dispose() {
            this.fResourceManager.dispose();
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ColorizeConfiguration configuration = (ColorizeConfiguration)element;
            if (columnIndex == 0 && configuration.isEnabled()) {
                return this.fResourceManager.createImage((ImageDescriptor)new ColorSelectionImageDescriptor(this.fResourceManager.getDevice(), configuration.getColor()));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ColorizeConfiguration configuration = (ColorizeConfiguration)element;
            switch (columnIndex) {
                case 1: {
                    return configuration.getLabel();
                }
                case 2: {
                    return configuration.getQuery();
                }
            }
            return "";
        }
    }

    private class ConfigurationSorter
    extends ViewerSorter {
        private ConfigurationSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ColorizeDialog.this.fConfigurations.indexOf(e1) - ColorizeDialog.this.fConfigurations.indexOf(e2);
        }
    }

    private class SelectQuickColorizeColorAction
    extends AbstractSelectQuickColorizeColorAction {
        public SelectQuickColorizeColorAction() {
            super(ColorizeDialog.this.getShell(), new RGB(141, 198, 63));
        }

        public void updateConfig() {
            if (ColorizeDialog.this.fCurrentConfig != null) {
                this.updateColor(ColorizeDialog.this.fCurrentConfig.getColor());
                this.firePropertyChange("image", null, null);
            }
        }

        protected void colorChanged(RGB color) {
            ColorizeDialog.this.fCurrentConfig.setColor(color);
            this.firePropertyChange("image", null, null);
            ColorizeDialog.this.changed(ColorizeDialog.this.fCurrentConfig);
            ColorizeDialog.this.checkStatus();
        }
    }
}

