/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.expression.Expression;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IMemento;

public class ColorizeConfiguration {
    private static final String KEY_ID = "id";
    private static final String KEY_LABEL = "label";
    private static final String KEY_QUERY = "query";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_COLOR = "color";
    private static final String KEY_COLOR_R = "r";
    private static final String KEY_COLOR_G = "g";
    private static final String KEY_COLOR_B = "b";
    private UUID fId = UUID.generate();
    private int fPriority;
    private String fLabel = Messages.ColorizeConfiguration_NEW_ENTRY_LABEL;
    private String fQuery = "";
    private boolean fEnabled = true;
    private RGB fColor = new RGB(141, 198, 63);
    private Expression fExpression;

    public ColorizeConfiguration() {
    }

    protected ColorizeConfiguration(ColorizeConfiguration other) {
        this.fId = other.fId;
        this.fPriority = other.fPriority;
        this.fLabel = other.fLabel;
        this.fQuery = other.fQuery;
        this.fEnabled = other.fEnabled;
        this.fColor = other.fColor;
        this.fExpression = other.fExpression;
    }

    public int getPriority() {
        return this.fPriority;
    }

    public void setPriority(int priority) {
        this.fPriority = priority;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public String getQuery() {
        return this.fQuery;
    }

    public void setQuery(String query) {
        this.fQuery = query;
    }

    public void setCachedExpression(Expression expression) {
        this.fExpression = expression;
    }

    public Expression getCachedExpression() {
        return this.fExpression;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public RGB getColor() {
        return this.fColor;
    }

    public void setColor(RGB color) {
        this.fColor = color;
    }

    public void saveState(IMemento memento) {
        memento.putString(KEY_ID, this.fId.getUuidValue());
        memento.putString(KEY_LABEL, this.fLabel);
        memento.putString(KEY_QUERY, this.fQuery);
        memento.putInteger(KEY_ENABLED, this.fEnabled ? 1 : 0);
        memento.putInteger(KEY_PRIORITY, this.fPriority);
        IMemento color = memento.createChild(KEY_COLOR);
        color.putInteger(KEY_COLOR_R, this.fColor.red);
        color.putInteger(KEY_COLOR_G, this.fColor.green);
        color.putInteger(KEY_COLOR_B, this.fColor.blue);
    }

    public void readState(IMemento memento) {
        String id = memento.getString(KEY_ID);
        this.fId = id != null ? UUID.valueOf((String)id) : this.fId;
        String label = memento.getString(KEY_LABEL);
        this.fLabel = label != null ? label : "";
        String query = memento.getString(KEY_QUERY);
        this.fQuery = query != null ? query : "";
        Integer enabled = memento.getInteger(KEY_ENABLED);
        this.fEnabled = enabled != null ? enabled != 0 : false;
        Integer priority = memento.getInteger(KEY_PRIORITY);
        this.fPriority = priority != null ? priority : 0;
        IMemento colorMemento = memento.getChild(KEY_COLOR);
        if (colorMemento != null) {
            Integer red = colorMemento.getInteger(KEY_COLOR_R);
            Integer green = colorMemento.getInteger(KEY_COLOR_G);
            Integer blue = colorMemento.getInteger(KEY_COLOR_B);
            this.fColor = new RGB(red != null ? red : 0, green != null ? green : 0, blue != null ? blue : 0);
        } else {
            this.fColor = new RGB(0, 0, 0);
        }
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.fId.equals((Object)((ColorizeConfiguration)obj).fId);
    }
}

