/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

class ColorSelectionImageDescriptor
extends ImageDescriptor {
    private final RGB fColor;
    private final Device fDevice;

    public ColorSelectionImageDescriptor(Device device, RGB color) {
        this.fDevice = device;
        this.fColor = color;
    }

    public ImageData getImageData() {
        Image image = this.createImage();
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public Image createImage() {
        Color borderColor = this.fDevice.getSystemColor(16);
        Color color = new Color(this.fDevice, this.fColor);
        RGB unused = new RGB(0, 0, 0);
        ImageData data = new ImageData(16, 16, 2, new PaletteData(new RGB[]{this.fColor, borderColor.getRGB(), unused, unused}));
        data.transparentPixel = 3;
        Arrays.fill(data.data, (byte)-1);
        Image image = new Image(this.fDevice, data);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(borderColor);
        gc.fillRectangle(3, 3, 10, 10);
        gc.drawRectangle(3, 3, 10, 10);
        gc.dispose();
        color.dispose();
        return image;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fColor == null ? 0 : this.fColor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ColorSelectionImageDescriptor other = (ColorSelectionImageDescriptor)((Object)obj);
        return !(this.fColor == null ? other.fColor != null : !this.fColor.equals((Object)other.fColor));
    }
}

