/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineModelContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ENTRIES = new Object[0];
    private OutlineModel<?> fOutlineModel;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isLegal((newInput == null || newInput instanceof OutlineModel ? 1 : 0) != 0);
        this.fOutlineModel = (OutlineModel)newInput;
    }

    public void dispose() {
        this.fOutlineModel = null;
    }

    public Object[] getElements(Object inputElement) {
        Assert.isLegal((boolean)(inputElement instanceof OutlineModel));
        return this.fOutlineModel.readModel(new ModelReadRunnable<Object[], RuntimeException>(){

            @Override
            public Object[] run(IOutlineModelReader readAccessor) {
                OutlineEntry<?> rootEntry = readAccessor.getRootEntry();
                return rootEntry != null ? OutlineModelContentProvider.this.getVisibleChildren(rootEntry, readAccessor).toArray() : NO_ENTRIES;
            }
        });
    }

    public Object[] getChildren(final Object parentElement) {
        Assert.isLegal((boolean)(parentElement instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new ModelReadRunnable<Object[], RuntimeException>(){

            @Override
            public Object[] run(IOutlineModelReader readAccessor) {
                return OutlineModelContentProvider.this.getVisibleChildren((OutlineEntry)parentElement, readAccessor).toArray();
            }
        });
    }

    public Object getParent(final Object element) {
        Assert.isLegal((boolean)(element instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new ModelReadRunnable<Object, RuntimeException>(){

            @Override
            public Object run(IOutlineModelReader readAccessor) {
                OutlineEntry entry = (OutlineEntry)element;
                return !entry.isDisposed() ? entry.getParent() : null;
            }
        });
    }

    public boolean hasChildren(final Object element) {
        Assert.isLegal((boolean)(element instanceof OutlineEntry));
        return this.fOutlineModel.readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

            @Override
            public Boolean run(IOutlineModelReader readAccessor) {
                return !OutlineModelContentProvider.this.getVisibleChildren((OutlineEntry)element, readAccessor).isEmpty();
            }
        });
    }

    private List<OutlineEntry<?>> getVisibleChildren(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        List<OutlineEntry<?>> children = readAccessor.getChildren(entry);
        ArrayList result = new ArrayList(children.size());
        for (OutlineEntry<?> child : children) {
            if (!child.isVisible()) continue;
            result.add(child);
        }
        return result;
    }

    private <T> OutlineEntry<T> ensureCurrentEntry(OutlineEntry<T> source, IOutlineModelReader readAccessor) {
        if (!source.isDisposed()) {
            return source;
        }
        for (OutlineEntry<T> candidateEntry : readAccessor.getElementEntries(source.getElement())) {
            if (!source.equals(candidateEntry)) continue;
            return candidateEntry;
        }
        return source;
    }
}

