/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryUtils {
    public static boolean isType(OutlineEntry<?> entry, Class<?> type) {
        return type.isInstance(EntryUtils.element(entry));
    }

    public static <T> OutlineEntry<T> cast(OutlineEntry<?> entry, Class<T> type) {
        if (!EntryUtils.isType(entry, type)) {
            throw new ClassCastException(NLS.bind((String)"Can't cast OutlineEntry<?> to OutlineEntry<{0}>", (Object[])new Object[]{type.getName()}));
        }
        return entry;
    }

    public static <T> List<T> elements(Collection<OutlineEntry<T>> entries) {
        ArrayList<T> result = new ArrayList<T>(entries.size());
        for (OutlineEntry<T> entry : entries) {
            result.add(entry.getElement());
        }
        return result;
    }

    public static <T> T element(OutlineEntry<T> entry) {
        return entry != null ? (T)entry.getElement() : null;
    }

    public static <T> T firstElement(Collection<OutlineEntry<T>> entries) {
        return EntryUtils.element(EntryUtils.firstEntry(entries));
    }

    public static <T> T lastElement(Collection<OutlineEntry<T>> entries) {
        return EntryUtils.element(EntryUtils.lastEntry(entries));
    }

    public static <T> List<T> elementsOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.elements((Collection)EntryUtils.entriesOfType(entries, typeClass));
    }

    public static <T> T firstElementOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.element(EntryUtils.firstEntryOfType(entries, typeClass));
    }

    public static <T> T lastElementOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        return EntryUtils.element(EntryUtils.lastEntryOfType(entries, typeClass));
    }

    public static <T> OutlineEntry<T> firstEntry(Collection<OutlineEntry<T>> entries) {
        Iterator<OutlineEntry<T>> entryIterator = entries.iterator();
        return entryIterator.hasNext() ? entryIterator.next() : null;
    }

    public static <T> OutlineEntry<T> lastEntry(Collection<OutlineEntry<T>> entries) {
        Iterator<OutlineEntry<T>> entryIterator = entries.iterator();
        OutlineEntry<T> result = null;
        while (entryIterator.hasNext()) {
            result = entryIterator.next();
        }
        return result;
    }

    public static <T> Collection<OutlineEntry<T>> entriesWithTag(Collection<OutlineEntry<T>> entries, EntryTag<?> tag) {
        ArrayList<OutlineEntry<T>> result = new ArrayList<OutlineEntry<T>>();
        for (OutlineEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> OutlineEntry<T> firstEntryWithTag(Collection<OutlineEntry<T>> entries, EntryTag<?> tag) {
        for (OutlineEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            return entry;
        }
        return null;
    }

    public static <T> OutlineEntry<T> lastEntryWithTag(Collection<OutlineEntry<T>> entries, EntryTag<?> tag) {
        OutlineEntry<T> result = null;
        for (OutlineEntry<T> entry : entries) {
            if (!entry.hasTag(tag)) continue;
            result = entry;
        }
        return result;
    }

    public static <T> List<OutlineEntry<T>> entriesOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        ArrayList<OutlineEntry<T>> result = new ArrayList<OutlineEntry<T>>();
        for (OutlineEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> OutlineEntry<T> firstEntryOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        for (OutlineEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            return entry;
        }
        return null;
    }

    public static <T> OutlineEntry<T> lastEntryOfType(Collection<OutlineEntry<?>> entries, Class<T> typeClass) {
        OutlineEntry<?> result = null;
        for (OutlineEntry<?> entry : entries) {
            if (!typeClass.isInstance(entry.getElement())) continue;
            result = entry;
        }
        return result;
    }
}

