/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryNavigator {
    private final IOutlineModelReader fReadAccessor;
    private final boolean fVisibleOnly;

    EntryNavigator(IOutlineModelReader readAccessor, boolean visibleOnly) {
        this.fReadAccessor = readAccessor;
        this.fVisibleOnly = visibleOnly;
    }

    public <T> OutlineEntry<T> findPrimaryEntry(T element) {
        return this.firstEntryWithTag(this.fReadAccessor.getElementEntries(element), PrimaryLocationTag.INSTANCE);
    }

    public <T> OutlineEntry<T> findFirstEntryWithTag(T element, EntryTag<?> tag) {
        return this.firstEntryWithTag(this.fReadAccessor.getElementEntries(element), tag);
    }

    public <T> OutlineEntry<T> findFirstEntryInSubtree(T element, OutlineEntry<?> searchRoot) {
        for (OutlineEntry<T> entry : this.fReadAccessor.getElementEntries(element)) {
            if (!this.isIncluded(entry) || !this.startsWith(entry, searchRoot)) continue;
            return entry;
        }
        return null;
    }

    public Object parentElement(OutlineEntry<?> entry) {
        return EntryUtils.element(this.parentEntry(entry));
    }

    public Object parentElement(OutlineEntry<?> entry, int level) {
        return EntryUtils.element(this.parentEntry(entry, level));
    }

    public List<?> childern(OutlineEntry<?> entry) {
        return EntryNavigator.doGetElements(this.childEntries(entry));
    }

    public List<?> siblings(OutlineEntry<?> entry) {
        return EntryNavigator.doGetElements(this.siblingEntries(entry));
    }

    public Object firstSibling(OutlineEntry<?> entry) {
        return EntryUtils.element(this.firstSiblingEntry(entry));
    }

    public Object lastSibling(OutlineEntry<?> entry) {
        return EntryUtils.element(this.lastSiblingEntry(entry));
    }

    public Object predecessor(OutlineEntry<?> entry) {
        return EntryUtils.element(this.predecessorEntry(entry));
    }

    public Object successor(OutlineEntry<?> entry) {
        return EntryUtils.element(this.predecessorEntry(entry));
    }

    public OutlineEntry<?> parentEntry(OutlineEntry<?> entry) {
        return this.fReadAccessor.getParent(entry);
    }

    public OutlineEntry<?> parentEntry(OutlineEntry<?> entry, int level) {
        if (level < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = level;
        while (entry != null && i > 0) {
            entry = this.fReadAccessor.getParent(entry);
            --i;
        }
        return entry;
    }

    public <T> OutlineEntry<T> parentEntryOfType(OutlineEntry<?> entry, Class<T> typeClass) {
        while (entry != null) {
            if (typeClass.isInstance(entry.getElement())) {
                return entry;
            }
            entry = this.fReadAccessor.getParent(entry);
        }
        return null;
    }

    public List<OutlineEntry<?>> childEntries(OutlineEntry<?> entry) {
        return this.filterInvisible(this.fReadAccessor.getChildren(entry));
    }

    public List<OutlineEntry<?>> siblingEntries(OutlineEntry<?> entry) {
        OutlineEntry<?> parent = this.fReadAccessor.getParent(entry);
        return parent != null ? this.filterInvisible(this.fReadAccessor.getChildren(parent)) : null;
    }

    public OutlineEntry<?> firstSiblingEntry(OutlineEntry<?> entry) {
        List<OutlineEntry<?>> siblings = this.siblingEntries(entry);
        return siblings != null ? siblings.get(0) : null;
    }

    public OutlineEntry<?> lastSiblingEntry(OutlineEntry<?> entry) {
        List<OutlineEntry<?>> siblings = this.siblingEntries(entry);
        return siblings != null ? siblings.get(siblings.size() - 1) : null;
    }

    public OutlineEntry<?> predecessorEntry(OutlineEntry<?> entry) {
        List<OutlineEntry<?>> siblings = this.siblingEntries(entry);
        if (siblings != null && !siblings.isEmpty()) {
            int index = siblings.indexOf(entry);
            Assert.isTrue((index != -1 ? 1 : 0) != 0);
            if (index > 0) {
                return siblings.get(index - 1);
            }
        }
        return null;
    }

    public OutlineEntry<?> successorEntry(OutlineEntry<?> entry) {
        List<OutlineEntry<?>> siblings = this.siblingEntries(entry);
        if (siblings != null && !siblings.isEmpty()) {
            int index = siblings.indexOf(entry);
            Assert.isTrue((index != -1 ? 1 : 0) != 0);
            if (index < siblings.size() - 1) {
                return siblings.get(index + 1);
            }
        }
        return null;
    }

    public int index(OutlineEntry<?> entry) {
        return entry != null ? entry.getOwnIndex() : -1;
    }

    public boolean startsWith(OutlineEntry<?> entry, OutlineEntry<?> prefix) {
        return this.toTreePath(entry).startsWith(this.toTreePath(prefix), null);
    }

    public boolean isFirst(OutlineEntry<?> entry) {
        return entry == this.firstSiblingEntry(entry);
    }

    public boolean isLast(OutlineEntry<?> entry) {
        return entry == this.lastSiblingEntry(entry);
    }

    public int indexOf(OutlineEntry<?> entry, Class<?> elementClass) {
        int result = 0;
        while (entry != null) {
            if (elementClass.isInstance(entry.getElement())) {
                return result;
            }
            entry = this.fReadAccessor.getParent(entry);
            ++result;
        }
        return -1;
    }

    public TreePath toTreePath(OutlineEntry<?> entry) {
        ArrayList elements = new ArrayList();
        OutlineEntry<?> candidate = entry;
        while (candidate != null && candidate != this.fReadAccessor.getRootEntry()) {
            elements.add(candidate.getElement());
            candidate = this.fReadAccessor.getParent(candidate);
        }
        Collections.reverse(elements);
        return new TreePath(elements.toArray());
    }

    private boolean isIncluded(OutlineEntry<?> entry) {
        return !this.fVisibleOnly || entry.isVisible();
    }

    private List<OutlineEntry<?>> filterInvisible(List<OutlineEntry<?>> entries) {
        if (!this.fVisibleOnly) {
            return entries;
        }
        ArrayList result = new ArrayList(entries.size());
        for (OutlineEntry<?> entry : entries) {
            if (!this.isIncluded(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private static List<?> doGetElements(Collection<OutlineEntry<?>> entries) {
        ArrayList result = new ArrayList(entries.size());
        for (OutlineEntry<?> entry : entries) {
            result.add(entry.getElement());
        }
        return result;
    }

    private <T> OutlineEntry<T> firstEntryWithTag(Collection<OutlineEntry<T>> entries, EntryTag<?> tag) {
        for (OutlineEntry<T> entry : entries) {
            if (!this.isIncluded(entry) || !entry.hasTag(tag)) continue;
            return entry;
        }
        return null;
    }
}

