/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeDropDownAction;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeverityDropDownAction
extends AttributeDropDownAction<ISeverity> {
    private final OutlineResources fOutlineResources;

    public SeverityDropDownAction(PlanItem planItem, OutlineResources outlineResources) {
        super(planItem, planItem.getPlan().getSeverityAttribute(), false);
        this.fOutlineResources = outlineResources;
    }

    @Override
    protected void setValue(ISeverity data) {
        this.getPlanItem().setSeverity(data);
    }

    @Override
    protected List<ISeverity> fastResolveValues() {
        IWorkItemClient wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
        IEnumeration enumeration = wic.findCachedEnumeration(this.getAttribute());
        if (enumeration == null) {
            return null;
        }
        return enumeration.getEnumerationLiterals();
    }

    @Override
    protected List<ISeverity> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
        IEnumeration enumeration = wic.resolveEnumeration((IAttributeHandle)this.getAttribute(), monitor);
        return enumeration.getEnumerationLiterals();
    }

    @Override
    protected MenuItem createMenuItem(Menu menu, ISeverity severity) {
        MenuItem item = new MenuItem(menu, 0);
        item.setImage(this.fOutlineResources.getImage(WorkItemUI.getImageDescriptor((ISeverity)severity)));
        item.setText(severity.getName());
        return item;
    }
}

