/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupNodeContent
extends GTreeNodeContent {
    protected GLabel fNameLabel;
    protected GLabel fStatusLabel;
    private int fOpen;
    private int fClosed;
    private Insets fInsets;

    protected GroupNodeContent(GTreeNode parent, OutlineEntry<? extends GroupElement> groupEntry, String title) {
        super(parent);
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fNameLabel = new GLabel(this, title, 64);
        this.fNameLabel.setColor(resources.getGroupTextColor());
        this.fNameLabel.setFont(resources.getGroupTextFont());
        this.fNameLabel.setReturnParentElement(true);
        int[] openClosedCount = this.getOpenCloseCount(groupEntry);
        this.fOpen = openClosedCount[0];
        this.fClosed = openClosedCount[1];
        this.fStatusLabel = new GLabel(this, NLS.bind((String)Messages.GroupNodeContent_CLOSED_OPEN_COUNT, (Object[])new Object[]{this.fClosed, this.fOpen}), 64);
        this.fStatusLabel.setColor(resources.getGroupTextColor());
        this.fStatusLabel.setFont(resources.getTextFonts().getNormalFont());
        this.fInsets = new Insets(3, 5, 3, 5);
    }

    protected int[] getOpenCloseCount(final OutlineEntry<? extends GroupElement> groupEntry) {
        return groupEntry.getModel().readModel(new ModelReadRunnable<int[], RuntimeException>(){

            @Override
            public int[] run(IOutlineModelReader readAccessor) throws RuntimeException {
                final int[] result = new int[2];
                readAccessor.accept(groupEntry, new IEntryVisitor(){

                    @Override
                    public boolean visit(OutlineEntry<?> entry) {
                        Object element = entry.getElement();
                        if (element instanceof PlanItem && entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                            int n = ((PlanItem)element).isResolved() ? 1 : 0;
                            result[n] = result[n] + 1;
                        }
                        return true;
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Insets getInsets() {
        return this.fInsets;
    }

    @Override
    public int computeMinimalWidth() {
        return this.max(this.fNameLabel.computeMinimalWidth(), this.fStatusLabel.computeMinimalWidth());
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        this.fNameLabel.layout(x, y, -1, -1);
        this.fStatusLabel.layout(x, y += this.fNameLabel.getHeight(), -1, -1);
        return new Point(this.max(wHint, this.fNameLabel.getWidth(), this.fStatusLabel.getWidth()), this.fNameLabel.getHeight() + this.fStatusLabel.getHeight());
    }

    public int getOpenCount() {
        return this.fOpen;
    }

    public int getClosedCount() {
        return this.fClosed;
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    protected int height(Font font) {
        FontData[] data;
        if (font == null) {
            font = this.getPlanOutlineResources().getTextFonts().getNormalFont();
        }
        int result = 0;
        FontData[] fontDataArray = data = font.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            result = Math.max(result, fontData.getHeight());
            ++n2;
        }
        return result;
    }
}

