/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.GeneralProblem;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.ProblemMarker;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMarkerGadget
extends SimpleGadget {
    public static final int OUTPLACE_ID = 1;
    public static final int PINNED_ID = 2;
    private final PlanItem fPlanItem;
    private final LocationMarker fLocationMarker;
    private Point fMarkerSize;
    private Point fImageSize;

    public GMarkerGadget(CompositeGadget parent, PlanItem planItem, LocationMarker locationMarker) {
        super(parent);
        this.fPlanItem = planItem;
        this.fLocationMarker = locationMarker;
        this.initResouces();
    }

    private void initResouces() {
        Rectangle fatalBounds = this.getOutlineResources().getFatalErrorImage().getBounds();
        Rectangle warningBounds = this.getOutlineResources().getWarningImage().getBounds();
        Rectangle errorBounds = this.getOutlineResources().getErrorImage().getBounds();
        Rectangle doesNotBelongBounds = this.getOutlineResources().getDoesNotBelongToImage().getBounds();
        Rectangle pinnedBounds = this.getOutlineResources().getPinnedItemImage().getBounds();
        this.fImageSize = new Point(this.max(this.max(fatalBounds.width, warningBounds.width, errorBounds.width, doesNotBelongBounds.width), pinnedBounds.width), this.max(this.max(fatalBounds.height, warningBounds.height, errorBounds.height, doesNotBelongBounds.height), pinnedBounds.height));
        Font normalFont = this.getOutlineResources().getTextFonts().getNormalFont();
        Device device = normalFont.getDevice();
        GC gc = new GC((Drawable)device);
        try {
            gc.setFont(normalFont);
            this.fMarkerSize = new Point(gc.getCharWidth('*'), gc.getCharWidth('*'));
        }
        finally {
            gc.dispose();
        }
    }

    @Override
    protected Point arrangeContent(int x, int y, int hint, int hint2) {
        return new Point(this.computeMinimalWidth(), this.fMarkerSize.y + 1 + this.fImageSize.y);
    }

    @Override
    public int computeMinimalWidth() {
        return Math.max(this.fImageSize.x, this.fMarkerSize.x);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fBounds.width == 0 || this.fBounds.height == 0) {
            return;
        }
        GCState state = GCState.save(gc, 392);
        Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
        Image markerImage = null;
        if (this.fPlanItem.isDirty() && !(this.fLocationMarker instanceof SecondaryLocationMarker)) {
            gc.setFont(resources.getTextFonts().getNormalFont());
            gc.drawString("*", rect.x, rect.y - 1, true);
            gc.setForeground(this.getPlanOutlineResources().getLabelColor());
        }
        if (this.fLocationMarker == null) {
            List<Problem> problems = this.getProblems();
            if (!this.getProblems().isEmpty()) {
                Problem problem = problems.get(0);
                markerImage = this.getImage(problem);
            }
        } else {
            markerImage = this.getOutlineResources().getDoesNotBelongToImage();
        }
        if (markerImage != null) {
            Rectangle bounds = markerImage.getBounds();
            int imgWidth = bounds.width;
            int imgHeight = bounds.height;
            gc.drawImage(markerImage, 0, 0, imgWidth, imgHeight, rect.x, rect.y + rect.height - imgHeight, imgWidth, imgHeight);
        }
        if (this.getOutlineResources().debugLayout) {
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
        state.restore();
    }

    private List<Problem> getProblems() {
        PlanItemProblemReport report;
        ArrayList<Problem> result = new ArrayList<Problem>();
        Timestamp startDate = this.fPlanItem.getFixedStartDate();
        if (startDate != null) {
            String message = MessageFormat.format(Messages.GMarkerGadget_FIXED_START_DATE, startDate);
            result.add((Problem)new GeneralProblem(Problem.Severity.INFO, 2, message, this.fPlanItem, null));
        }
        if ((report = this.fPlanItem.getProblemReport()) != null) {
            result.addAll(report.getProblems());
        }
        Collections.sort(result, new Comparator<Problem>(){

            @Override
            public int compare(Problem o1, Problem o2) {
                return -o1.getSeverity().compareTo((Enum)o2.getSeverity());
            }
        });
        return result;
    }

    @Override
    public Object getElement() {
        if (this.fLocationMarker != null) {
            return this.fLocationMarker;
        }
        List<Problem> problems = this.getProblems();
        if (problems.isEmpty()) {
            return null;
        }
        return new ProblemMarker(problems);
    }

    public Image getImage(Problem problem) {
        switch (problem.getSeverity()) {
            case INFO: {
                switch (problem.getId()) {
                    case 1: {
                        return this.getOutlineResources().getDoesNotBelongToImage();
                    }
                    case 2: {
                        return this.getOutlineResources().getPinnedItemImage();
                    }
                }
                return this.getOutlineResources().getInfoImage();
            }
            case WARNING: {
                return this.getOutlineResources().getWarningImage();
            }
            case ERROR: 
            case FATAL_ERROR: {
                return this.getOutlineResources().getErrorImage();
            }
        }
        return null;
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }
}

