/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class GAbstractProblemMarker
extends SimpleGadget {
    protected GAbstractProblemMarker(CompositeGadget parent) {
        super(parent);
    }

    public int computeMinimalWidth() {
        Problem problem = this.getProblem();
        if (problem == null) {
            return 0;
        }
        Image image = this.getImage(problem, this.getOutlineResources());
        if (image == null) {
            return 0;
        }
        return image.getBounds().width;
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Problem problem = this.getProblem();
        if (problem == null) {
            return new Point(0, 0);
        }
        Image image = this.getImage(problem, this.getOutlineResources());
        if (image == null) {
            return new Point(0, 0);
        }
        Rectangle bounds = image.getBounds();
        if (wHint != -1) {
            bounds.width = wHint;
        }
        if (hHint != -1) {
            bounds.height = hHint;
        }
        return new Point(bounds.width, bounds.height);
    }

    public void paint(GC gc, OutlineResources resources) {
        Problem problem = this.getProblem();
        if (problem == null) {
            return;
        }
        Image image = this.getImage(problem, resources);
        if (image == null) {
            return;
        }
        Rectangle viewBounds = this.getTransformation().toViewPort(this.getBounds());
        gc.drawImage(image, viewBounds.x, viewBounds.y);
    }

    public Object getElement() {
        return this.getProblem();
    }

    protected abstract Problem getProblem();

    protected Image getImage(Problem problem, OutlineResources resources) {
        return this.getImage(problem.getSeverity(), resources);
    }

    protected Image getImage(Problem.Severity severity, OutlineResources resources) {
        switch (severity) {
            case FATAL_ERROR: {
                return resources.getFatalErrorImage();
            }
            case ERROR: {
                return resources.getErrorImage();
            }
            case WARNING: {
                return resources.getWarningImage();
            }
        }
        return null;
    }
}

