/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.ValueSetDropDownAction;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeDropDownAction<E>
extends ValueSetDropDownAction<E> {
    private PlanItem fPlanItem;
    private IAttribute fAttribute;
    private boolean fCacheValues;
    private List<E> fCachedValues;

    public AttributeDropDownAction(PlanItem planItem, IAttribute attribute, boolean cacheValues) {
        this.fPlanItem = planItem;
        this.fAttribute = attribute;
        this.fCacheValues = cacheValues;
    }

    public PlanItem getPlanItem() {
        return this.fPlanItem;
    }

    @Override
    protected List<E> fastResolveValues() {
        return this.fCachedValues;
    }

    @Override
    protected List<E> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] values = this.getValueSet(monitor);
        List<Object> result = new ArrayList(values.length);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            result.add(value);
            ++n2;
        }
        result = this.extendValueSet(result);
        if (this.fCacheValues) {
            this.fCachedValues = result;
        }
        return result;
    }

    protected Object[] getValueSet(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanItem.getValueSet(this.fAttribute, monitor);
    }

    protected List<E> extendValueSet(List<E> values) {
        return values;
    }

    protected IAttribute getAttribute() {
        return this.fAttribute;
    }
}

