/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.ide.ui.common.Messages;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SaveProblemDialog
extends StatusDialog {
    private static final int ICON_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    public static final int OPEN = 1025;
    public static final int SELECT = 1026;
    private IOperationReport fOperationReport;
    private TreeViewer fProblemViewer;

    public SaveProblemDialog(Shell parent) {
        super(parent);
        this.setTitle(Messages.SaveProblemDialog_TITLE);
        this.setShellStyle(0xC70 | SaveProblemDialog.getDefaultOrientation());
        this.setBlockOnOpen(false);
    }

    public void setInput(IOperationReport report) {
        this.fOperationReport = report;
        this.fProblemViewer.setInput((Object)report);
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int width = Math.max(600, result.x);
        int height = Math.max((int)((double)width / 3.0) * 2, result.y);
        result.x = width;
        result.y = height;
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        Label label = new Label(result, 0);
        label.setText(Messages.SaveProblemDialog_MESSAGE);
        label.setLayoutData((Object)new GridData(768));
        this.fProblemViewer = new TreeViewer(result, 68354);
        Tree tree = this.fProblemViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        new TreeColumn(tree, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        TreeColumn description = new TreeColumn(tree, 0);
        description.setText(Messages.SaveProblemDialog_COLUMN_DESCRIPTION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.fProblemViewer.setContentProvider((IContentProvider)new SaveProblemContentProvider());
        this.fProblemViewer.setLabelProvider((IBaseLabelProvider)new SaveProblemLabelProvider());
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.SaveProblemDialog_BUTTON_OPEN, true).setEnabled(false);
        this.createButton(parent, 1026, Messages.SaveProblemDialog_BUTTON_SELECT, true).setEnabled(false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId > 1024) {
            this.setReturnCode(buttonId);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private static class SaveProblemContentProvider
    implements ITreeContentProvider {
        private SaveProblemContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            IOperationReport report = (IOperationReport)inputElement;
            return report.getParticipantReports();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IProcessReport) {
                return ((IProcessReport)element).getNestedReports();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IProcessReport) {
                return ((IProcessReport)element).getNestedReports().length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof IProcessReport) {
                ((IProcessReport)element).getParentReport();
            }
            return null;
        }
    }

    private static class SaveProblemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider fWorkItemLabelProvider = WorkItemUI.createWorkItemLabelProvider();
        private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private SaveProblemLabelProvider() {
        }

        public void dispose() {
            this.fWorkItemLabelProvider.dispose();
            this.fResourceManager.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IProcessReport report = (IProcessReport)element;
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return report.getDescription();
                }
            }
            return "";
        }
    }
}

