/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.ide.ui.common.Messages;
import com.ibm.team.apt.internal.ide.ui.common.SaveConflictItem;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SaveConflictDialog
extends StatusDialog {
    private static final int ICON_COLUMN = 0;
    private static final int ID_COLUMN = 1;
    private static final int SUMMARY_COLUMN = 2;
    private static final int MODIFIED_BY_COLUMN = 3;
    public static final int AUTO_MERGE = 1025;
    public static final int REFESH = 1026;
    public static final int REVERT = 1027;
    private SaveConflictItem[] fSaveConflicts;
    private TableViewer fTableViewer;

    public SaveConflictDialog(Shell parent, SaveConflictItem[] conflicts) {
        super(parent);
        this.setTitle(Messages.SaveConflictDialog_TITLE);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fSaveConflicts = conflicts;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int width = Math.max(600, result.x);
        int height = Math.max((int)((double)width / 3.0) * 2, result.y);
        result.x = width;
        result.y = height;
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        Label label = new Label(result, 64);
        label.setText(Messages.SaveConflictDialog_MESSAGE);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 128).hint(this.convertWidthInCharsToPixels(80), -1).applyTo((Control)label);
        this.fTableViewer = new TableViewer(result, 68354);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        TableColumn id = new TableColumn(table, 0);
        id.setText(Messages.SaveConflictDialog_COLUMN_ID);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(48));
        TableColumn summary = new TableColumn(table, 0);
        summary.setText(Messages.SaveConflictDialog_COLUMN_SUMMARY);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        TableColumn lastModified = new TableColumn(table, 0);
        lastModified.setText(Messages.SaveConflictDialog_COLUMN_LAST_MODIFIED_BY);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        this.fTableViewer.setContentProvider((IContentProvider)new SaveConflictContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SaveConflictLabelProvider());
        this.fTableViewer.setInput((Object)this.fSaveConflicts);
        int i = 0;
        while (i < this.fSaveConflicts.length) {
            this.fSaveConflicts[i].conntectTo(this.fTableViewer);
            ++i;
        }
        SaveConflictDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.SaveConflictDialog_BUTTON_MERGE, true);
        this.createButton(parent, 1026, Messages.SaveConflictDialog_BUTTON_REFRESH, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId > 1024) {
            this.setReturnCode(buttonId);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private static class SaveConflictContentProvider
    implements IStructuredContentProvider {
        private SaveConflictContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private class SaveConflictLabelProvider
    extends CellLabelProvider
    implements ILabelProviderListener {
        private ILabelProvider fWorkItemLabelProvider = WorkItemUI.createWorkItemLabelProvider();
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        SaveConflictLabelProvider() {
            this.fStandardLabelProvider.addListener((ILabelProviderListener)this);
        }

        public void dispose() {
            this.fResourceManager.dispose();
            this.fStandardLabelProvider.removeListener((ILabelProviderListener)this);
            this.fStandardLabelProvider.dispose();
            this.fWorkItemLabelProvider.dispose();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            SaveConflictDialog.this.fTableViewer.refresh(true);
        }

        public void update(ViewerCell cell) {
            SaveConflictItem item = (SaveConflictItem)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(null);
                    cell.setImage(this.fWorkItemLabelProvider.getImage((Object)item.getOutgoing()));
                    break;
                }
                case 1: {
                    cell.setText(String.valueOf(item.getId()));
                    cell.setImage(null);
                    break;
                }
                case 2: {
                    cell.setText(item.getSummary());
                    cell.setImage(null);
                    break;
                }
                case 3: {
                    IContributor contributor = item.getLastModifiedBy();
                    if (contributor == null) {
                        cell.setText(item.getMissingMessage());
                        cell.setImage(this.fResourceManager.createImage(ImagePool.WORKITEM_USER));
                        cell.setFont(null);
                        cell.setForeground(null);
                        break;
                    }
                    ViewerLabel label = new ViewerLabel(null, null);
                    this.fStandardLabelProvider.updateLabel(label, (Object)contributor);
                    cell.setText(label.getText());
                    cell.setImage(label.getImage());
                    cell.setFont(label.getFont());
                    cell.setForeground(label.getForeground());
                }
            }
        }
    }
}

