/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.widgets.PlanElementSelectionTransfer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanViewerDropAdapter
extends DropTargetAdapter {
    private final PlanViewer fViewer;
    private final IWorkbenchPartSite fSite;
    private int fRequestedOperation;
    private int fLastOperation;
    protected int fLocation;
    protected OutlineEntry<?> fTarget;

    public PlanViewerDropAdapter(PlanViewer viewer, IWorkbenchPartSite site) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fViewer = viewer;
        this.fSite = site;
    }

    protected PlanViewer getViewer() {
        return this.fViewer;
    }

    public void drop(DropTargetEvent event) {
        this.drop(this.fTarget, event);
    }

    public void dragEnter(DropTargetEvent event) {
        this.dragOperationChanged(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.fRequestedOperation = event.detail;
        this.fTarget = this.computeTarget(event);
        this.fLocation = this.computeLocation(event);
        this.validateDrop(this.fTarget, event, this.fRequestedOperation);
        this.fLastOperation = event.detail;
        this.computeFeedback(event);
    }

    public void dragOver(DropTargetEvent event) {
        OutlineEntry<?> oldTarget = this.fTarget;
        this.fTarget = this.computeTarget(event);
        int oldLocation = this.fLocation;
        this.fLocation = this.computeLocation(event);
        if (oldLocation != this.fLocation || !this.equalEntries(oldTarget, this.fTarget) || this.fLastOperation != event.detail) {
            this.validateDrop(this.fTarget, event, this.fRequestedOperation);
            this.fLastOperation = event.detail;
        } else {
            event.detail = this.fLastOperation;
        }
        this.computeFeedback(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.fTarget = this.computeTarget(event);
        this.validateDrop(this.fTarget, event, this.fRequestedOperation);
        this.fLastOperation = event.detail;
    }

    protected void validateDrop(OutlineEntry<?> targetEntry, DropTargetEvent event, int operation) {
        LocalSelectionTransfer lt;
        event.detail = 0;
        if (this.fLocation == 0) {
            return;
        }
        Object target = targetEntry.getElement();
        if (target == null || (event.operations & 6) == 0) {
            return;
        }
        PlanElementSelectionTransfer pt = PlanElementSelectionTransfer.getTransfer();
        TransferData current = this.getPreferredTransfer(event, new Transfer[]{pt, lt = LocalSelectionTransfer.getTransfer()});
        if (current == null) {
            return;
        }
        event.currentDataType = current;
        IStructuredSelection selection = null;
        if (pt.isSupportedType(current)) {
            selection = pt.getSelection();
        } else if (lt.isSupportedType(current) && lt.getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)lt.getSelection();
        }
        if (selection == null) {
            event.currentDataType = null;
            return;
        }
        ItemMovePolicy.DropLocation validateResult = this.getItemMovePolicy().validateDrop(selection, targetEntry, this.convertDropLocation(this.fLocation), event);
        switch (validateResult) {
            case Onto: {
                event.detail = 4;
                this.fLocation = this.fLocation & 0xFFFFFFF9 | 1;
                break;
            }
            case OntoUnderlayChildern: {
                event.detail = 4;
                this.fLocation = this.fLocation & 0xFFFFFFF9 | 1 | 0x20;
                break;
            }
            case OntoParent: {
                event.detail = 4;
                this.fLocation = this.fLocation & 0xFFFFFFF9 | 1 | 0x20;
                this.fTarget = (OutlineEntry)this.fTarget.getModel().readModel(new ModelReadRunnable<OutlineEntry<?>, RuntimeException>(){

                    @Override
                    public OutlineEntry<?> run(IOutlineModelReader readAccessor) throws RuntimeException {
                        return readAccessor.getParent(PlanViewerDropAdapter.this.fTarget);
                    }
                });
                event.item = ((OutlineItem)event.item).getParent();
                break;
            }
            case Before: {
                event.detail = 4;
                this.fLocation = this.fLocation & 0xFFFFFFFA | 2;
                break;
            }
            case After: {
                event.detail = 4;
                this.fLocation = this.fLocation & 0xFFFFFFFC | 4;
                break;
            }
            case None: {
                event.detail = 0;
                this.fLocation &= 0xFFFFFFF8;
            }
        }
    }

    protected void drop(OutlineEntry<?> targetEntry, DropTargetEvent event) {
        LocalSelectionTransfer lt = LocalSelectionTransfer.getTransfer();
        PlanElementSelectionTransfer pt = PlanElementSelectionTransfer.getTransfer();
        IStructuredSelection selection = null;
        if (lt.isSupportedType(event.currentDataType)) {
            selection = (IStructuredSelection)lt.getSelection();
        } else if (pt.isSupportedType(event.currentDataType)) {
            selection = pt.getSelection();
        }
        boolean success = false;
        if (selection != null) {
            success = this.getItemMovePolicy().drop(selection, targetEntry, this.convertDropLocation(this.fLocation), event, this.fSite.getWorkbenchWindow().getWorkbench().getProgressService());
        }
        event.detail = success ? 4 : 0;
    }

    private OutlineEntry<?> computeTarget(DropTargetEvent event) {
        if (event.item != null && event.item.getData() instanceof OutlineEntry) {
            return (OutlineEntry)event.item.getData();
        }
        return null;
    }

    protected int computeLocation(DropTargetEvent event) {
        int result = 0;
        if (event.item instanceof OutlineItem && ((OutlineItem)event.item).getContent() != null) {
            result = 1;
            PlanCanvas outline = this.fViewer.getOutline();
            int eventY = outline.getTransformation().toPane((Point)outline.toControl((int)event.x, (int)event.y)).y;
            OutlineItem item = (OutlineItem)event.item;
            Rectangle itemBounds = item.getContent().getBounds();
            Rectangle selectionBounds = item.getContent().getSelectionBounds();
            int selectionY = selectionBounds.y;
            int itemY = itemBounds.y;
            if (eventY > itemY && eventY < selectionY || eventY - itemY <= 3) {
                result = 2;
            } else {
                selectionY = selectionBounds.y + selectionBounds.height;
                itemY = itemBounds.y + itemBounds.height;
                if (eventY > selectionY && eventY < itemY || itemY - eventY <= 3) {
                    OutlineItem nextItem = outline.getNextVisibleItem(item);
                    if (nextItem == null || nextItem.getParent() != item) {
                        result = 4;
                    }
                } else {
                    result = 17;
                }
            }
        }
        return result;
    }

    private boolean equalEntries(OutlineEntry<?> a, OutlineEntry<?> b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private void computeFeedback(DropTargetEvent event) {
        event.feedback = this.fLocation | 8 | 0x10;
    }

    protected ItemMovePolicy getItemMovePolicy() {
        return this.fViewer.getSettings().getItemMovePolicy();
    }

    private TransferData getPreferredTransfer(DropTargetEvent event, Transfer[] transfers) {
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData transferData = transferDataArray[n2];
            Transfer[] transferArray = transfers;
            int n3 = transfers.length;
            int n4 = 0;
            while (n4 < n3) {
                Transfer transfer = transferArray[n4];
                if (transfer.isSupportedType(transferData)) {
                    return transferData;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private ItemMovePolicy.DropLocation convertDropLocation(int feedback) {
        if ((feedback & 2) != 0) {
            return ItemMovePolicy.DropLocation.Before;
        }
        if ((feedback & 4) != 0) {
            return ItemMovePolicy.DropLocation.After;
        }
        return ItemMovePolicy.DropLocation.Onto;
    }
}

