/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.resources;

import com.ibm.team.apt.internal.ide.ui.aspect.AbstractProcessAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.resources.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public final class WorkResourcesAspectEditor
extends AbstractProcessAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.workResourcesSpecification";
    private static final String ATTRIBUTE_DAYS = "workDays";
    private static final String ATTRIBUTE_HOURS = "workHours";
    private static final String ELEMENT_SPECIFICATION = "workResourcesSpecification";
    private int fDays = 5;
    private int fHours = 8;
    private Spinner fHourSpinner;
    private Spinner fDaySpinner;

    protected void createContents(Composite container) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        Label label = new Label(container, 64);
        label.setText(Messages.WorkResourcesAspectEditor_WORK_HOURS_PER_DAY);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        this.fHourSpinner = new Spinner(container, 2112);
        this.fHourSpinner.setValues(this.fHours, 0, 24, 0, 1, 4);
        this.fHourSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourcesAspectEditor.this.updateHoursFromUI();
            }
        });
        this.fHourSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkResourcesAspectEditor.this.updateHoursFromUI();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.fHourSpinner);
        label = new Label(container, 64);
        label.setText(Messages.WorkResourcesAspectEditor_WORK_HOURS_PER_WEEK);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        this.fDaySpinner = new Spinner(container, 2112);
        this.fDaySpinner.setValues(this.fDays, 0, 7, 0, 1, 1);
        this.fDaySpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourcesAspectEditor.this.updateDaysFromUI();
            }
        });
        this.fDaySpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkResourcesAspectEditor.this.updateDaysFromUI();
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.fDaySpinner);
    }

    protected void doSaveState(IMemento memento) {
        IMemento spec = memento.createChild(ELEMENT_SPECIFICATION);
        spec.putInteger(ATTRIBUTE_HOURS, this.fHours);
        spec.putInteger(ATTRIBUTE_DAYS, this.fDays);
    }

    protected void doSetInput(ProcessAspect aspect) {
        this.readConfiguration();
    }

    private void readConfiguration() {
        ModelElement element;
        this.fHours = 8;
        this.fDays = 5;
        ProcessAspect aspect = this.getAspect();
        if (aspect != null && (element = aspect.getConfigurationElement()) != null && (element = WorkResourcesAspectEditor.findConfigurationElement(element, ELEMENT_SPECIFICATION)) != null) {
            String hours = element.getAttribute(ATTRIBUTE_HOURS);
            String days = element.getAttribute(ATTRIBUTE_DAYS);
            try {
                this.fHours = Integer.parseInt(hours);
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.fDays = Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected String getOptionName() {
        return Messages.WorkResourcesAspectEditor_PROJECT_WORK_SETTINGS;
    }

    private void updateHoursFromUI() {
        int selection = this.fHourSpinner.getSelection();
        if (selection != this.fHours) {
            this.fHours = selection;
            this.setDirty();
        }
    }

    private void updateDaysFromUI() {
        int selection = this.fDaySpinner.getSelection();
        if (selection != this.fDays) {
            this.fDays = selection;
            this.setDirty();
        }
    }

    public void revert() {
        this.readConfiguration();
        this.fHourSpinner.setSelection(this.fHours);
        this.fDaySpinner.setSelection(this.fDays);
        this.setDirty(false);
    }
}

