/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import java.util.Calendar;
import java.util.Date;

public abstract class ScheduleTime {
    private final String fLabel;
    private final long fReferenceTime;
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final IWorkHoursDefinition fWorkHours;

    public ScheduleTime(String label, Date referenceTime, IWorkHoursDefinition workHours) {
        this.fLabel = label;
        this.fWorkHours = workHours;
        this.fReferenceTime = referenceTime.getTime();
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAvailable() {
        this.ensureValid();
        beginTime = Math.max(this.fStartTime, this.fReferenceTime);
        calendar = this.fWorkHours.getCalendarInstance(beginTime);
        if (beginTime < this.fEndTime) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            workHours = this.fWorkHours.getWorkingHours(calendar.getTime());
            if (workHours != null) {
                start = workHours.getStart().getTime();
                end = workHours.getEnd().getTime();
                if (beginTime >= start && beginTime < end || this.fEndTime >= start && this.fEndTime < end) {
                    return true;
                }
                if (beginTime <= start && this.fEndTime >= end) {
                    return true;
                }
            }
            calendar.add(6, 1);
lbl15:
            // 2 sources

            ** while (calendar.getTimeInMillis() < this.fEndTime)
        }
lbl16:
        // 1 sources

        return false;
    }

    public boolean isInGroup(Date when) {
        this.ensureValid();
        return this.fStartTime <= when.getTime() && this.fEndTime > when.getTime();
    }

    public String getLabel() {
        return this.fLabel;
    }

    public Date getScheduleTime() {
        this.ensureValid();
        return new Date(this.fStartTime + (this.fEndTime - this.fStartTime) / 2L);
    }

    public void setPrevious(ScheduleTime time) {
        time.ensureValid();
        this.ensureValid();
        if (time.fEndTime > this.fStartTime) {
            this.fStartTime = time.fEndTime;
            if (this.fStartTime > this.fEndTime) {
                this.fEndTime = this.fStartTime;
            }
        }
    }

    protected void ensureValid() {
        if (this.fStartTime == -1L || this.fEndTime == -1L) {
            this.fStartTime = this.calculateStartTime();
            this.fEndTime = this.calculateEndTime();
        }
    }

    protected Date getStartTime() {
        this.ensureValid();
        return new Date(this.fStartTime);
    }

    protected abstract long calculateStartTime();

    protected abstract long calculateEndTime();

    protected Calendar getNow() {
        return this.fWorkHours.getCalendarInstance(this.fReferenceTime);
    }

    protected Calendar setWorkDayStart(Calendar calendar) {
        Timespan workingHours = this.fWorkHours.getWorkingHours(calendar.getTime());
        if (workingHours != null) {
            calendar.setTimeInMillis(workingHours.getStart().getTime());
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar;
    }

    protected Calendar setWorkDayEnd(Calendar calendar) {
        Timespan workingHours = this.fWorkHours.getWorkingHours(calendar.getTime());
        if (workingHours != null) {
            calendar.setTimeInMillis(workingHours.getEnd().getTime());
        } else {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return calendar;
    }

    protected Calendar setWorkWeekStart(Calendar calendar) {
        calendar.set(7, calendar.getFirstDayOfWeek());
        this.setWorkDayStart(calendar);
        return calendar;
    }

    protected Calendar setWorkWeekEnd(Calendar calendar) {
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.add(7, 6);
        this.setWorkDayEnd(calendar);
        return calendar;
    }

    protected Calendar add(Calendar calendar, int field, int delta) {
        calendar.add(field, delta);
        return calendar;
    }

    protected long toTime(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    public String toString() {
        String startLabel = this.fStartTime == -1L ? "Not Calculated" : new Date(this.fStartTime).toString();
        String endLabel = this.fEndTime == -1L ? "Not Calculated" : new Date(this.fEndTime).toString();
        return String.format("%s %s [%s - %s]", this.getClass().getSimpleName(), this.fLabel, startLabel, endLabel);
    }

    public static class Day
    extends ScheduleTime {
        private final int fDayShift;

        public Day(String label, int dayShift, Date referenceTime, IWorkHoursDefinition workHours) {
            super(label, referenceTime, workHours);
            this.fDayShift = dayShift;
        }

        protected long calculateStartTime() {
            return this.toTime(this.setWorkDayStart(this.add(this.getNow(), 6, this.fDayShift)));
        }

        protected long calculateEndTime() {
            return this.toTime(this.setWorkDayEnd(this.add(this.getNow(), 6, this.fDayShift)));
        }
    }

    public static class DayWithDayLabel
    extends Day {
        private static final SimpleDateFormat DAY_LABEL_FORMATTER = new SimpleDateFormat("EEEE");

        public DayWithDayLabel(int dayShift, Date referenceTime, IWorkHoursDefinition workHours) {
            super("", dayShift, referenceTime, workHours);
        }

        public String getLabel() {
            return DAY_LABEL_FORMATTER.format(this.getStartTime());
        }
    }

    public static class Future
    extends ScheduleTime {
        private final int fStartWeekShift;

        public Future(String label, int startWeekShift, Date referenceTime, IWorkHoursDefinition workHours) {
            super(label, referenceTime, workHours);
            this.fStartWeekShift = startWeekShift;
        }

        public boolean isAvailable() {
            return true;
        }

        protected long calculateStartTime() {
            return this.toTime(this.setWorkWeekStart(this.add(this.getNow(), 3, this.fStartWeekShift)));
        }

        protected long calculateEndTime() {
            return 0x7FFFFFFFFFFFFFFEL;
        }
    }

    public static class LaterToday
    extends ScheduleTime {
        public LaterToday(Date referenceTime, IWorkHoursDefinition workHours) {
            super(Messages.ScheduleTime_TODAY, referenceTime, workHours);
        }

        protected long calculateStartTime() {
            return Math.max(this.toTime(this.setWorkDayStart(this.getNow())), this.getNow().getTimeInMillis());
        }

        protected long calculateEndTime() {
            return this.toTime(this.setWorkDayEnd(this.getNow()));
        }
    }

    public static class Weeks
    extends ScheduleTime {
        private final int fWeekShift;
        private final int fWeekCount;

        public Weeks(String label, int weekShift, int weekCount, Date referenceTime, IWorkHoursDefinition workHours) {
            super(label, referenceTime, workHours);
            this.fWeekShift = weekShift;
            this.fWeekCount = weekCount;
        }

        protected long calculateStartTime() {
            return this.toTime(this.setWorkWeekStart(this.add(this.getNow(), 3, this.fWeekShift)));
        }

        protected long calculateEndTime() {
            return this.toTime(this.setWorkWeekEnd(this.add(this.getNow(), 3, this.fWeekShift + this.fWeekCount - 1)));
        }
    }
}

