/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupFolderElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.GroupByNoneDescription;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFolderAction
extends PlanViewModelAction<GroupFolderElement> {
    public DeleteFolderAction(IWorkbenchSite site, PlanViewModel viewModel) {
        super(site, viewModel, GroupFolderElement.class, ONE);
        this.setText(Messages.DeleteFolderAction_LABEL);
        this.setToolTipText(Messages.DeleteFolderAction_TOOLTIP);
    }

    @Override
    protected boolean checkElement(OutlineEntry<GroupFolderElement> selectedEntry) {
        GroupFolderElement folder = selectedEntry.getElement();
        return !folder.isBugFolder() && !folder.isTopItemFolder();
    }

    @Override
    public void run(Collection<OutlineEntry<GroupFolderElement>> selectedEntries) {
        OutlineEntry<GroupFolderElement> entry = selectedEntries.iterator().next();
        GroupByNoneDescription.MyFolderTransformer transformer = (GroupByNoneDescription.MyFolderTransformer)this.getPlanViewModel().getModelTransformer();
        GroupFolderElement gfe = entry.getElement();
        GroupFolderElement bugsFolder = transformer.getBugsFolder();
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.DeleteFolderAction_CONFIRMATION_TITLE, (String)NLS.bind((String)Messages.DeleteFolderAction_CONFIRMATION_MESSAGE, (Object[])new Object[]{gfe.getLabel().replace("&", "&&"), bugsFolder.getLabel().replace("&", "&&")}))) {
            return;
        }
        ((GroupByNoneDescription.MyFolderItemMovePolicy)this.getPlanViewModel().getOutlineSettings().getItemMovePolicy()).deleteFolder(entry, bugsFolder);
    }
}

