/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignTargetAction
extends PlanViewModelAction<PlanItem> {
    private IIteration fInterval;
    private final boolean fSetWorkAccepted;

    public AssignTargetAction(IWorkbenchSite site, PlanViewModel planViewModel, IIteration interval, boolean setWorkAccepted) {
        this(site, planViewModel, interval, setWorkAccepted, interval != null ? interval.getLabel() : Messages.AssignTargetAction_LABEL_UNASSIGN_ITERATION);
    }

    public AssignTargetAction(IWorkbenchSite site, PlanViewModel planViewModel, IIteration interval, boolean setWorkAccepted, String label) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.fInterval = interval;
        this.fSetWorkAccepted = setWorkAccepted;
        this.setText(label);
    }

    @Override
    protected void updateAction(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        this.setChecked(this.computeChecked(selectedEntries));
    }

    protected boolean computeChecked(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        for (OutlineEntry<PlanItem> selectedEntry : selectedEntries) {
            if (!this.computeChecked(selectedEntry.getElement())) continue;
            return true;
        }
        return false;
    }

    protected boolean computeChecked(PlanItem item) {
        IIteration currentTarget = item.getTarget();
        if (this.fInterval == null) {
            return currentTarget == null;
        }
        return this.fInterval.sameItemId((IItemHandle)currentTarget);
    }

    @Override
    public void run(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        for (OutlineEntry outlineEntry : selectedEntries) {
            final PlanItem item = (PlanItem)outlineEntry.getElement();
            item.getPlan().runWithDeltaBuilder(new Runnable(){

                public void run() {
                    item.setTarget(AssignTargetAction.this.fInterval);
                    if (AssignTargetAction.this.fSetWorkAccepted) {
                        item.markAsNewItem(false);
                    }
                    item.markRead();
                }
            });
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

