/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPlanItemAction
extends MovePlanItemAction<Object> {
    private String fWorkItemType;

    public AddPlanItemAction(IWorkbenchSite site, PlanViewModel planViewModel, IWorkItemType type) {
        super(site, planViewModel, Object.class, ONE);
        Assert.isNotNull((Object)type);
        this.setText(type.getDisplayName());
        this.setImageDescriptor(WorkItemUI.getImageDescriptor((IWorkItemType)type));
        this.fWorkItemType = type.getIdentifier();
    }

    public static void run(IWorkbenchSite site, PlanViewModel planViewModel, String type) {
        new AddPlanItemAction(site, planViewModel, type).run();
    }

    private AddPlanItemAction(IWorkbenchSite site, PlanViewModel planViewModel, String type) {
        super(site, planViewModel, Object.class, ONE);
        Assert.isNotNull((Object)type);
        this.fWorkItemType = type;
    }

    @Override
    protected boolean checkElement(OutlineEntry<Object> selectedEntry) {
        if (EntryUtils.isType(selectedEntry, PlanItem.class)) {
            return this.getMovePolicy().canAddItemBelow(selectedEntry);
        }
        if (EntryUtils.isType(selectedEntry, GroupElement.class)) {
            return this.getMovePolicy().canAddItemToGroup(EntryUtils.cast(selectedEntry, GroupElement.class));
        }
        return false;
    }

    @Override
    public void run(Collection<OutlineEntry<Object>> selectedEntries) {
        OutlineEntry selectedEntry = EntryUtils.firstEntry(selectedEntries);
        if (selectedEntry == null) {
            return;
        }
        try {
            IProgressService runnableContext = this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
            if (EntryUtils.isType(selectedEntry, PlanItem.class)) {
                this.getMovePolicy().addItemBelow(selectedEntry, this.fWorkItemType, (IRunnableContext)runnableContext);
            } else if (EntryUtils.isType(selectedEntry, GroupElement.class)) {
                this.getMovePolicy().addItemToGroup(EntryUtils.cast(selectedEntry, GroupElement.class), this.fWorkItemType, (IRunnableContext)runnableContext);
            }
        }
        catch (TeamRepositoryException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.AddPlanItemBelowAction_LABEL, Messages.AddPlanItemBelowAction_FAILED_MESSAGE);
        }
    }
}

