/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.ide.ui.IAttributeValueProposalProvider;
import com.ibm.team.process.ide.ui.IProcessCompletionProposal;
import com.ibm.team.process.ide.ui.IProcessProposalContext;
import com.ibm.team.process.ide.ui.ProcessCompletionProposalFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public final class RequiredEstimatesAttributeValueProposalProvider
implements IAttributeValueProposalProvider {
    private static final String ESTIMATE_ELEMENT = "estimate";
    private static final String ESTIMATES_ELEMENT = "estimates";
    private static final String ID_ATTRIBUTE = "id";
    private static final String REQUIRED_ESTIMATES_URI = "http://com.ibm.team.apt/requiredEstimates";
    private static final String[] SUPPORTED_REQUIRED_ESTIMATES = new String[]{WorkItem.DURATION_PROPERTY, WorkItem.CORRECTED_ESTIMATE_PROPERTY, WorkItem.TIME_SPENT_PROPERTY};
    private static final String WORK_ITEM_TYPE_ATTRIBUTE = "workItemType";
    private static final String WORK_ITEM_TYPE_CATEGORY_ATTRIBUTE = "workItemTypeCategory";

    private IProcessCompletionProposal[] computeAttributeProposals(IProcessProposalContext context) {
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>(SUPPORTED_REQUIRED_ESTIMATES.length);
        String[] stringArray = SUPPORTED_REQUIRED_ESTIMATES;
        int n = SUPPORTED_REQUIRED_ESTIMATES.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)WorkItemAttributes.getPropertyIdentifier((String)property).getStringIdentifier()));
            ++n2;
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    public IProcessCompletionProposal[] computeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) {
        try {
            return this.internalComputeProposals(processArea, context, monitor);
        }
        catch (TeamRepositoryException x) {
            PlanningUIPlugin.log("Exception computing completion proposals", x);
            return new IProcessCompletionProposal[0];
        }
    }

    private IProcessCompletionProposal[] computeWorkItemTypeCategoryProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List types = workItemClient.findWorkItemTypes(processArea.getProjectArea(), monitor);
        HashSet<String> categories = new HashSet<String>(types.size());
        for (IWorkItemType type : types) {
            categories.add(type.getCategory());
        }
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>(categories.size());
        for (String category : categories) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)category));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    private IProcessCompletionProposal[] computeWorkItemTypeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        List types = workItemClient.findWorkItemTypes(processArea.getProjectArea(), monitor);
        ArrayList<IProcessCompletionProposal> proposals = new ArrayList<IProcessCompletionProposal>(types.size());
        for (IWorkItemType type : types) {
            proposals.add(ProcessCompletionProposalFactory.createProposal((IProcessProposalContext)context, (String)type.getIdentifier(), (String)type.getDisplayName()));
        }
        return proposals.toArray(new IProcessCompletionProposal[proposals.size()]);
    }

    public IProcessCompletionProposal[] internalComputeProposals(IProcessArea processArea, IProcessProposalContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea != null && context.namespaceURI().equals(REQUIRED_ESTIMATES_URI) && context.getElement().equals(ESTIMATES_ELEMENT) && context.getAttribute().equals(WORK_ITEM_TYPE_ATTRIBUTE)) {
            return this.computeWorkItemTypeProposals(processArea, context, monitor);
        }
        if (processArea != null && context.namespaceURI().equals(REQUIRED_ESTIMATES_URI) && context.getElement().equals(ESTIMATES_ELEMENT) && context.getAttribute().equals(WORK_ITEM_TYPE_CATEGORY_ATTRIBUTE)) {
            return this.computeWorkItemTypeCategoryProposals(processArea, context, monitor);
        }
        if (context.namespaceURI().equals(REQUIRED_ESTIMATES_URI) && context.getElement().equals(ESTIMATE_ELEMENT) && context.getAttribute().equals(ID_ATTRIBUTE)) {
            return this.computeAttributeProposals(context);
        }
        return new IProcessCompletionProposal[0];
    }
}

