/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import com.ibm.team.apt.internal.ide.ui.actions.RecentlyUsedTagsManager;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditorInput;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.FilterUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkView;
import com.ibm.team.apt.internal.ide.ui.navigator.NewIterationPlanAction;
import com.ibm.team.apt.internal.ide.ui.util.IterationPlansDropDownAction;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningUIPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.ibm.team.apt.ide.ui";
    public static final String SYMBOLIC_PLAN_EDITOR_FONT_NAME = "com.ibm.team.apt.ide.ui.iterationPlanEditor.font";
    public static final String SYMBOLIC_PAGES_EDITOR_FONT_NAME = "com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font";
    private static PlanningUIPlugin plugin;
    private FilterUsageStatistics fFilterStatistics = null;
    private RecentlyUsedTagsManager fRecentlyUsedTagsMagaer = null;

    public PlanningUIPlugin() {
        plugin = this;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(String message, Throwable exception) {
        PlanningUIPlugin.log((IStatus)new Status(4, PlanningUI.getPluginId(), 0, message, exception));
    }

    public static void log(IStatus status) {
        PlanningUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        PlanningUIPlugin.log((IStatus)new Status(4, PlanningUI.getPluginId(), 4, "An internal error has occurred.", t));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fFilterStatistics != null) {
            this.fFilterStatistics.dispose();
            this.fFilterStatistics = null;
        }
        if (this.fRecentlyUsedTagsMagaer != null) {
            this.fRecentlyUsedTagsMagaer.dispose();
            this.fRecentlyUsedTagsMagaer = null;
        }
        super.stop(context);
        plugin = null;
    }

    public static PlanningUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return PlanningUIPlugin.getImageDescriptor(path, false);
    }

    public static ImageDescriptor getImageDescriptor(String path, boolean register) {
        ImageDescriptor result = AbstractUIPlugin.imageDescriptorFromPlugin((String)PlanningUI.getPluginId(), (String)path);
        if (result == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (register) {
            JazzResources.registerPath((ImageDescriptor)result, (String)PlanningUI.getPluginId(), (String)path);
        }
        return result;
    }

    public static void openIterationPlanMenu(IWorkbenchPage page, Point location, List<? extends IIterationPlanRecordHandle> plans) {
        if (plans.isEmpty()) {
            return;
        }
        if (plans.size() == 1) {
            PlanningUIPlugin.openIterationPlanEditor(plans.iterator().next(), null, page);
        } else {
            IterationPlansDropDownAction menuAction = new IterationPlansDropDownAction(page, plans);
            Shell shell = page.getActivePart().getSite().getShell();
            Menu menu = menuAction.getMenu((Control)shell);
            UI.showAndDisposeMenu(menu, location);
        }
    }

    public static void openIterationPlanEditor(final ITeamAreaHandle teamAreaHandle, final IIterationHandle iterationHandle, final IWorkbenchPage page) {
        FoundationJob job = new FoundationJob(Messages.PlanningUIPlugin_JOB_OPEN_PLAN){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                Display display = page.getWorkbenchWindow().getShell().getDisplay();
                IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)teamAreaHandle);
                IItemQueryPage result = ((IterationPlanClient)client).fetchIterationPlanRecords(Arrays.asList(teamAreaHandle), iterationHandle, 512);
                if (result.getResultSize() == 1) {
                    final IIterationPlanRecordHandle handle = (IIterationPlanRecordHandle)result.getItemHandles().get(0);
                    display.asyncExec(new Runnable(){

                        public void run() {
                            PlanningUIPlugin.openIterationPlanEditor(handle, null, page);
                        }
                    });
                } else {
                    IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)teamAreaHandle).itemManager();
                    final IIteration iteration = (IIteration)manager.fetchCompleteItem((IItemHandle)iterationHandle, 0, monitor);
                    final ITeamArea teamArea = (ITeamArea)manager.fetchCompleteItem((IItemHandle)teamAreaHandle, 0, monitor);
                    if (result.getResultSize() > 1) {
                        List list = result.getItemHandles();
                        final List items = manager.fetchPartialItems(list, 0, (Collection)Arrays.asList(IIterationPlanRecord.NAME_PROPERTY), monitor);
                        final Shell shell = page.getActivePart().getSite().getShell();
                        UI.syncExec((Control)shell, new Runnable(){

                            public void run() {
                                PlanningUIPlugin.openIterationPlanMenu(page, shell.getDisplay().getCursorLocation(), items);
                            }
                        });
                    } else {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                boolean create = MessageDialog.openQuestion((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.PlanningUIPlugin_NO_PLANS_CREATEDIALOG_TITLE, (String)NLS.bind((String)Messages.PlanningUIPlugin_NO_PLANS_CREATEDIALOG_MESSAGE, (Object[])new Object[]{teamArea.getName(), iteration.getLabel()}));
                                if (create) {
                                    IterationPlanWizardContext context = new IterationPlanWizardContext(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true));
                                    context.setSelectedProjectArea(teamArea.getProjectArea());
                                    context.setTeamArea((ITeamAreaHandle)teamArea);
                                    context.setIteration((IIterationHandle)iteration);
                                    new NewIterationPlanAction(page.getWorkbenchWindow().getWorkbench(), context).run();
                                }
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, IWorkbenchPage page) {
        return PlanningUIPlugin.openIterationPlanEditor(handle, null, page);
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, final IWikiPage wikiPage, final IWorkbenchPage page) {
        IterationPlanEditorInput input = new IterationPlanEditorInput(handle);
        try {
            final IEditorPart part = page.openEditor((IEditorInput)input, "com.ibm.team.apt.internal.ide.ui.IterationPlanEditor");
            if (wikiPage != null) {
                final Runnable runnable = new Runnable(){

                    public void run() {
                        ((IterationPlanEditor)part).revealAttachedPage(wikiPage);
                    }
                };
                final TeamFuture<IterationPlanData> future = input.getFuture();
                future.addListener((ITeamFutureListener)new TeamFutureAdapter<IterationPlanData>(){

                    public void resolvingDone(TeamFutureEvent<IterationPlanData> event) {
                        future.removeListener((ITeamFutureListener)this);
                        UI.asyncExec((Control)page.getWorkbenchWindow().getShell(), runnable);
                    }
                });
            }
            return part;
        }
        catch (PartInitException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean closeIterationPlanEditor(IIterationPlanRecordHandle handle, IWorkbenchPage page, boolean save) {
        try {
            IEditorReference[] editors;
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IEditorReference editor = iEditorReferenceArray[n2];
                if (editor.getEditorInput() instanceof IterationPlanEditorInput && ((IterationPlanEditorInput)editor.getEditorInput()).getHandle().sameItemId((IItemHandle)handle)) {
                    page.closeEditor(editor.getEditor(true), save);
                    return true;
                }
                ++n2;
            }
        }
        catch (PartInitException e) {
            PlanningUIPlugin.log(e);
        }
        return false;
    }

    public FilterUsageStatistics getFilterUsageStatistics() {
        if (this.fFilterStatistics == null) {
            this.fFilterStatistics = new FilterUsageStatistics();
        }
        return this.fFilterStatistics;
    }

    public IRecentlyUsedTagsRegistry getRecentlyUsedTagsRegistry() {
        if (this.fRecentlyUsedTagsMagaer == null) {
            this.fRecentlyUsedTagsMagaer = new RecentlyUsedTagsManager();
        }
        return this.fRecentlyUsedTagsMagaer;
    }

    public MyWorkView getMyWorkViewInstance() {
        return (MyWorkView)this.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ibm.team.apt.internal.ui.myWorkView");
    }
}

