/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.ide.ui.Messages;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IterationMigration;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class IterationPlanRecordDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final ColorDescriptor MY_PLAN_COLOR = ColorDescriptor.createFrom((RGB)new RGB(0, 0, 128));
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));

    public void decorate(Object element, IDecoration decoration) {
        block4: {
            IIterationPlanRecord record = (IIterationPlanRecord)element;
            ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)record);
            IItemManager manager = repository.itemManager();
            try {
                IIteration interval = (IIteration)manager.fetchPartialItem((IItemHandle)record.getIteration(), 0, Iterations.UI_PROFILE.getProperties(), null);
                decoration.addSuffix(NLS.bind((String)Messages.IterationPlanRecordDecorator_SUFFIX, (Object[])new Object[]{IterationMigration.getName((IIteration)interval)}));
                IContributor currentUser = repository.loggedInContributor();
                if (currentUser == null) break block4;
                ITeamArea teamArea = (ITeamArea)manager.fetchPartialItem((IItemHandle)record.getTeamArea(), 0, (Collection)Collections.singletonList(ProcessCommon.getPropertyName(ITeamArea.class, (String)"teamMembers")), null);
                IContributorHandle[] iContributorHandleArray = teamArea.getMembers();
                int n = iContributorHandleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributorHandle member = iContributorHandleArray[n2];
                    if (currentUser.sameItemId((IItemHandle)member)) {
                        decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)MY_PLAN_COLOR));
                        break;
                    }
                    ++n2;
                }
            }
            catch (TeamRepositoryException e) {
                PlanningUIPlugin.log(e);
            }
        }
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return super.isLabelProperty(element, property);
    }
}

