/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki.transformer;

import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachmentService;
import com.ibm.team.apt.internal.common.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.foundation.common.URILinkDetector;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceDetector
implements IItemReferenceDetector {
    private LinkDetector fDelegate;
    private URI fBaseUri;
    protected Map<String, IWikiPageAttachment> fAttachmentsMap = new HashMap<String, IWikiPageAttachment>();

    public DefaultReferenceDetector(URI baseUri) {
        this(baseUri, false);
    }

    public DefaultReferenceDetector(URI baseUri, boolean isServer) {
        Assert.isNotNull((Object)baseUri);
        this.fBaseUri = baseUri;
        this.fDelegate = TextLinkDetectorManager.getDefault().createLinkDetector(isServer);
        this.fDelegate.setBaseURI(baseUri);
        this.fDelegate.addTextLinkDetector((TextLinkDetector)new URILinkDetector());
    }

    public void setAttachments(List<IWikiPageAttachment> attachments) {
        Assert.isNotNull(attachments);
        this.fAttachmentsMap.clear();
        for (IWikiPageAttachment attachment : attachments) {
            this.fAttachmentsMap.put(attachment.getName(), attachment);
        }
    }

    @Override
    public IItemReferenceDetector.Reference detect(String text) {
        List uris;
        IWikiPageAttachment attachment = this.fAttachmentsMap.get(text);
        if (attachment != null) {
            String query = "itemId=" + attachment.getItemId().getUuidValue();
            return new IItemReferenceDetector.Reference(Location.serviceLocation((String)this.fBaseUri.toASCIIString(), IWikiPageAttachmentService.class, (String)attachment.getName(), (String)query));
        }
        List match = this.fDelegate.match(text);
        if (!match.isEmpty() && !(uris = ((DetectedTextLink)match.get(0)).createURIs()).isEmpty()) {
            URI uri = (URI)((DetectedTextLink)match.get(0)).createURIs().get(0);
            try {
                Location location = Location.location((URI)uri);
                return DefaultReferenceDetector.safeReference(location);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
        if (this.fBaseUri != null) {
            URI uri;
            try {
                uri = new URI(text);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            try {
                Location tmp = Location.location((URI)uri);
                Location location = Location.location((Location)tmp, (String)this.fBaseUri.toASCIIString(), null);
                return DefaultReferenceDetector.safeReference(location);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
        return null;
    }

    private static IItemReferenceDetector.Reference safeReference(Location location) {
        if (location.getType() == null) {
            return null;
        }
        return new IItemReferenceDetector.Reference(location);
    }
}

