/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationHierarchy {
    private IDevelopmentLine fDevLine;
    private ItemList<IIteration> fAllPastIterations;
    private ItemList<IIteration> fPastIterations;
    private ItemList<IIteration> fAllCurrentIterations;
    private ItemList<IIteration> fAllFutureIterations;
    private ItemList<IIteration> fFutureIterations;
    private ItemMap<IIterationHandle, IIteration> fIterations;

    public static IterationHierarchy create(IDevelopmentLineHandle handle, ItemAccessHelper itemAccessHelper, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IterationHierarchy(handle, itemAccessHelper, monitor);
    }

    private IterationHierarchy(IDevelopmentLineHandle handle, ItemAccessHelper itemAccessHelper, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fDevLine = (IDevelopmentLine)itemAccessHelper.fetchCompleteItem((IItemHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IIteration[] iterations = itemAccessHelper.getCurrentIterations(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.fIterations = new ItemHashMap<IIterationHandle, IIteration>();
        ArrayList<IIteration> ci = new ArrayList<IIteration>(iterations.length);
        IIteration[] iIterationArray = iterations;
        int n = iterations.length;
        int n2 = 0;
        while (n2 < n) {
            IIteration iteration = iIterationArray[n2];
            ci.add(iteration);
            ++n2;
        }
        Collections.reverse(ci);
        this.fAllCurrentIterations = new ItemArrayList<IIteration>(ci, CMode.CURRENT_HANDLEONLY);
        this.fAllPastIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fPastIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fAllFutureIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fFutureIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        IItem[] children = itemAccessHelper.fetchCompleteItems((IItemHandle[])this.fDevLine.getIterations(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        boolean traversedCurrent = false;
        IItem[] iItemArray = children;
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IItem iteration = iItemArray[n4];
            this.processIteration((IIteration)iteration, traversedCurrent, itemAccessHelper, monitor);
            traversedCurrent = traversedCurrent || this.fAllCurrentIterations.contains(iteration);
            ++n4;
        }
        this.cleanupIterations(this.fAllCurrentIterations);
        this.cleanupIterations(this.fAllPastIterations);
        this.cleanupIterations(this.fPastIterations);
        this.cleanupIterations(this.fAllFutureIterations);
        this.cleanupIterations(this.fFutureIterations);
    }

    private boolean processIteration(IIteration iteration, boolean traversedCurrent, ItemAccessHelper itemAccessHelper, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fIterations.put((IIterationHandle)iteration.getItemHandle(), iteration);
        IIterationHandle[] childHandles = iteration.getChildren();
        int processedChildren = 0;
        if (childHandles.length > 0) {
            IItem[] children = itemAccessHelper.fetchCompleteItems((IItemHandle[])childHandles, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            boolean childTraversal = traversedCurrent;
            IItem[] iItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IItem child = iItemArray[n2];
                if (this.processIteration((IIteration)child, childTraversal, itemAccessHelper, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                    ++processedChildren;
                    childTraversal = childTraversal || this.fAllCurrentIterations.contains(child);
                }
                ++n2;
            }
        }
        boolean isRelevantLeaf = processedChildren == 0 && iteration.hasDeliverable() && !iteration.isArchived();
        boolean isCurrent = this.fAllCurrentIterations.contains(iteration);
        if (traversedCurrent) {
            this.fAllFutureIterations.add(iteration);
            if (isRelevantLeaf) {
                this.fFutureIterations.add(iteration);
            }
        } else if (!isCurrent) {
            this.fAllPastIterations.add(iteration);
            if (isRelevantLeaf) {
                this.fPastIterations.add(iteration);
            }
        }
        return processedChildren > 0 || iteration.hasDeliverable() && !iteration.isArchived();
    }

    private void cleanupIterations(ItemList<IIteration> list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IIteration iteration = (IIteration)iter.next();
            if (!iteration.isArchived() && iteration.hasDeliverable()) continue;
            iter.remove();
        }
    }

    public IIteration getIteration(IIterationHandle handle) {
        return this.fIterations.get((IItemHandle)handle);
    }

    public ItemList<IIteration> getAllIterations() {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>(this.fAllPastIterations.size() + this.fAllCurrentIterations.size() + this.fAllFutureIterations.size());
        result.addAll(this.fAllPastIterations);
        result.addAll(this.fAllCurrentIterations);
        result.addAll(this.fAllFutureIterations);
        return result;
    }

    public ItemList<IIteration> getPastIterations() {
        return this.fPastIterations;
    }

    public ItemList<IIteration> getAllPastIterations() {
        return this.fAllPastIterations;
    }

    public IIteration getCurrentIteration() {
        if (this.fAllCurrentIterations.isEmpty()) {
            return null;
        }
        return this.fAllCurrentIterations.get(0);
    }

    public ItemList<IIteration> getAllCurrentIterations() {
        return this.fAllCurrentIterations;
    }

    public ItemList<IIteration> getFutureIterations() {
        return this.fFutureIterations;
    }

    public ItemList<IIteration> getAllFutureIterations() {
        return this.fAllFutureIterations;
    }

    public static interface ItemAccessHelper {
        public IItem fetchCompleteItem(IItemHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IItem[] fetchCompleteItems(IItemHandle[] var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IIteration[] getCurrentIterations(IDevelopmentLineHandle var1, IProgressMonitor var2) throws TeamRepositoryException;
    }
}

