/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.wiki;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.client.wiki.Messages;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.client.wiki.WikiPageSaveResult;
import com.ibm.team.apt.internal.common.wiki.IWikiCommonLibrary;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.common.wiki.IWikiService;
import com.ibm.team.apt.internal.common.wiki.WikiPath;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IDetailedStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiManager
implements IWikiCommonLibrary {
    private IClientLibraryContext fContext;
    private IWikiService fService;

    public WikiManager(IClientLibraryContext context) {
        this.fContext = context;
    }

    public List<IWikiPageAttachment> findAttachments(final IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)page);
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List<IWikiPageAttachment>>(){

            public List<IWikiPageAttachment> run(IProgressMonitor monitor) throws TeamRepositoryException {
                List<IWikiPageAttachment> list = Arrays.asList(WikiManager.this.getService().findAttachments((IWikiPageHandle)page));
                return list;
            }
        }, monitor);
    }

    public List<ResolvedWikiPageAttachment> findResolvedAttachments(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)page);
        IItemManager manager = this.getTeamRepository().itemManager();
        List<IWikiPageAttachment> attachments = this.findAttachments(page, monitor);
        ArrayList<ResolvedWikiPageAttachment> resolvedAttachments = new ArrayList<ResolvedWikiPageAttachment>(attachments.size());
        for (IWikiPageAttachment attachment : attachments) {
            IContributor creator = (IContributor)manager.fetchCompleteItem((IItemHandle)attachment.getCreator(), 0, monitor);
            resolvedAttachments.add(new ResolvedWikiPageAttachment(attachment, creator, Attachments.isPredefined(attachment, monitor)));
        }
        return resolvedAttachments;
    }

    public IWikiPageAttachment saveAttachment(final IWikiPageAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)attachment);
        return (IWikiPageAttachment)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IWikiPageAttachment>(){

            public IWikiPageAttachment run(IProgressMonitor monitor) throws TeamRepositoryException {
                IWikiPageAttachment savedAttachment = WikiManager.this.getService().saveAttachment(attachment);
                WikiManager.this.getTeamRepository().itemManager().applyItemUpdates(Arrays.asList(savedAttachment));
                return savedAttachment;
            }
        }, monitor);
    }

    public void deleteAttachment(final IWikiPageAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)attachment);
        this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Void>(){

            public Void run(IProgressMonitor monitor) throws TeamRepositoryException {
                WikiManager.this.getService().deleteAttachment(attachment);
                WikiManager.this.getTeamRepository().itemManager().applyItemDeletes(Arrays.asList(attachment));
                return null;
            }
        }, monitor);
    }

    public IWikiPage createPageUsingOwner(final IItemHandle owner, final String pageId, final String pageTitle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IWikiPage[] result = new IWikiPage[1];
        IProcessClientService process = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        try {
            process.execute(new ProcessRunnable(){

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    result[0] = WikiManager.this.getService().createPageUsingOwner(owner, pageId, pageTitle);
                    return null;
                }
            }, Messages.WikiManager_JOB_CREATE_PAGE, monitor);
        }
        catch (TeamOperationCanceledException teamOperationCanceledException) {
            return null;
        }
        return result[0];
    }

    public IWikiPage createPageUsingPath(final WikiPath wikiPath, IProgressMonitor monitor) throws TeamRepositoryException {
        final IWikiPage[] result = new IWikiPage[1];
        IProcessClientService process = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        try {
            process.execute(new ProcessRunnable(){

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    result[0] = WikiManager.this.getService().createPageUsingPath(wikiPath.getPagePath());
                    return null;
                }
            }, Messages.WikiManager_JOB_CREATE_PAGE, monitor);
        }
        catch (TeamOperationCanceledException teamOperationCanceledException) {
            return null;
        }
        return result[0];
    }

    public IWikiPage findPageUsingOwner(final IItemHandle owner, final String pageId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWikiPage)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IWikiPage>(){

            public IWikiPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WikiManager.this.getService().findPageUsingOwner(owner, pageId);
            }
        }, monitor);
    }

    public IWikiPage findPageUsingPath(final WikiPath wikiPath, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWikiPage)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IWikiPage>(){

            public IWikiPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WikiManager.this.getService().findPageUsingPath(wikiPath.getPagePath());
            }
        }, monitor);
    }

    public ResolvedWikiPage findResolvedPageUsingOwner(IItemHandle owner, String pageId, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IWikiPage result = this.findPageUsingOwner(owner, pageId, monitor);
        if (result == null) {
            return null;
        }
        return this.resolvedPage(result, monitor);
    }

    public ResolvedWikiPage findResolvedPageUsingPath(WikiPath wikiPath, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IWikiPage result = this.findPageUsingPath(wikiPath, monitor);
        if (result == null) {
            return null;
        }
        return this.resolvedPage(result, monitor);
    }

    public ResolvedWikiPage findResolvedPageUsingHandle(IWikiPageHandle handle, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
        IWikiPage page = (IWikiPage)repository.itemManager().fetchCompleteItem((IItemHandle)handle, 1, monitor);
        if (page == null) {
            return null;
        }
        return this.resolvedPage(page, monitor);
    }

    public ResolvedWikiPage resolvedPage(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IItemManager itemManager = this.getTeamRepository().itemManager();
        IItem owner = itemManager.fetchCompleteItem(page.getOwner(), 0, monitor);
        XMLString content = this.loadXMLContent(page, monitor);
        IContributor modifier = (IContributor)itemManager.fetchCompleteItem((IItemHandle)page.getModifiedBy(), 0, monitor);
        WikiPath realPath = this.createWikiPath(owner, page.getWikiID(), monitor);
        List<ResolvedWikiPageAttachment> attachments = this.findResolvedAttachments(page, monitor);
        return new ResolvedWikiPage(page, owner, content, modifier, realPath, attachments);
    }

    private WikiPath createWikiPath(IItem owner, String pageName, IProgressMonitor monitor) throws TeamRepositoryException {
        if (owner instanceof IContributor) {
            return WikiPath.create((IContributor)((IContributor)owner), (String)pageName);
        }
        if (owner instanceof IProjectArea) {
            return WikiPath.create((IProjectArea)((IProjectArea)owner), (String)pageName);
        }
        if (owner instanceof ITeamArea) {
            ITeamArea area = (ITeamArea)owner;
            IItemManager itemManager = this.getTeamRepository().itemManager();
            IProjectArea root = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)area.getProjectArea(), 0, monitor);
            ITeamAreaHierarchy hierarchy = root.getTeamAreaHierarchy();
            ITeamArea parent = area;
            ArrayList<ITeamArea> parents = new ArrayList<ITeamArea>();
            while ((parent = hierarchy.getParent((ITeamAreaHandle)parent)) != null) {
                parents.add(parent);
            }
            Collections.reverse(parents);
            ArrayList<Object> path = new ArrayList<Object>(parents.size() + 2);
            path.add(root);
            path.addAll(itemManager.fetchCompleteItems(parents, 0, monitor));
            path.add(area);
            return WikiPath.create(path, (String)pageName);
        }
        if (owner instanceof IIterationPlanRecord) {
            return WikiPath.create((IIterationPlanRecord)((IIterationPlanRecord)owner), (String)pageName);
        }
        return null;
    }

    public boolean checkCanSave(IWikiPage page) throws TeamRepositoryException {
        IOperationReport status = this.getService().checkPermissionUsingWikiPage(page, "com.ibm.team.apt.server.saveWikiPage", new String[]{"modify"});
        return status == null || status.getSeverity() == 0;
    }

    public boolean checkCanSave(IProcessArea process) throws TeamRepositoryException {
        IOperationReport status = this.getService().checkPermissionUsingProcessArea(process, "com.ibm.team.apt.server.saveWikiPage", new String[]{"modify"});
        return status == null || status.getSeverity() == 0;
    }

    public IWikiPageSafeRunnable createWikiPageSafeRunnable(final ResolvedWikiPage resolvedPage, final boolean ignoreContent, final IProgressMonitor monitor) {
        return new IWikiPageSafeRunnable(){
            private IWikiPage fWikiPage;
            {
                this.fWikiPage = resolvedWikiPage.getWikiPage().isWorkingCopy() ? resolvedWikiPage.getWikiPage() : resolvedWikiPage.getWikiPage().getWorkingCopy();
            }

            public IWikiPage getWikiPage() {
                return this.fWikiPage;
            }

            public IWikiPage preSave() throws TeamRepositoryException {
                if (ignoreContent || resolvedPage.getContent() != null) {
                    String xmlText = resolvedPage.getContent().getXMLText();
                    IContent content = WikiManager.this.fContext.teamRepository().contentManager().storeContent("text/plain", xmlText, monitor);
                    this.fWikiPage.setContent(content);
                }
                return this.fWikiPage;
            }

            public void postSave(IWikiPage page) {
                resolvedPage.postSave(page, !ignoreContent);
            }

            public void handleException(TeamRepositoryException e) {
            }
        };
    }

    public void deletePage(final IWikiPageHandle pageHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ((IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class)).execute(new ProcessRunnable(){

            public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                WikiManager.this.getService().deletePage(pageHandle);
                return null;
            }
        }, Messages.WikiManager_JOB_DELETE_PAGE, monitor);
    }

    public void renamePage(ResolvedWikiPage resolvedWikiPage, String name, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IWikiPage page = this.ensureIsWorkingCopy(resolvedWikiPage.getWikiPage());
        page = this.savePage(page, null, monitor).getWikiPage();
        resolvedWikiPage.postSave(page, true);
    }

    public WikiPageSaveResult savePage(final IWikiPage page, XMLString xhtmlContent, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        final String xmlText = xhtmlContent == null ? null : xhtmlContent.getXMLText();
        final IWikiPage[] result = new IWikiPage[1];
        IProcessClientService process = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        try {
            IOperationReport report = process.execute(new ProcessRunnable(){

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    IWikiPage savePage = WikiManager.this.ensureIsWorkingCopy(page);
                    if (xmlText != null) {
                        IContent content = WikiManager.this.fContext.teamRepository().contentManager().storeContent("text/plain", xmlText, monitor);
                        savePage.setContent(content);
                    }
                    result[0] = WikiManager.this.getService().savePage(savePage);
                    return null;
                }
            }, Messages.WikiManager_JOB_SAVE_PAGE, monitor);
            return new WikiPageSaveResult(result[0], (IDetailedStatus)new DetailedStatus(Status.OK_STATUS, report));
        }
        catch (TeamOperationCanceledException e) {
            if (e.getReport() == null) {
                return new WikiPageSaveResult(null, (IDetailedStatus)new DetailedStatus(4, PlanningClientPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
            return new WikiPageSaveResult(null, DetailedStatus.createFromException((String)"", (Throwable)e));
        }
    }

    public XMLString loadXMLContent(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IContent content = page.getContent();
        XMLString result = null;
        if (content != null) {
            InputStream input = this.fContext.teamRepository().contentManager().retrieveContentStream(content, monitor);
            try {
                int read;
                InputStreamReader reader = new InputStreamReader(input, content.getCharacterEncoding());
                char[] buffer = new char[1024];
                StringBuilder xmlString = new StringBuilder();
                while ((read = reader.read(buffer)) != -1) {
                    xmlString.append(buffer, 0, read);
                }
                result = XMLString.createFromXMLText((String)xmlString.toString());
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private IWikiPage ensureIsWorkingCopy(IWikiPage wikiPage) {
        return wikiPage.isWorkingCopy() ? wikiPage : wikiPage.getWorkingCopy();
    }

    public ITeamRepository getTeamRepository() {
        return this.fContext.teamRepository();
    }

    public IQueryService getQueryService() {
        return (IQueryService)this.fContext.getServiceInterface(IQueryService.class);
    }

    private IWikiService getService() {
        if (this.fService != null) {
            return this.fService;
        }
        this.fService = (IWikiService)this.fContext.getServiceInterface(IWikiService.class);
        return this.fService;
    }
}

