/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.resource;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorResourceDetails;
import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.IProcessAreaInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningListener;
import com.ibm.team.apt.internal.client.resource.Messages;
import com.ibm.team.apt.internal.client.resource.ProjectWorkEnvironment;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningClient;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningEvent;
import com.ibm.team.apt.internal.client.util.LRUElementCache;
import com.ibm.team.apt.internal.common.resource.dto.DTO_ContributorInfo;
import com.ibm.team.apt.internal.common.resource.dto.DTO_TeamInfo;
import com.ibm.team.apt.internal.common.resource.dto.DtoFactory;
import com.ibm.team.apt.internal.common.resource.model.ResourceFactory;
import com.ibm.team.apt.internal.common.resource.model.WeekDay;
import com.ibm.team.apt.internal.common.resource.model.WorkDayDefinition;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcePlanningManager {
    private static final int AVERAGE_MEMBERS = 16;
    private static final int CACHE_SIZE = 32;
    private static final ISchedulingRule EXCLUSIVE_SCHEDULING_RULE = new ExclusiveSchedulingRule();
    private static final long EXPIRY_INTERVAL = 180000L;
    private static final long LONG_EXPIRY_INTERVAL = 0x6DDD00L;
    private static final UUID UNASSIGNED_UUID = DefaultModel.NULL_CONTRIBUTOR_ITEM_ID;
    private final LRUElementCache<UUID, ResourcePlanningEntry<ProcessAreaInfo>> fAreaCache = new LRUElementCache<UUID, ResourcePlanningEntry<ProcessAreaInfo>>(4, 2){
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized ResourcePlanningEntry<ProcessAreaInfo> remove(Object key) {
            ResourcePlanningEntry entry = (ResourcePlanningEntry)super.remove(key);
            if (entry != null) {
                ProcessAreaInfo info = (ProcessAreaInfo)entry.getValue();
                ResourcePlanningManager.this.fireInfoRemoved((IAuditableHandle)info.getProcessArea(), info);
            }
            return entry;
        }

        @Override
        protected synchronized boolean removeEldestEntry(Map.Entry<UUID, ResourcePlanningEntry<ProcessAreaInfo>> entry) {
            boolean result = super.removeEldestEntry(entry);
            if (result) {
                ProcessAreaInfo info = entry.getValue().getValue();
                ResourcePlanningManager.this.fireInfoRemoved((IAuditableHandle)info.getProcessArea(), info);
            }
            return result;
        }
    };
    private final ResourcePlanningClient fClient;
    private final LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> fContributorCache = new LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>>(32, 16){
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized ResourcePlanningEntry<DTO_ContributorInfo> remove(Object key) {
            ResourcePlanningEntry entry = (ResourcePlanningEntry)super.remove(key);
            if (entry != null) {
                IContributorHandle contributor = ((DTO_ContributorInfo)entry.getValue()).getContributor();
                ResourcePlanningManager.this.fireInfoRemoved((IAuditableHandle)contributor, new ContributorInfo(contributor, entry));
            }
            return entry;
        }

        @Override
        protected synchronized boolean removeEldestEntry(Map.Entry<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> entry) {
            boolean result = super.removeEldestEntry(entry);
            if (result) {
                ResourcePlanningEntry<DTO_ContributorInfo> value = entry.getValue();
                IContributorHandle contributor = value.getValue().getContributor();
                ResourcePlanningManager.this.fireInfoRemoved((IAuditableHandle)contributor, new ContributorInfo(contributor, value));
            }
            return result;
        }
    };
    private TeamRepositoryListener fListener = null;
    private final ListenerList fListeners = new ListenerList(1);
    private final ResourcePlanningEntry<DTO_ContributorInfo> fUnassignedEntry;

    private static boolean needsUpdate(UUID uuid, ResourcePlanningEntry<DTO_ContributorInfo> entry, Timestamp lower, Timestamp upper, Timestamp threshold, boolean synchronize) {
        Assert.isNotNull((Object)uuid);
        if (entry == null) {
            return true;
        }
        if (lower.before(entry.getLower())) {
            return true;
        }
        if (upper != null && entry.getUpper() != null && upper.after(entry.getUpper())) {
            return true;
        }
        if (upper == null && entry.getUpper() != null) {
            return true;
        }
        DTO_ContributorInfo info = entry.getValue();
        Timestamp time = info.getTimeStamp();
        if (time != null && time.before(threshold)) {
            return true;
        }
        return synchronize && !info.isSynchronized();
    }

    private static boolean sameContributorInfos(DTO_ContributorInfo first, DTO_ContributorInfo second) {
        return EcoreUtil.equals((EObject)((EObject)first), (EObject)((EObject)second));
    }

    private static boolean sameProcessAreaInfos(ProcessAreaInfo first, ProcessAreaInfo second) {
        if (!first.getProcessArea().sameItemId((IItemHandle)second.getProcessArea())) {
            return false;
        }
        return EcoreUtil.equals((EObject)((EObject)first.getWorkLocation()), (EObject)((EObject)second.getWorkLocation()));
    }

    ResourcePlanningManager(ResourcePlanningClient client) {
        Assert.isNotNull((Object)client);
        this.fClient = client;
        DTO_ContributorInfo info = DtoFactory.eINSTANCE.createDTO_ContributorInfo();
        info.setContributor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)this.fClient.getTeamRepository(), UNASSIGNED_UUID, null));
        WorkLocationDefinition definition = (WorkLocationDefinition)ResourcePlanningUtils.createWorkLocation((int)5, (int)8, (Locale)Locale.getDefault());
        definition.setCustomized(true);
        definition.setUniversal(false);
        info.setWorkLocation((IWorkLocationDefinition)definition);
        info.setSynchronized(true);
        info.setTimeStamp(new Timestamp(0x7FFFFFFFFFFFFFFEL));
        this.fUnassignedEntry = new ResourcePlanningEntry<DTO_ContributorInfo>(info, new Timestamp(0L), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceListener(IResourcePlanningListener listener) {
        Assert.isNotNull((Object)listener);
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            boolean one = false;
            int previous = -1;
            ListenerList listenerList = this.fListeners;
            synchronized (listenerList) {
                previous = this.fListeners.size();
                this.fListeners.add((Object)listener);
                if (this.fListeners.size() == 1) {
                    one = true;
                    this.hookItemManager();
                }
            }
            if (one && previous == 0) {
                this.fContributorCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContributorInfo findCachedContributorInfo(IContributorHandle contributor) {
        Assert.isNotNull((Object)contributor);
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            UUID uuid = contributor.getItemId();
            if (UNASSIGNED_UUID.equals((Object)uuid)) {
                return new ContributorInfo(contributor, this.fUnassignedEntry);
            }
            Timestamp stamp = new Timestamp(System.currentTimeMillis() - 180000L);
            ResourcePlanningEntry entry = (ResourcePlanningEntry)this.fContributorCache.get(uuid);
            if (entry != null && !((DTO_ContributorInfo)entry.getValue()).getTimeStamp().before(stamp)) {
                return new ContributorInfo(contributor, entry);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessAreaInfo findCachedProcessAreaInfo(IProcessAreaHandle area) {
        Assert.isNotNull((Object)area);
        LRUElementCache<UUID, ResourcePlanningEntry<ProcessAreaInfo>> lRUElementCache = this.fAreaCache;
        synchronized (lRUElementCache) {
            Timestamp stamp = new Timestamp(System.currentTimeMillis() - 0x6DDD00L);
            ResourcePlanningEntry entry = (ResourcePlanningEntry)this.fAreaCache.get(area.getItemId());
            if (entry != null && !((ProcessAreaInfo)entry.getValue()).getStamp().before(stamp)) {
                return (IProcessAreaInfo)entry.getValue();
            }
        }
        return null;
    }

    private void fireInfoAdded(final IAuditableHandle auditable, final IResourcePlanningInfo info) {
        Job job = new Job(Messages.ResourcePlanningManager_0){

            protected IStatus run(IProgressMonitor monitor) {
                Object[] listeners;
                Object[] objectArray = listeners = ResourcePlanningManager.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    final IResourcePlanningListener listener = (IResourcePlanningListener)object;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            PlanningClientPlugin.log(exception);
                        }

                        public void run() throws Exception {
                            listener.resourceNotification(new ResourcePlanningEvent(ResourcePlanningManager.this, auditable, info, 1));
                        }
                    });
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private void fireInfoRemoved(final IAuditableHandle auditable, final IResourcePlanningInfo info) {
        Job job = new Job(Messages.ResourcePlanningManager_1){

            protected IStatus run(IProgressMonitor monitor) {
                Object[] listeners;
                Object[] objectArray = listeners = ResourcePlanningManager.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    final IResourcePlanningListener listener = (IResourcePlanningListener)object;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            PlanningClientPlugin.log(exception);
                        }

                        public void run() throws Exception {
                            listener.resourceNotification(new ResourcePlanningEvent(ResourcePlanningManager.this, auditable, info, 3));
                        }
                    });
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private void fireInfoUpdated(final IAuditableHandle auditable, final IResourcePlanningInfo info) {
        Job job = new Job(Messages.ResourcePlanningManager_2){

            protected IStatus run(IProgressMonitor monitor) {
                Object[] listeners;
                Object[] objectArray = listeners = ResourcePlanningManager.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    final IResourcePlanningListener listener = (IResourcePlanningListener)object;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            PlanningClientPlugin.log(exception);
                        }

                        public void run() throws Exception {
                            listener.resourceNotification(new ResourcePlanningEvent(ResourcePlanningManager.this, auditable, info, 2));
                        }
                    });
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    public IContributorInfo getContributorInfo(IContributorHandle contributor, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)contributor);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(1, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return this.getContributorInfo((ItemCollection<IContributorHandle>)ItemCollections.singleton((Object)contributor), new Timestamp(calendar.getTimeInMillis()), null, refresh, true, monitor);
    }

    public IContributorInfo getContributorInfo(IContributorHandle contributor, Timestamp start, Timestamp end, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)contributor);
        return this.getContributorInfo((ItemCollection<IContributorHandle>)ItemCollections.singleton((Object)contributor), start, end, false, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContributorInfo getContributorInfo(ItemCollection<IContributorHandle> contributors, Timestamp start, Timestamp end, boolean refresh, boolean synchronize, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull(contributors);
        this.hookItemManager();
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            int delta = contributors.size() - this.fContributorCache.getSize();
            if (delta > 0) {
                this.fContributorCache.increaseSize(delta);
            }
            ArrayList<IContributorHandle> toFetch = new ArrayList<IContributorHandle>(contributors.size());
            ArrayList<ResourcePlanningEntry> toMatch = new ArrayList<ResourcePlanningEntry>(contributors.size());
            Timestamp threshold = new Timestamp(System.currentTimeMillis() - 180000L);
            for (IContributorHandle contributor : contributors) {
                UUID uuid = contributor.getItemId();
                if (UNASSIGNED_UUID.equals((Object)uuid)) continue;
                ResourcePlanningEntry entry = (ResourcePlanningEntry)this.fContributorCache.get(uuid);
                if (!refresh && !ResourcePlanningManager.needsUpdate(uuid, entry, start, end, threshold, synchronize)) continue;
                toFetch.add(contributor);
                if (entry == null) continue;
                toMatch.add(entry);
            }
            HashMap<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> cached = new HashMap<UUID, ResourcePlanningEntry<DTO_ContributorInfo>>(this.fContributorCache);
            cached.put(UNASSIGNED_UUID, this.fUnassignedEntry);
            if (!toFetch.isEmpty()) {
                Timestamp lower = start;
                Timestamp upper = end;
                for (ResourcePlanningEntry entry : toMatch) {
                    if (entry.getLower().before(lower)) {
                        lower = entry.getLower();
                    }
                    if (upper == null) continue;
                    Timestamp stamp = entry.getUpper();
                    if (stamp == null) {
                        upper = null;
                        continue;
                    }
                    if (!stamp.after(upper)) continue;
                    upper = stamp;
                }
                DTO_ContributorInfo[] infos = this.fClient.fetchContributorInfo(toFetch.toArray(new IContributorHandle[toFetch.size()]), lower, upper, synchronize, monitor);
                try {
                    this.unhookItemManager();
                    DTO_ContributorInfo[] dTO_ContributorInfoArray = infos;
                    int n = infos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DTO_ContributorInfo info = dTO_ContributorInfoArray[n2];
                        ResourcePlanningEntry<DTO_ContributorInfo> entry = new ResourcePlanningEntry<DTO_ContributorInfo>(info, lower, upper);
                        cached.put(info.getContributor().getItemId(), entry);
                        this.updateContributorCache(entry);
                        this.updateItemManager(entry);
                        ++n2;
                    }
                }
                finally {
                    this.hookItemManager();
                }
            }
            return new ContributorInfo(contributors, cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessAreaInfo getProcessAreaInfo(IProcessAreaHandle area, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)area);
        this.hookItemManager();
        LRUElementCache<UUID, ResourcePlanningEntry<ProcessAreaInfo>> lRUElementCache = this.fAreaCache;
        synchronized (lRUElementCache) {
            ProcessAreaInfo cached;
            if (!refresh && (cached = (ProcessAreaInfo)this.findCachedProcessAreaInfo(area)) != null) {
                return cached;
            }
            ProcessAreaInfo result = new ProcessAreaInfo(area, this.fClient.getWorkLocation(area, monitor));
            this.updateProcessAreaCache(new ResourcePlanningEntry<ProcessAreaInfo>(result));
            return result;
        }
    }

    public IResourcePlanningClient getResourcePlanningClient() {
        return this.fClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContributorInfo getTeamInfo(ItemCollection<ITeamAreaHandle> areas, IProgressMonitor monitor) throws TeamRepositoryException {
        this.hookItemManager();
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            DTO_TeamInfo[] teamInfos;
            int size = 0;
            ItemHashSet contributors = new ItemHashSet(areas.size() * 16);
            HashMap<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> cached = new HashMap<UUID, ResourcePlanningEntry<DTO_ContributorInfo>>(this.fContributorCache);
            cached.put(UNASSIGNED_UUID, this.fUnassignedEntry);
            DTO_TeamInfo[] dTO_TeamInfoArray = teamInfos = this.fClient.fetchTeamInfo((ITeamAreaHandle[])areas.toArray((Object[])new ITeamAreaHandle[areas.size()]), new Timestamp(0L), null, true, monitor);
            int n = teamInfos.length;
            int n2 = 0;
            while (n2 < n) {
                DTO_TeamInfo teamInfo = dTO_TeamInfoArray[n2];
                List contributorInfos = teamInfo.getContributorInfos();
                int delta = (size += contributorInfos.size()) - this.fContributorCache.getSize();
                if (delta > 0) {
                    this.fContributorCache.increaseSize(delta);
                }
                try {
                    this.unhookItemManager();
                    for (DTO_ContributorInfo contributorInfo : contributorInfos) {
                        IContributorHandle contributor = contributorInfo.getContributor();
                        ResourcePlanningEntry<DTO_ContributorInfo> entry = new ResourcePlanningEntry<DTO_ContributorInfo>(contributorInfo, new Timestamp(0L), null);
                        cached.put(contributor.getItemId(), entry);
                        this.updateContributorCache(entry);
                        this.updateItemManager(entry);
                        contributors.add((Object)contributor);
                    }
                }
                finally {
                    this.hookItemManager();
                }
                ++n2;
            }
            return new ContributorInfo((ItemCollection<IContributorHandle>)contributors, cached);
        }
    }

    public ProjectWorkEnvironment getProjectWorkEnvironment(IProcessAreaHandle processAreaHandle, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        int hours = 8;
        int days = 5;
        IProcessAreaInfo info = this.getProcessAreaInfo(processAreaHandle, refresh, monitor);
        if (info != null) {
            if (info.getWorkWeekDays() > 0) {
                days = info.getWorkWeekDays();
            }
            if (info.getWorkDayHours() > 0) {
                hours = info.getWorkDayHours();
            }
        }
        return new ProjectWorkEnvironment(hours, days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hookItemManager() {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            if (this.fListener == null) {
                this.fListener = new TeamRepositoryListener();
                IItemManager manager = this.fClient.getTeamRepository().itemManager();
                manager.addItemChangeListener(IContributorAbsence.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
                manager.addItemChangeListener(IWorkResourceDetails.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
                manager.addItemChangeListener(IContributorResourceDetails.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceListener(IResourcePlanningListener listener) {
        Assert.isNotNull((Object)listener);
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            boolean none = false;
            ListenerList listenerList = this.fListeners;
            synchronized (listenerList) {
                this.fListeners.remove((Object)listener);
                if (this.fListeners.size() == 0) {
                    none = true;
                    this.unhookItemManager();
                }
            }
            if (none) {
                this.fContributorCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unhookItemManager() {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            if (this.fListener != null) {
                IItemManager manager = this.fClient.getTeamRepository().itemManager();
                manager.removeItemChangeListener(IContributorAbsence.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
                manager.removeItemChangeListener(IWorkResourceDetails.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
                manager.removeItemChangeListener(IContributorResourceDetails.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
                this.fListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContributorCache(ResourcePlanningEntry<DTO_ContributorInfo> entry) {
        LRUElementCache<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> lRUElementCache = this.fContributorCache;
        synchronized (lRUElementCache) {
            DTO_ContributorInfo info = entry.getValue();
            Assert.isLegal((info.getWorkLocation() != null || info.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
            IContributorHandle contributor = info.getContributor();
            UUID uuid = contributor.getItemId();
            if (this.fContributorCache.containsKey(uuid)) {
                DTO_ContributorInfo predecessor = (DTO_ContributorInfo)((ResourcePlanningEntry)this.fContributorCache.get(uuid)).getValue();
                DTO_ContributorInfo successor = entry.getValue();
                this.fContributorCache.internalPut(uuid, entry);
                if (!ResourcePlanningManager.sameContributorInfos(predecessor, successor)) {
                    this.fireInfoUpdated((IAuditableHandle)contributor, new ContributorInfo(contributor, entry));
                }
            } else {
                this.fContributorCache.put(uuid, entry);
                this.fireInfoAdded((IAuditableHandle)contributor, new ContributorInfo(contributor, entry));
            }
        }
    }

    private void updateItemManager(ResourcePlanningEntry<DTO_ContributorInfo> entry) {
        IItemManager manager = this.fClient.getTeamRepository().itemManager();
        DTO_ContributorInfo info = entry.getValue();
        manager.applyItemUpdates(info.getAbsences());
        manager.applyItemUpdates(info.getWorkDetails());
        IContributorResourceDetails details = info.getContributorDetails();
        if (details != null) {
            manager.applyItemUpdates(Collections.singletonList(details));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessAreaCache(ResourcePlanningEntry<ProcessAreaInfo> entry) {
        ProcessAreaInfo info = entry.getValue();
        IProcessAreaHandle area = info.getProcessArea();
        UUID uuid = area.getItemId();
        LRUElementCache<UUID, ResourcePlanningEntry<ProcessAreaInfo>> lRUElementCache = this.fAreaCache;
        synchronized (lRUElementCache) {
            if (this.fAreaCache.containsKey(uuid)) {
                ProcessAreaInfo predecessor = (ProcessAreaInfo)((ResourcePlanningEntry)this.fAreaCache.get(uuid)).getValue();
                ProcessAreaInfo successor = entry.getValue();
                this.fAreaCache.internalPut(uuid, entry);
                if (!ResourcePlanningManager.sameProcessAreaInfos(predecessor, successor)) {
                    this.fireInfoUpdated((IAuditableHandle)area, info);
                }
            } else {
                this.fAreaCache.put(uuid, entry);
                this.fireInfoAdded((IAuditableHandle)area, info);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContributorInfo
    implements IContributorInfo {
        private static final String NO_INFO = "Resource planning info has no information about specified contributor";
        private final ItemCollection<IContributorHandle> fContributors;
        private final Map<UUID, DTO_ContributorInfo> fInfos;

        ContributorInfo(IContributorHandle contributor, ResourcePlanningEntry<DTO_ContributorInfo> cached) {
            Assert.isNotNull((Object)contributor);
            Assert.isNotNull(cached);
            this.fInfos = Collections.singletonMap(contributor.getItemId(), cached.getValue());
            this.fContributors = ItemCollections.singleton((Object)contributor);
        }

        ContributorInfo(ItemCollection<IContributorHandle> contributors, Map<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> cached) {
            Assert.isNotNull(contributors);
            Assert.isNotNull(cached);
            this.fInfos = new HashMap<UUID, DTO_ContributorInfo>(cached.size());
            for (Map.Entry<UUID, ResourcePlanningEntry<DTO_ContributorInfo>> cache : cached.entrySet()) {
                this.fInfos.put(cache.getKey(), cache.getValue().getValue());
            }
            this.fContributors = ItemCollections.unmodifiableItemCollection(contributors);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ItemCollection<IContributorAbsence> getAbsences(IContributorHandle contributor) {
            Assert.isNotNull((Object)contributor);
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                Assert.isLegal((boolean)this.fInfos.containsKey(uuid), (String)NO_INFO);
                return new ItemArrayList((Collection)this.fInfos.get(uuid).getAbsences());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IContributorResourceDetails getContributorDetails(IContributorHandle contributor) {
            Assert.isNotNull((Object)contributor);
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                Assert.isLegal((boolean)this.fInfos.containsKey(uuid), (String)NO_INFO);
                return this.fInfos.get(uuid).getContributorDetails();
            }
        }

        @Override
        public ItemCollection<IContributorHandle> getContributors() {
            return this.fContributors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getWorkAssignment(IContributorHandle contributor, IProcessAreaHandle area, IDevelopmentLineHandle line) {
            Assert.isNotNull((Object)contributor);
            Assert.isNotNull((Object)area);
            Assert.isNotNull((Object)line);
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                Assert.isLegal((boolean)this.fInfos.containsKey(uuid), (String)NO_INFO);
                DTO_ContributorInfo info = this.fInfos.get(uuid);
                List details = info.getWorkDetails();
                for (IWorkResourceDetails detail : details) {
                    if (!area.sameItemId((IItemHandle)detail.getOwner()) || !line.sameItemId((IItemHandle)detail.getDevelopmentLine())) continue;
                    return detail.getAssignment();
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ItemCollection<IWorkResourceDetails> getWorkDetails(IContributorHandle contributor) {
            Assert.isNotNull((Object)contributor);
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                Assert.isLegal((boolean)this.fInfos.containsKey(uuid), (String)NO_INFO);
                return new ItemArrayList((Collection)this.fInfos.get(uuid).getWorkDetails());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IWorkLocationDefinition getWorkLocation(IContributorHandle contributor) {
            Assert.isNotNull((Object)contributor);
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                IContributorResourceDetails details;
                Assert.isLegal((boolean)this.fInfos.containsKey(uuid), (String)NO_INFO);
                DTO_ContributorInfo info = this.fInfos.get(uuid);
                IWorkLocationDefinition definition = info.getWorkLocation();
                if (definition == null && (details = info.getContributorDetails()) != null) {
                    definition = details.getWorkLocation();
                }
                return definition;
            }
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }

    private final class ProcessAreaInfo
    implements IProcessAreaInfo {
        private final IProcessAreaHandle fArea;
        private final IWorkLocationDefinition fLocation;
        private final long fStamp = System.currentTimeMillis();

        ProcessAreaInfo(IProcessAreaHandle area, IWorkLocationDefinition location) {
            Assert.isNotNull((Object)area);
            Assert.isNotNull((Object)location);
            this.fArea = area;
            this.fLocation = location;
        }

        public IProcessAreaHandle getProcessArea() {
            return this.fArea;
        }

        public Timestamp getStamp() {
            return new Timestamp(this.fStamp);
        }

        public int getWorkDayHours() {
            return ResourcePlanningUtils.getWorkDayHours((IWorkLocationDefinition)this.fLocation);
        }

        public IWorkLocationDefinition getWorkLocation() {
            return this.fLocation;
        }

        public int getWorkWeekDays() {
            return ResourcePlanningUtils.getWorkWeekDays((IWorkLocationDefinition)this.fLocation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourcePlanningEntry<V> {
        private final Timestamp fLower;
        private final Timestamp fUpper;
        private final V fValue;

        ResourcePlanningEntry(V value) {
            Assert.isNotNull(value);
            this.fValue = value;
            this.fLower = new Timestamp(0L);
            this.fUpper = null;
        }

        ResourcePlanningEntry(V value, ResourcePlanningEntry<V> predecessor) {
            Assert.isNotNull(value);
            Assert.isNotNull(predecessor);
            this.fValue = value;
            this.fLower = predecessor.getLower();
            this.fUpper = predecessor.getUpper();
        }

        ResourcePlanningEntry(V value, Timestamp lower, Timestamp upper) {
            Assert.isNotNull(value);
            Assert.isNotNull((Object)lower);
            this.fValue = value;
            this.fLower = lower;
            this.fUpper = upper;
        }

        public Timestamp getLower() {
            return this.fLower;
        }

        public Timestamp getUpper() {
            return this.fUpper;
        }

        public V getValue() {
            return this.fValue;
        }
    }

    private final class TeamRepositoryListener
    implements ISharedItemChangeListener {
        private TeamRepositoryListener() {
        }

        public void itemsChanged(List events) {
            Assert.isNotNull((Object)events);
            for (Object event : events) {
                IWorkResourceDetails details;
                IContributorAbsence absence;
                if (!(event instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent extended = (ISharedItemChangeEvent)event;
                IItem beforeState = extended.getBeforeState();
                IItem afterState = extended.getAfterState();
                if (beforeState != null && afterState != null) {
                    if (afterState instanceof IContributorAbsence) {
                        absence = (IContributorAbsence)afterState;
                        this.updateCachedAbsence(absence, 2);
                        continue;
                    }
                    if (afterState instanceof IWorkResourceDetails) {
                        details = (IWorkResourceDetails)afterState;
                        this.updateCachedWorkDetails(details, 2);
                        continue;
                    }
                    if (!(afterState instanceof IContributorResourceDetails)) continue;
                    details = (IContributorResourceDetails)afterState;
                    this.updateCachedContributorDetails((IContributorResourceDetails)details, 2);
                    continue;
                }
                if (beforeState != null) {
                    if (beforeState instanceof IContributorAbsence) {
                        absence = (IContributorAbsence)beforeState;
                        this.updateCachedAbsence(absence, 3);
                        continue;
                    }
                    if (beforeState instanceof IWorkResourceDetails) {
                        details = (IWorkResourceDetails)beforeState;
                        this.updateCachedWorkDetails(details, 3);
                        continue;
                    }
                    if (!(beforeState instanceof IContributorResourceDetails)) continue;
                    details = (IContributorResourceDetails)beforeState;
                    this.updateCachedContributorDetails((IContributorResourceDetails)details, 3);
                    continue;
                }
                if (afterState == null) continue;
                if (afterState instanceof IContributorAbsence) {
                    absence = (IContributorAbsence)afterState;
                    this.updateCachedAbsence(absence, 1);
                    continue;
                }
                if (afterState instanceof IWorkResourceDetails) {
                    details = (IWorkResourceDetails)afterState;
                    this.updateCachedWorkDetails(details, 1);
                    continue;
                }
                if (!(afterState instanceof IContributorResourceDetails)) continue;
                details = (IContributorResourceDetails)afterState;
                this.updateCachedContributorDetails((IContributorResourceDetails)details, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCachedAbsence(IContributorAbsence absence, int type) {
            IContributorHandle contributor = absence.getContributor();
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                ResourcePlanningEntry predecessor = (ResourcePlanningEntry)ResourcePlanningManager.this.fContributorCache.get(uuid);
                if (predecessor != null) {
                    DTO_ContributorInfo info = (DTO_ContributorInfo)predecessor.getValue();
                    Assert.isLegal((info.getWorkLocation() != null || info.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
                    DTO_ContributorInfo workingCopy = DtoFactory.eINSTANCE.createDTO_ContributorInfo();
                    workingCopy.setContributor(info.getContributor());
                    workingCopy.setContributorDetails(info.getContributorDetails());
                    workingCopy.setSynchronized(info.isSynchronized());
                    workingCopy.setTimeStamp(info.getTimeStamp());
                    workingCopy.setWorkLocation(info.getWorkLocation());
                    workingCopy.getWorkDetails().addAll(info.getWorkDetails());
                    switch (type) {
                        case 3: {
                            IContributorAbsence existing = null;
                            List absences = info.getAbsences();
                            for (IContributorAbsence current : absences) {
                                if (!current.sameItemId((IItemHandle)absence)) continue;
                                existing = current;
                                break;
                            }
                            if (existing == null) break;
                            ArrayList updated = new ArrayList(absences);
                            updated.remove(existing);
                            workingCopy.getAbsences().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                            break;
                        }
                        case 1: {
                            IContributorAbsence existing = null;
                            List absences = info.getAbsences();
                            for (IContributorAbsence current : absences) {
                                if (!current.sameItemId((IItemHandle)absence)) continue;
                                existing = current;
                                break;
                            }
                            ArrayList<IContributorAbsence> updated = new ArrayList<IContributorAbsence>(absences);
                            if (existing == null) {
                                updated.add(absence);
                            } else {
                                updated.remove(existing);
                                updated.add(absence);
                            }
                            workingCopy.getAbsences().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                            break;
                        }
                        case 2: {
                            IContributorAbsence existing = null;
                            List absences = info.getAbsences();
                            for (IContributorAbsence current : absences) {
                                if (!current.sameItemId((IItemHandle)absence)) continue;
                                existing = current;
                                break;
                            }
                            if (existing == null) break;
                            ArrayList<IContributorAbsence> updated = new ArrayList<IContributorAbsence>(absences);
                            updated.remove(existing);
                            updated.add(absence);
                            workingCopy.getAbsences().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCachedContributorDetails(IContributorResourceDetails details, int type) {
            IContributorHandle contributor = details.getOwner();
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                ResourcePlanningEntry predecessor = (ResourcePlanningEntry)ResourcePlanningManager.this.fContributorCache.get(uuid);
                if (predecessor != null) {
                    DTO_ContributorInfo info = (DTO_ContributorInfo)predecessor.getValue();
                    Assert.isLegal((info.getWorkLocation() != null || info.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
                    DTO_ContributorInfo workingCopy = DtoFactory.eINSTANCE.createDTO_ContributorInfo();
                    workingCopy.setContributor(info.getContributor());
                    workingCopy.setSynchronized(info.isSynchronized());
                    workingCopy.setTimeStamp(info.getTimeStamp());
                    workingCopy.getAbsences().addAll(info.getAbsences());
                    workingCopy.getWorkDetails().addAll(info.getWorkDetails());
                    IWorkLocationDefinition location = info.getWorkLocation();
                    switch (type) {
                        case 3: {
                            if (location != null) {
                                WorkLocationDefinition locationCopy = ResourceFactory.eINSTANCE.createWorkLocationDefinition();
                                locationCopy.setLanguage(location.getLanguage());
                                locationCopy.setCountry(location.getCountry());
                                locationCopy.setVariant(location.getVariant());
                                locationCopy.setTimeZone(location.getTimeZone());
                                locationCopy.setZoneOffset(location.getZoneOffset());
                                Collection days = location.getWorkDays();
                                for (IWorkDayDefinition day : days) {
                                    WorkDayDefinition dayCopy = ResourceFactory.eINSTANCE.createWorkDayDefinition();
                                    dayCopy.setDay((WeekDay)day.getDay());
                                    dayCopy.setWorkingTime(day.getWorkingTime());
                                    dayCopy.setEndTime(day.getEndTime());
                                    locationCopy.getWorkDays().add(dayCopy);
                                }
                                workingCopy.setWorkLocation((IWorkLocationDefinition)locationCopy);
                            } else {
                                workingCopy.setWorkLocation(ResourcePlanningUtils.createWorkLocation((int)5, (int)8, (Locale)Locale.getDefault()));
                            }
                            Assert.isLegal((workingCopy.getWorkLocation() != null || workingCopy.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                            break;
                        }
                        case 1: 
                        case 2: {
                            workingCopy.setContributorDetails(details);
                            if (location != null) {
                                WorkLocationDefinition locationCopy = ResourceFactory.eINSTANCE.createWorkLocationDefinition();
                                locationCopy.setLanguage(location.getLanguage());
                                locationCopy.setCountry(location.getCountry());
                                locationCopy.setVariant(location.getVariant());
                                locationCopy.setTimeZone(location.getTimeZone());
                                locationCopy.setZoneOffset(location.getZoneOffset());
                                Collection days = location.getWorkDays();
                                for (IWorkDayDefinition day : days) {
                                    WorkDayDefinition dayCopy = ResourceFactory.eINSTANCE.createWorkDayDefinition();
                                    dayCopy.setDay((WeekDay)day.getDay());
                                    dayCopy.setWorkingTime(day.getWorkingTime());
                                    dayCopy.setEndTime(day.getEndTime());
                                    locationCopy.getWorkDays().add(dayCopy);
                                }
                                workingCopy.setWorkLocation((IWorkLocationDefinition)locationCopy);
                            }
                            Assert.isLegal((workingCopy.getWorkLocation() != null || workingCopy.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCachedWorkDetails(IWorkResourceDetails detail, int type) {
            IContributorHandle contributor = detail.getContributor();
            UUID uuid = contributor.getItemId();
            LRUElementCache lRUElementCache = ResourcePlanningManager.this.fContributorCache;
            synchronized (lRUElementCache) {
                ResourcePlanningEntry predecessor = (ResourcePlanningEntry)ResourcePlanningManager.this.fContributorCache.get(uuid);
                if (predecessor != null) {
                    DTO_ContributorInfo info = (DTO_ContributorInfo)predecessor.getValue();
                    Assert.isLegal((info.getWorkLocation() != null || info.getContributorDetails() != null ? 1 : 0) != 0, (String)"Either work location or contributor resource details must be set.");
                    DTO_ContributorInfo workingCopy = DtoFactory.eINSTANCE.createDTO_ContributorInfo();
                    workingCopy.setContributor(info.getContributor());
                    workingCopy.setContributorDetails(info.getContributorDetails());
                    workingCopy.setSynchronized(info.isSynchronized());
                    workingCopy.setTimeStamp(info.getTimeStamp());
                    workingCopy.setWorkLocation(info.getWorkLocation());
                    workingCopy.getAbsences().addAll(info.getAbsences());
                    switch (type) {
                        case 3: {
                            IWorkResourceDetails existing = null;
                            List details = info.getWorkDetails();
                            for (IWorkResourceDetails current : details) {
                                if (!current.sameItemId((IItemHandle)detail)) continue;
                                existing = current;
                                break;
                            }
                            if (existing == null) break;
                            ArrayList updated = new ArrayList(details);
                            updated.remove(existing);
                            workingCopy.getWorkDetails().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                            break;
                        }
                        case 1: {
                            IWorkResourceDetails existing = null;
                            List details = info.getWorkDetails();
                            for (IWorkResourceDetails current : details) {
                                if (!current.sameItemId((IItemHandle)detail)) continue;
                                existing = current;
                                break;
                            }
                            ArrayList<IWorkResourceDetails> updated = new ArrayList<IWorkResourceDetails>(details);
                            if (existing == null) {
                                updated.add(detail);
                            } else {
                                updated.remove(existing);
                                updated.add(detail);
                            }
                            workingCopy.getWorkDetails().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                            break;
                        }
                        case 2: {
                            IWorkResourceDetails existing = null;
                            List details = info.getWorkDetails();
                            for (IWorkResourceDetails current : details) {
                                if (!current.sameItemId((IItemHandle)detail)) continue;
                                existing = current;
                                break;
                            }
                            if (existing == null) break;
                            ArrayList<IWorkResourceDetails> updated = new ArrayList<IWorkResourceDetails>(details);
                            updated.remove(existing);
                            updated.add(detail);
                            workingCopy.getWorkDetails().addAll(updated);
                            ResourcePlanningManager.this.updateContributorCache(new ResourcePlanningEntry<DTO_ContributorInfo>(workingCopy, predecessor));
                        }
                    }
                }
            }
        }
    }
}

