/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.problems.PlanCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Problem {
    protected static final int HASH_FACTOR = 89;
    private Severity fSeverity;
    private int fId;
    private String fMessage;
    private Class<? extends PlanCheck> fChecker;

    protected Problem(Severity severity, int id, String message, Class<? extends PlanCheck> checker) {
        this.fSeverity = severity;
        this.fId = id;
        this.fMessage = message;
        this.fChecker = checker;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public Severity getSeverity() {
        return this.fSeverity;
    }

    public int getId() {
        return this.fId;
    }

    public Class<? extends PlanCheck> getChecker() {
        return this.fChecker;
    }

    public boolean isSeverity(Severity value) {
        return value.isSeverity(this.fSeverity);
    }

    protected boolean doEquals(Problem other) {
        return this.fSeverity == other.fSeverity && this.fId == other.fId;
    }

    protected int doHashCode() {
        return this.fId * 89 + this.fSeverity.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        INFO,
        WARNING,
        ERROR{

            public boolean isSeverity(Severity value) {
                return super.isSeverity(value) || FATAL_ERROR.isSeverity(value);
            }
        }
        ,
        FATAL_ERROR;


        public boolean isSeverity(Severity value) {
            return value == this;
        }
    }
}

