/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.PlanItemCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.problems.SchedulingProblem;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.Duration;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidEstimateCheck
extends PlanItemCheck {
    @Override
    public Collection<PlanItem> computeItemsToCheck(PlanItem item, IPlanElementDelta delta) {
        return Collections.singletonList(item);
    }

    @Override
    public void run(PlanProblemReport report, Collection<? extends PlanItem> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (planItems.isEmpty()) {
            return;
        }
        this.checkCanceled(monitor);
        monitor.beginTask("", planItems.size());
        for (PlanItem planItem : planItems) {
            this.checkCanceled(monitor);
            PlanItemProblemReport planItemReport = report.createReport(planItem);
            WorkItem workItem = (WorkItem)planItem.getWorkItem(false);
            if (workItem != null) {
                DurationSupport durationSupport;
                if (workItem.getDuration() == Duration.INVALID.longValue()) {
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.FATAL_ERROR, 100, Messages.InvalidEstimateCheck_INVALID_ESTIMATE, planItem, InvalidEstimateCheck.class));
                }
                if (workItem.getCorrectedEstimate() == Duration.INVALID.longValue()) {
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.FATAL_ERROR, 101, Messages.InvalidEstimateCheck_INVALID_CORRECTEDESTIMATE, planItem, InvalidEstimateCheck.class));
                }
                if (workItem.getTimeSpent() == Duration.INVALID.longValue()) {
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.FATAL_ERROR, 102, Messages.InvalidEstimateCheck_INVALID_TIMESPENT, planItem, InvalidEstimateCheck.class));
                }
                if (PlanDuration.isEncodedTimeRemaining((long)workItem.getTimeSpent())) {
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.FATAL_ERROR, 103, DurationSupport.TIME_REMAINING_EXCEEDS_ESTIMATE.getMessage(), planItem, InvalidEstimateCheck.class));
                }
                if (planItem.getDuration().getCurrentEstimate() < planItem.getDuration().getTimeSpent() && (durationSupport = planItem.getPlan().getDurationSupport()).getEstimateMode() == EstimateMode.TimeRemaining) {
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.WARNING, 103, DurationSupport.TIME_REMAINING_EXCEEDS_ESTIMATE.getMessage(), planItem, InvalidEstimateCheck.class));
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

