/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.ITeamLoadClient;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class PlanningClientPlugin
extends Plugin {
    private static final String PLUGIN_ID = "com.ibm.team.apt.client";
    private static PlanningClientPlugin fgDefault;

    public PlanningClientPlugin() {
        fgDefault = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        fgDefault = null;
        super.stop(context);
    }

    public static PlanningClientPlugin getDefault() {
        return fgDefault;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(String message, Throwable exception) {
        PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), 0, message, exception));
    }

    public static void log(IStatus status) {
        PlanningClientPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), 4, "An internal error has occurred", t));
    }

    public static ITeamRepository getTeamRepository(IItemHandle handle) {
        Object origin = handle.getOrigin();
        if (!(origin instanceof ITeamRepository)) {
            throw new IllegalArgumentException("Origin of item isn't a team repository");
        }
        return (ITeamRepository)origin;
    }

    public static boolean sameRepository(IItemHandle handle, IItemHandle other) {
        Object handleOrigin = handle.getOrigin();
        if (!(handleOrigin instanceof ITeamRepository)) {
            return false;
        }
        Object otherOrigin = other.getOrigin();
        if (!(otherOrigin instanceof ITeamRepository)) {
            return false;
        }
        return ((ITeamRepository)handleOrigin).getId().equals((Object)((ITeamRepository)otherOrigin).getId());
    }

    public static IAuditableClient getAuditableClient(IItemHandle handle) {
        return PlanningClientPlugin.getAuditableClient(PlanningClientPlugin.getTeamRepository(handle));
    }

    public static IWorkItemClient getWorkItemClient(IItemHandle handle) {
        return PlanningClientPlugin.getWorkItemClient(PlanningClientPlugin.getTeamRepository(handle));
    }

    public static IIterationPlanClient getIterationPlanClient(IItemHandle handle) {
        return PlanningClientPlugin.getIterationPlanClient(PlanningClientPlugin.getTeamRepository(handle));
    }

    public static IProcessItemService getProcessItemService(IItemHandle handle) {
        return PlanningClientPlugin.getProcessItemService(PlanningClientPlugin.getTeamRepository(handle));
    }

    public static IResourcePlanningClient getResourcePlanningClient(IItemHandle handle) {
        return PlanningClientPlugin.getResourcePlanningClient(PlanningClientPlugin.getTeamRepository(handle));
    }

    public static ResourcePlanningManager getResourcePlanningManager(IItemHandle handle) {
        return PlanningClientPlugin.getResourcePlanningClient(handle).getResourcePlanningManager();
    }

    public static IAuditableClient getAuditableClient(ITeamRepository repository) {
        return (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
    }

    public static IWorkItemClient getWorkItemClient(ITeamRepository repository) {
        return (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
    }

    public static IIterationPlanClient getIterationPlanClient(ITeamRepository repository) {
        return (IIterationPlanClient)repository.getClientLibrary(IIterationPlanClient.class);
    }

    public static IProcessItemService getProcessItemService(ITeamRepository repository) {
        return (IProcessItemService)repository.getClientLibrary(IProcessItemService.class);
    }

    public static IResourcePlanningClient getResourcePlanningClient(ITeamRepository repository) {
        return (IResourcePlanningClient)repository.getClientLibrary(IResourcePlanningClient.class);
    }

    public static ResourcePlanningManager getResourcePlanningManager(ITeamRepository repository) {
        return PlanningClientPlugin.getResourcePlanningClient(repository).getResourcePlanningManager();
    }

    public static ITeamLoadClient getTeamLoadClient(ITeamRepository repository) {
        return (ITeamLoadClient)repository.getClientLibrary(ITeamLoadClient.class);
    }

    public static boolean exists(ITeamRepository repository) {
        ITeamRepository[] teamRepositories;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (teamRepository.getRepositoryURI().equals(repository.getRepositoryURI())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

