/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.PlanAttributeDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanElementDelta
implements IPlanElementDelta {
    private static int KIND_MASK = 255;
    private static final IPlanElementDelta[] EMPTY_ELEMENT_ARRAY = new IPlanElementDelta[0];
    private static final IPlanAttributeDelta[] EMPTY_ATTRIBUTE_ARRAY = new IPlanAttributeDelta[0];
    private int fStatus;
    private final PlanElementDelta fParentDelta;
    private PlanElement fPlanElement;
    private Map<Attribute, IPlanAttributeDelta> fAttributeDeltas;
    private List<PlanElementDelta> fChildren;
    private PlanElement fMoveParent;
    private PlanElementDelta fOtherMoveDelta;

    PlanElementDelta(PlanElementDelta parentDelta, PlanElement planElement) {
        this.fParentDelta = parentDelta;
        this.fPlanElement = planElement;
        this.fStatus = 0;
    }

    public IPlanElementDelta getParentDelta() {
        return this.fParentDelta;
    }

    public PlanElement getPlanElement() {
        return this.fPlanElement;
    }

    public boolean isNoChange() {
        return (this.fStatus & KIND_MASK) == 0;
    }

    public boolean isAdded() {
        return (this.fStatus & 1) != 0;
    }

    public void setAdded() {
        this.fStatus = this.getFlags() | 1;
    }

    public boolean isRemoved() {
        return (this.fStatus & 2) != 0;
    }

    public void setRemoved() {
        this.fStatus = this.getFlags() | 2;
    }

    public boolean isDeleted() {
        return this.isRemoved() && this.getMovedTo() == null;
    }

    public boolean isChanged() {
        return (this.fStatus & 4) != 0;
    }

    public void setChanged() {
        this.fStatus = this.getFlags() | 4;
    }

    public boolean isContentChange() {
        return (this.fStatus & 0x100) != 0;
    }

    public void setContentChange() {
        this.fStatus |= 0x100;
    }

    public boolean isStructuralChange() {
        return (this.fStatus & 0x200) != 0;
    }

    public void setStructuralChange() {
        this.fStatus |= 0x200;
    }

    public boolean isMoveChange() {
        return this.fMoveParent != null;
    }

    public void setOtherMoveDelta(PlanElementDelta otherDelta) {
        this.fOtherMoveDelta = otherDelta;
    }

    public IPlanElementDelta getOtherMoveDelta() {
        return this.fOtherMoveDelta;
    }

    public void setMoveParent(PlanElement element) {
        this.fMoveParent = element;
    }

    public PlanElement getMovedFrom() {
        if (!this.isAdded()) {
            return null;
        }
        return this.fMoveParent;
    }

    public PlanElement getMovedTo() {
        if (!this.isRemoved()) {
            return null;
        }
        return this.fMoveParent;
    }

    public void addChild(PlanElementDelta delta) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<PlanElementDelta>(2);
        }
        this.fChildren.add(delta);
    }

    public PlanElementDelta getChild(PlanElement element) {
        if (this.fChildren == null) {
            return null;
        }
        for (PlanElementDelta child : this.fChildren) {
            if (child.getPlanElement() != element) continue;
            return child;
        }
        return null;
    }

    public IPlanElementDelta[] getChildren() {
        if (this.fChildren == null) {
            return EMPTY_ELEMENT_ARRAY;
        }
        return this.fChildren.toArray(new IPlanElementDelta[this.fChildren.size()]);
    }

    public IPlanElementDelta[] getChildren(int status) {
        if (this.fChildren == null) {
            return EMPTY_ELEMENT_ARRAY;
        }
        ArrayList<PlanElementDelta> result = new ArrayList<PlanElementDelta>();
        for (PlanElementDelta delta : this.fChildren) {
            if ((delta.fStatus & status) == 0) continue;
            result.add(delta);
        }
        return result.toArray(new IPlanElementDelta[result.size()]);
    }

    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public void accept(IPlanElementDeltaVisitor visitor) {
        if (visitor.visit(this) && this.fChildren != null) {
            for (PlanElementDelta delta : this.fChildren) {
                delta.accept(visitor);
            }
        }
    }

    public void addAttribute(IPlanAttributeDelta delta) {
        if (this.fAttributeDeltas == null) {
            this.fAttributeDeltas = new HashMap<Attribute, IPlanAttributeDelta>();
        } else {
            IPlanAttributeDelta oldDelta = this.fAttributeDeltas.get(delta.getAttribute());
            if (oldDelta != null) {
                delta = new PlanAttributeDelta(delta.getAttribute(), oldDelta.getOldValue(), delta.getNewValue());
            }
        }
        this.fAttributeDeltas.put(delta.getAttribute(), delta);
    }

    public boolean affectsAttribute(Attribute attribute) {
        return this.fAttributeDeltas != null && this.fAttributeDeltas.containsKey(attribute);
    }

    public IPlanAttributeDelta[] getAttributeDeltas() {
        if (this.fAttributeDeltas == null) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        Collection<IPlanAttributeDelta> values = this.fAttributeDeltas.values();
        return values.toArray(new IPlanAttributeDelta[values.size()]);
    }

    public IPlanAttributeDelta getAttributeDelta(Attribute attribute) {
        if (this.fAttributeDeltas == null) {
            return null;
        }
        return this.fAttributeDeltas.get(attribute);
    }

    private int getFlags() {
        return this.fStatus & ~KIND_MASK;
    }
}

