/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.APTCommon;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPlanProgress;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanProgress;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.util.Items;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.client.util.LRUElementCache;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.common.IterationPlanNoCategoriesException;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.WorkItemLinkCycleException;
import com.ibm.team.apt.internal.common.nucleus.query.BaseIterationPlanRecordQueryModel;
import com.ibm.team.apt.internal.common.rcp.IIterationPlanService;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgress;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgress2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgressResult2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanSaveResult;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_PersonalPlan;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_PlannedWorkItems;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedIterationPlanRecord;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedWorkItem2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_WorkItemProgress;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemQueryResults;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanClient
extends EventSource
implements IIterationPlanClient {
    private static final long LONG_EXPIRATION_INTERVAL = 0x6DDD00L;
    private LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> fEstimateCache = new LRUElementCache(20, 10);
    static final boolean TRACE_FETCH_ITERATION_PLAN;
    private IClientLibraryContext fContext;
    private IIterationPlanService fService;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.apt.client/traceFetchIterationPlan");
        TRACE_FETCH_ITERATION_PLAN = value != null && value.equalsIgnoreCase("true");
    }

    public IterationPlanClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    public ITeamRepository getTeamRepository() {
        return this.fContext.teamRepository();
    }

    public IItemManager getItemManager() {
        return this.getTeamRepository().itemManager();
    }

    public IQueryService getQueryService() {
        return (IQueryService)this.fContext.getServiceInterface(IQueryService.class);
    }

    public IterationPlanData fetchIterationPlanData(final IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        monitor.beginTask("", -1);
        DTO_ResolvedIterationPlanRecord data = (DTO_ResolvedIterationPlanRecord)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchResolvedIterationPlan2(handle);
            }
        }, monitor);
        try {
            this.acquire();
            IItemManager manager = this.fContext.teamRepository().itemManager();
            IIterationPlanRecord record = data.getIterationPlanRecord();
            ITeamArea teamArea = data.getTeamArea();
            IIteration interval = data.getIteration();
            IDevelopmentLine developmentLine = data.getDevelopmentLine();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(record);
            list.add(teamArea);
            list.add(interval);
            list.add(developmentLine);
            List acceptedItems = manager.applyItemUpdates(list);
            record = (IIterationPlanRecord)acceptedItems.get(0);
            teamArea = (ITeamArea)acceptedItems.get(1);
            interval = (IIteration)acceptedItems.get(2);
            developmentLine = (IDevelopmentLine)acceptedItems.get(3);
            IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
            ItemArrayList categories = new ItemArrayList((Collection)manager.applyItemUpdates(data.getTeamAreaCategories()));
            ItemArrayList relatedIntervals = new ItemArrayList((Collection)manager.applyItemUpdates(data.getIterations()));
            ItemArrayList wikiPages = new ItemArrayList((Collection)manager.applyItemUpdates(data.getWikiPages()), CMode.CURRENT_HANDLEONLY);
            ProgressInformation progressDescription = IterationPlanClient.transform(data.getProgressInformation());
            IterationPlanData iterationPlanData = new IterationPlanData(record, developmentLine, projectArea, teamArea, interval, (ItemList<ICategory>)categories, (ItemList<IIteration>)relatedIntervals, progressDescription, (ItemList<IWikiPage>)wikiPages, data.isCanSavePlan(), data.isCanSavePages(), data.isShowChartPage());
            return iterationPlanData;
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    @Override
    public ResolvedIterationPlan fetchIterationPlan(IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.IterationPlanClient_FETCHING_ITERATION_PLAN, 2);
            ResolvedIterationPlan resolvedIterationPlan = this.fetchIterationPlan(this.fetchIterationPlanData(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1)), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return resolvedIterationPlan;
        }
        finally {
            monitor.done();
        }
    }

    public ResolvedIterationPlan fetchIterationPlan(final IterationPlanData data, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        DTO_PlannedWorkItems items = (DTO_PlannedWorkItems)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchPlannedWorkItems((IIterationPlanRecordHandle)data.getPlanRecord());
            }
        }, monitor);
        if (data.getCategories().isEmpty()) {
            throw new IterationPlanNoCategoriesException((IIterationPlanRecordHandle)data.getPlanRecord(), data.getPlanRecord().getName());
        }
        try {
            XMLMemento auxiliaryData;
            List creators;
            List otherOwners;
            List additionalPlanMembers;
            List teamMembers;
            block21: {
                this.acquire();
                IItemManager manager = this.fContext.teamRepository().itemManager();
                teamMembers = manager.applyItemUpdates(items.getTeamMembers());
                additionalPlanMembers = manager.applyItemUpdates(items.getAdditionalPlanMembers());
                otherOwners = manager.applyItemUpdates(items.getOtherOwners());
                creators = manager.applyItemUpdates(items.getCreators());
                List resolvedWorkItems = items.getWorkItems();
                this.applyWorkItemUpdates(resolvedWorkItems, manager, monitor);
                DTO_ResolvedWorkItem2 cycle = this.checkForParentCycles(resolvedWorkItems);
                if (cycle != null) {
                    IWorkItem workItem = cycle.getWorkItem();
                    throw new WorkItemLinkCycleException((IWorkItemHandle)workItem, workItem.getId(), workItem.getHTMLSummary().getPlainText());
                }
                IContent content = data.getPlanRecord().getAuxiliaryData();
                auxiliaryData = null;
                if (content != null) {
                    InputStream input = this.fContext.teamRepository().contentManager().retrieveContentStream(content, monitor);
                    try {
                        InputStreamReader reader = new InputStreamReader(input, content.getCharacterEncoding());
                        auxiliaryData = XMLMemento.createReadRoot((Reader)reader);
                    }
                    catch (UnsupportedEncodingException e) {
                        PlanningClientPlugin.log(e);
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        break block21;
                    }
                    catch (CoreException e) {
                        try {
                            PlanningClientPlugin.log(e);
                        }
                        catch (Throwable throwable) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        break block21;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    auxiliaryData = XMLMemento.createWriteRoot((String)"auxiliaryData");
                }
            }
            DurationSupport durationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)data.getProjectArea(), monitor);
            ResolvedIterationPlan resolvedIterationPlan = new ResolvedIterationPlan(data.getPlanRecord(), data.getDevelopmentLine(), data.getTeamArea(), data.getCategories(), data.getIteration(), items.getWorkItems(), data.getRelatedIterations(), teamMembers, additionalPlanMembers, otherOwners, creators, new HashSet<String>(items.getTopLevelWorkItemTypes()), auxiliaryData, durationSupport, data.canSavePlan());
            return resolvedIterationPlan;
        }
        finally {
            this.release();
        }
    }

    private void applyWorkItemUpdates(List<DTO_ResolvedWorkItem2> resolvedWorkItems, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        for (DTO_ResolvedWorkItem2 resolvedWorkItem : resolvedWorkItems) {
            IWorkItem updated = (IWorkItem)manager.applyItemUpdates(Collections.singletonList(resolvedWorkItem.getWorkItem())).get(0);
            if (updated != null) {
                resolvedWorkItem.setWorkItem(updated);
                continue;
            }
            IWorkItem fetchedWorkItem = resolvedWorkItem.getWorkItem();
            Set<String> fetchedProperties = Items.setProperties((IItem)fetchedWorkItem);
            IItem currentSharedItem = manager.getSharedItemIfKnown((IItemHandle)fetchedWorkItem);
            Set<String> cachedProperties = Items.setProperties(currentSharedItem);
            HashSet<String> merged = new HashSet<String>(fetchedProperties);
            merged.addAll(cachedProperties);
            resolvedWorkItem.setWorkItem((IWorkItem)manager.fetchPartialItem((IItemHandle)fetchedWorkItem, 1, merged, monitor));
        }
    }

    private DTO_ResolvedWorkItem2 checkForParentCycles(List<DTO_ResolvedWorkItem2> items) {
        ItemHashMap map = new ItemHashMap();
        for (DTO_ResolvedWorkItem2 dto_workItem : items) {
            map.put((IItemHandle)dto_workItem.getWorkItem(), (Object)dto_workItem);
        }
        for (DTO_ResolvedWorkItem2 item : items) {
            if (!this.checkForParentCycles((ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2>)map, item)) continue;
            return item;
        }
        return null;
    }

    private boolean checkForParentCycles(ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> items, DTO_ResolvedWorkItem2 item) {
        if (item.getParent() == null) {
            return false;
        }
        HashSet<DTO_ResolvedWorkItem2> visited = new HashSet<DTO_ResolvedWorkItem2>();
        visited.add(item);
        Object parent = (DTO_ResolvedWorkItem2)items.get((IItemHandle)item.getParent());
        while (parent != null) {
            if (visited.contains(parent)) {
                return true;
            }
            IWorkItemHandle parentHandle = parent.getParent();
            parent = parentHandle == null ? null : (DTO_ResolvedWorkItem2)items.get((IItemHandle)parentHandle);
        }
        return false;
    }

    @Override
    public ProgressInformation fetchPlanProgress2(IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchPlanProgress2(Arrays.asList(handle), monitor).get(0);
    }

    @Override
    public List<ProgressInformation> fetchPlanProgress2(final List<IIterationPlanRecordHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull(handles);
        Assert.isTrue((!handles.isEmpty() ? 1 : 0) != 0);
        List result = (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List<ProgressInformation>>(){

            public List<ProgressInformation> run(IProgressMonitor monitor) throws TeamRepositoryException {
                int size = handles.size();
                if (size == 1) {
                    DTO_IterationPlanProgressResult2 planProgress2 = IterationPlanClient.this.getService().fetchPlanProgress2((IIterationPlanRecordHandle)handles.get(0), new IIterationPlanRecordHandle[0]);
                    return Arrays.asList(IterationPlanClient.transform((DTO_IterationPlanProgress2)planProgress2.getPlanProgress().iterator().next()));
                }
                DTO_IterationPlanProgressResult2 planProgress2 = IterationPlanClient.this.getService().fetchPlanProgress2((IIterationPlanRecordHandle)handles.get(0), handles.subList(1, size).toArray(new IIterationPlanRecordHandle[size - 1]));
                ArrayList<ProgressInformation> result = new ArrayList<ProgressInformation>(handles.size());
                ListIterator iter = planProgress2.getPlanProgress().listIterator();
                while (iter.hasNext()) {
                    result.add(IterationPlanClient.transform((DTO_IterationPlanProgress2)iter.next()));
                }
                return result;
            }
        }, monitor);
        return result;
    }

    private static ProgressInformation transform(DTO_IterationPlanProgress2 result) {
        return new ProgressInformation(result.getWorkHoursDone(), result.getWorkHoursLeft(), result.getRealTimeDone(), result.getRealTimeLeft(), result.getOpenCount(), result.getCloseCount(), result.getEstimatedCount());
    }

    @Override
    @Deprecated
    public IPlanProgress fetchPlanProgress(IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        long start = System.currentTimeMillis();
        if (TRACE_FETCH_ITERATION_PLAN) {
            System.out.println("\n\nEntering IterationPlanClient#fetchPlanProgress");
            System.out.println("    >> entering client method: " + start);
        }
        DTO_IterationPlanProgress data = this.getService().fetchPlanProgress(handle);
        if (TRACE_FETCH_ITERATION_PLAN) {
            long end = System.currentTimeMillis();
            System.out.println("Returning from server call: " + end);
            System.out.println("    >> calling service: " + (end - start));
        }
        PlanProgress result = new PlanProgress(data.getOpenItems(), data.getExpectedClosedItems(), data.getTotalItems(), data.isIterationSpecified());
        return result;
    }

    public DTO_WorkItemProgress fetchWorkItemProgress(final IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        return (DTO_WorkItemProgress)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchWorkItemProgress(handle);
            }
        }, monitor);
    }

    public DTO_ResolvedWorkItem2 fetchResolvedWorkItem(final IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        DTO_ResolvedWorkItem2 result = (DTO_ResolvedWorkItem2)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchResolvedWorkItem(handle);
            }
        }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IItemManager itemManager = this.getTeamRepository().itemManager();
        result.setWorkItem((IWorkItem)itemManager.applyItemUpdatesOrRefresh(Collections.singletonList(result.getWorkItem()), (IProgressMonitor)new SubProgressMonitor(monitor, 1)).get(0));
        return result;
    }

    @Override
    public ResolvedPersonalPlan fetchPersonalPlan(IProjectAreaHandle projectAreaHandle, IContributorHandle contributorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.IterationPlanClient_LOADING_MY_WORK_DATA, 4);
        long start = System.currentTimeMillis();
        if (TRACE_FETCH_ITERATION_PLAN) {
            System.out.println("\n\nEntering IterationPlanClient#fetchPersonalPlan");
            System.out.println("    >> entering client method: " + start);
        }
        DTO_PersonalPlan data = this.getService().fetchPersonalPlan(projectAreaHandle, contributorHandle);
        monitor.worked(3);
        try {
            ResolvedPersonalPlan result;
            start = System.currentTimeMillis();
            this.acquire();
            IItemManager manager = this.fContext.teamRepository().itemManager();
            IContributor owner = (IContributor)manager.applyItemUpdates(Collections.singletonList(data.getOwner())).get(0);
            boolean isMemberOfProjectArea = data.getProjectArea() != null;
            List teamAreas = manager.applyItemUpdates(data.getTeamAreas());
            List developmentLines = manager.applyItemUpdates(data.getDevelopmentLines());
            List categories = manager.applyItemUpdates(data.getCategories());
            List intervals = manager.applyItemUpdates(data.getIterations());
            List relatedPlans = manager.applyItemUpdates(data.getRelatedPlans());
            List creators = manager.applyItemUpdates(data.getCreators());
            List currentWorkItems = manager.applyItemUpdatesOrRefresh(data.getCurrentWorkItems(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List otherWorkItems = data.getOtherWorkItemHandles();
            DurationSupport support = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)projectAreaHandle, monitor);
            ResolvedPersonalPlan resolvedPersonalPlan = result = new ResolvedPersonalPlan(projectAreaHandle, owner, isMemberOfProjectArea, teamAreas, developmentLines, categories, intervals, currentWorkItems, otherWorkItems, creators, relatedPlans, support);
            return resolvedPersonalPlan;
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    public ItemSet<IWorkItem> refreshWorkItems(ItemSet<IWorkItemHandle> changedItems, IProgressMonitor monitor) throws TeamRepositoryException {
        long start = System.currentTimeMillis();
        if (TRACE_FETCH_ITERATION_PLAN) {
            System.out.println("\n\nEntering IterationPlanClient#refreshWorkItems");
            System.out.println("    >> entering client method: " + start);
        }
        try {
            start = System.currentTimeMillis();
            this.acquire();
            IItemManager itemManager = this.fContext.teamRepository().itemManager();
            List<IWorkItemHandle> handleList = Arrays.asList((IWorkItemHandle[])changedItems.toArray((Object[])new IWorkItemHandle[changedItems.size()]));
            ItemProfile itemProfile = APTCommon.getPlanItemWorkItemProfile();
            List fetchedItems = itemManager.fetchPartialItems(handleList, 1, itemProfile.getProperties(), monitor);
            if (TRACE_FETCH_ITERATION_PLAN) {
                System.out.println("    >> fetching items: " + (System.currentTimeMillis() - start));
            }
            ItemHashSet result = new ItemHashSet();
            for (Object item : fetchedItems) {
                result.add((Object)((IWorkItem)item));
            }
            ItemHashSet itemHashSet = result;
            return itemHashSet;
        }
        finally {
            this.release();
        }
    }

    private IIterationPlanService getService() {
        if (this.fService != null) {
            return this.fService;
        }
        this.fService = (IIterationPlanService)this.fContext.getServiceInterface(IIterationPlanService.class);
        return this.fService;
    }

    public IterationPlanWizardContext completeAndValidateContext(IterationPlanWizardContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        List teamAreas;
        IIteration iterationHandle;
        IAuditableCommon auditableCommon;
        IDevelopmentLine line;
        if (context.getIterationPlanHandle() != null) {
            IIterationPlanRecord plan = (IIterationPlanRecord)this.fetchItem((IItemHandle)context.getIterationPlanHandle(), monitor, IIterationPlanRecord.TEAM_AREA_PROPERTY, IIterationPlanRecord.ITERATION_PROPERTY);
            context.setTeamArea(plan.getTeamArea());
            context.setIteration(plan.getIteration());
            context.setSelectedProjectArea(null);
            context.setDevelopmentLineHandle(null);
        }
        if (context.getSelectedProjectArea() == null && context.getTeamArea() != null) {
            ITeamArea teamArea = (ITeamArea)this.fetchItem((IItemHandle)context.getTeamArea(), monitor, new String[0]);
            context.setSelectedProjectArea(teamArea.getProjectArea());
        }
        if (context.getSelectedProjectArea() == null && context.getIteration() != null) {
            IIteration iteration = (IIteration)this.fetchItem((IItemHandle)context.getIteration(), monitor, ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine"));
            line = (IDevelopmentLine)this.fetchItem((IItemHandle)iteration.getDevelopmentLine(), monitor, ProcessCommon.getPropertyName(IDevelopmentLine.class, (String)"projectArea"));
            context.setSelectedProjectArea(line.getProjectArea());
            context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
        }
        if (context.getSelectedProjectArea() == null && context.getDevelopmentLineHandle() != null) {
            IDevelopmentLine line2 = (IDevelopmentLine)this.fetchItem((IItemHandle)context.getDevelopmentLineHandle(), monitor, ProcessCommon.getPropertyName(IDevelopmentLine.class, (String)"projectArea"));
            context.setSelectedProjectArea(line2.getProjectArea());
            context.setIteration((IIterationHandle)IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line2, monitor));
        }
        if (context.getSelectedProjectArea() == null) {
            context.setSelectedProjectArea(context.getProjectAreas().get(0));
        }
        if (context.getTeamArea() == null && context.getIteration() != null) {
            context.setTeamArea(this.inferTeamAreaByIteration(context.getIteration(), context.getSelectedProjectArea(), monitor));
        }
        if (context.getTeamArea() == null && (line = (auditableCommon = (IAuditableCommon)this.getTeamRepository().getClientLibrary(IAuditableClient.class)).findDefaultDevelopmentLine(context.getSelectedProjectArea(), monitor)) != null && (iterationHandle = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor)) != null) {
            ITeamAreaHandle teamArea = this.inferTeamAreaByIteration((IIterationHandle)iterationHandle, context.getSelectedProjectArea(), monitor);
            context.setTeamArea(teamArea);
            if (teamArea != null) {
                context.setIteration((IIterationHandle)iterationHandle);
            }
        }
        if (context.getTeamArea() == null && !(teamAreas = ((IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)context.getSelectedProjectArea(), 0, monitor)).getTeamAreas()).isEmpty()) {
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreas.get(0);
            context.setTeamArea(teamAreaHandle);
            context.setIteration(this.inferIterationByTeamArea(teamAreaHandle, monitor));
        }
        if (context.getTeamArea() != null && context.getIteration() == null) {
            context.setIteration(this.inferIterationByTeamArea(context.getTeamArea(), monitor));
        }
        Assert.isNotNull((Object)context.getSelectedProjectArea());
        if (context.getDevelopmentLineHandle() == null && context.getTeamArea() != null) {
            context.setDevelopmentLineHandle((IDevelopmentLineHandle)PlanningClientPlugin.getAuditableClient((IItemHandle)context.getTeamArea()).getDevelopmentLine(context.getTeamArea(), monitor));
        }
        return context;
    }

    public IIterationHandle inferIterationByTeamArea(ITeamAreaHandle teamAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService pis = PlanningClientPlugin.getProcessItemService((IItemHandle)teamAreaHandle);
        ITeamArea teamArea = (ITeamArea)this.fetchItem((IItemHandle)teamAreaHandle, monitor, new String[0]);
        IDevelopmentLine line = pis.getDevelopmentLine(teamArea, monitor);
        return IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor);
    }

    private ITeamAreaHandle inferTeamAreaByIteration(IIterationHandle iteration, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ITeamArea> teamAreas;
        ITeamAreaHandle handle;
        IProjectArea projectArea = (IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
        if (this.getTeamRepository().loggedInContributor() != null && (handle = this.selectTeamAreaByInterval(iteration, projectArea, teamAreas = Arrays.asList(this.getAssociatedTeamAreas(this.getTeamRepository().loggedInContributor(), projectArea, monitor)), monitor)) != null) {
            return handle;
        }
        teamAreas = projectArea.getTeamAreas();
        return this.selectTeamAreaByInterval(iteration, projectArea, teamAreas, monitor);
    }

    private ITeamAreaHandle selectTeamAreaByInterval(IIterationHandle iteration, IProjectArea projectArea, List<? extends ITeamAreaHandle> teamAreaHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        for (ITeamAreaHandle iTeamAreaHandle : teamAreaHandles) {
            IDevelopmentLineHandle lineHandle = projectArea.getTeamAreaHierarchy().getDevelopmentLine(iTeamAreaHandle);
            IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)lineHandle, monitor, new String[0]);
            ItemArrayList iterations = new ItemArrayList(IterationClient.getAllIterations((IDevelopmentLineHandle)line, IterationClient.ArchiveMode.IN_USE, monitor), CMode.CURRENT_HANDLEONLY);
            if (!iterations.contains((Object)iteration)) continue;
            return iTeamAreaHandle;
        }
        return null;
    }

    private <T> T fetchItem(IItemHandle handle, IProgressMonitor monitor, String ... properties) throws TeamRepositoryException {
        if (properties.length == 0) {
            return (T)this.getItemManager().fetchCompleteItem(handle, 0, monitor);
        }
        return (T)this.getItemManager().fetchPartialItem(handle, 0, (Collection)Arrays.asList(properties), monitor);
    }

    public NewIterationPlanData fetchNewIterationPlanData(IterationPlanWizardContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchNewIterationPlanData(context.getSelectedProjectArea(), context.getTeamArea(), monitor);
    }

    public NewIterationPlanData fetchEditIterationPlanData(IProjectAreaHandle projectAreaHandle, ITeamAreaHandle defaultTeamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchNewIterationPlanData(projectAreaHandle, defaultTeamArea, monitor);
    }

    private NewIterationPlanData fetchNewIterationPlanData(IProjectAreaHandle projectAreaHandle, ITeamAreaHandle teamAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)projectAreaHandle);
        Assert.isNotNull((Object)teamAreaHandle);
        try {
            monitor.beginTask(Messages.IterationPlanClient_FETCHING_ITERATION_PLAN_DATA, 7);
            ITeamRepository teamRepository = this.getTeamRepository();
            IProjectArea area = (IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ITeamAreaHierarchy hierarchy = area.getTeamAreaHierarchy();
            ArrayList<ITeamAreaHandle> pathHandles = new ArrayList<ITeamAreaHandle>();
            pathHandles.add(teamAreaHandle);
            ITeamAreaHandle current = teamAreaHandle;
            while ((current = hierarchy.getParent(current)) != null) {
                pathHandles.add(current);
            }
            Collections.reverse(pathHandles);
            List teamAreaPath = teamRepository.itemManager().fetchCompleteItems(pathHandles, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient(this.getTeamRepository());
            IDevelopmentLine line = auditableClient.getDevelopmentLine(teamAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IIteration iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            boolean canSave = this.checkPermission((IProcessAreaHandle)teamAreaHandle, "com.ibm.team.apt.server.saveIterationPlan", "modify/plan", monitor);
            NewIterationPlanData newIterationPlanData = new NewIterationPlanData(area, line, teamAreaPath, iteration, canSave);
            return newIterationPlanData;
        }
        finally {
            monitor.done();
        }
    }

    public ITeamArea[] getAssociatedTeamAreas(IContributor contributor, IProjectArea area, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessService processService = (IProcessService)this.fContext.getServiceInterface(IProcessService.class);
        return processService.findTeamAreas(contributor, (IProjectAreaHandle)area, new String[]{IItem.ITEM_ID_PROPERTY, IItem.MODIFIED_PROPERTY, IItem.MODIFIED_BY_PROPERTY});
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.create(plan, null, monitor);
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, XMLString planNotes, IProgressMonitor monitor) throws TeamRepositoryException {
        IWikiPage overviewPage = (IWikiPage)IWikiPage.ITEM_TYPE.createItem();
        overviewPage.setName("");
        overviewPage.setWikiID("overview");
        overviewPage.setCreator((IContributorHandle)this.getTeamRepository().loggedInContributor());
        overviewPage.setOwner((IItemHandle)plan);
        String xmlText = planNotes != null ? planNotes.getXMLText() : "";
        overviewPage.setContent(this.getTeamRepository().contentManager().storeContent("text/plain", xmlText, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        return this.save(monitor, plan.getTeamArea(), plan, overviewPage);
    }

    public IterationPlanSaveResult save(IIterationPlanRecord plan, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.save(monitor, plan.getTeamArea(), plan, new IWikiPage[0]);
    }

    private IterationPlanSaveResult save(IProgressMonitor monitor, final ITeamAreaHandle teamArea, final IIterationPlanRecord plan, final IWikiPage ... pages) throws TeamRepositoryException {
        return (IterationPlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IterationPlanSaveResult>(){

            public IterationPlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                final DTO_IterationPlanSaveResult[] result = new DTO_IterationPlanSaveResult[1];
                IProcessClientService process = (IProcessClientService)IterationPlanClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                IOperationReport report = process.execute(new ProcessRunnable("com.ibm.team.apt.server.saveIterationPlan"){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        result[0] = IterationPlanClient.this.getService().save(teamArea, plan, pages);
                        return null;
                    }
                }, Messages.IterationPlanClient_SAVE_ITERATION_PLAN, monitor);
                IIterationPlanRecord savedPlan = null;
                if (plan != null) {
                    savedPlan = (IIterationPlanRecord)IterationPlanClient.this.getTeamRepository().itemManager().applyItemUpdates(Arrays.asList(result[0].getIterationPlanRecord())).get(0);
                }
                return new IterationPlanSaveResult(savedPlan, result[0].getWikiPages(), result[0].getExceptionCause(), (IDetailedStatus)new DetailedStatus(Status.OK_STATUS, report));
            }
        }, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public IterationPlanSaveResult save(boolean canSavePlan, IIterationPlanRecord record, IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy[] workingCopies, XMLMemento auxiliaryData, IWikiPageSafeRunnable[] resolvedPages, IProgressMonitor monitor) throws MultiStaleDataException, TeamRepositoryException, IOException {
        saveWorkingCopies = workingCopies.length != 0;
        saveAuxiliaryData = auxiliaryData != null;
        savePages = resolvedPages != null && resolvedPages.length != 0;
        monitor.beginTask("", (saveWorkingCopies != false ? 1 : 0) + (saveAuxiliaryData != false ? 2 : 0));
        status = new DetailedStatus(0, PlanningClientPlugin.getPluginId(), 0, "", null);
        if (saveWorkingCopies) {
            status = manager.save(workingCopies, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (saveAuxiliaryData || savePages) {
            block10: {
                workingCopy = null;
                if (saveAuxiliaryData) {
                    workingCopy = (IIterationPlanRecord)record.getWorkingCopy();
                    writer = new StringWriter();
                    auxiliaryData.save((Writer)writer);
                    content = this.getTeamRepository().contentManager().storeContent("text/plain", writer.toString(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    workingCopy.setAuxiliaryData(content);
                }
                wikiPages = new ArrayList<IWikiPage>(resolvedPages.length);
                var17_15 = resolvedPages;
                var16_17 = resolvedPages.length;
                var15_20 = 0;
                while (var15_20 < var16_17) {
                    page = var17_15[var15_20];
                    wikiPages.add(page.preSave());
                    ++var15_20;
                }
                result = null;
                try {
                    result = this.save(monitor, record.getTeamArea(), canSavePlan != false && workingCopy != null ? workingCopy : null, wikiPages.toArray(new IWikiPage[resolvedPages.length]));
                    monitor.worked(1);
                    iter = result.getWikiPages().iterator();
                    var19_23 = resolvedPages;
                    var18_25 = resolvedPages.length;
                    var17_16 = 0;
                    while (var17_16 < var18_25) {
                        resolvedPage = var19_23[var17_16];
                        resolvedPage.postSave(iter.next());
                        ++var17_16;
                    }
                    if (!canSavePlan || workingCopy == null) {
                        result = new IterationPlanSaveResult(workingCopy != null ? workingCopy : record, result.getWikiPages(), result.getExceptionCause(), result.getStatus());
                    }
                    return result;
                }
                catch (TeamRepositoryException e) {
                    if (e.getData() == null || !(e.getData() instanceof IItemHandle)) break block10;
                    handle = (IItemHandle)e.getData();
                    var20_27 = resolvedPages;
                    var19_24 = resolvedPages.length;
                    var18_26 = 0;
                    ** while (var18_26 < var19_24)
                }
lbl-1000:
                // 1 sources

                {
                    page = var20_27[var18_26];
                    if (page.getWikiPage().getItemId().equals((Object)handle.getItemId())) {
                        page.handleException(e);
                    }
                    ++var18_26;
                    continue;
                }
            }
            throw e;
        }
        return new IterationPlanSaveResult(record, null, null, (IDetailedStatus)status);
    }

    public PlanSaveResult save(final IWorkItemWorkingCopyManager manager, final WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws MultiStaleDataException, TeamRepositoryException {
        return (PlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<PlanSaveResult>(){

            public PlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", workingCopies.length);
                DetailedStatus status = new DetailedStatus(0, PlanningClientPlugin.getPluginId(), 0, "", null);
                status = manager.save(workingCopies, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return new PlanSaveResult((IDetailedStatus)status);
            }
        }, monitor);
    }

    public IOperationReport delete(final IIterationPlanRecordHandle plan) throws TeamRepositoryException {
        IProcessClientService process = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        IOperationReport report = process.execute(new ProcessRunnable("com.ibm.team.apt.server.deleteIterationPlan"){

            public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanClient.this.getService().delete(plan);
                IterationPlanClient.this.getItemManager().applyItemDeletes(Arrays.asList(plan));
                return null;
            }
        }, Messages.IterationPlanClient_DELETE_ITERATION_PLAN, null);
        return report;
    }

    public IterationPlanSaveResult renameAttachedPage(final IIterationPlanRecord plan, final IWikiPageSafeRunnable page, final String name, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        return (IterationPlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IterationPlanSaveResult>(){

            public IterationPlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanSaveResult result;
                page.getWikiPage().setName(name);
                try {
                    result = IterationPlanClient.this.save(false, plan, null, new WorkItemWorkingCopy[0], null, new IWikiPageSafeRunnable[]{page}, monitor);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                return result;
            }
        }, monitor);
    }

    public void deleteAttachedPage(final IWikiPageHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Void>(){

            public Void run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanClient.this.getService().deleteAttachedPage(handle);
                return null;
            }
        }, monitor);
    }

    public boolean checkPermission(final IProcessAreaHandle processAreaHandle, final String operationId, final String action, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().checkPermission(processAreaHandle, operationId, action);
            }
        }, monitor);
    }

    public IItemQueryPage fetchIterationPlanRecords(List<? extends ITeamAreaHandle> teamAreas, IIterationHandle interval, int pageSize) throws TeamRepositoryException {
        Assert.isTrue((!teamAreas.isEmpty() ? 1 : 0) != 0);
        int numberOfTeamAreas = teamAreas.size();
        Object[] iprParams = new Object[numberOfTeamAreas + 1];
        BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel iprModel = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
        IItemQuery iprQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)iprModel);
        IPredicate filter = iprModel.iteration()._eq(iprQuery.newItemHandleArg());
        iprParams[0] = interval;
        IItemHandleInputArg[] teamAreaArgHandles = new IItemHandleInputArg[numberOfTeamAreas];
        int i = 0;
        while (i < numberOfTeamAreas) {
            teamAreaArgHandles[i] = iprQuery.newItemHandleArg();
            ITeamAreaHandle teamAreaHandle = teamAreas.get(i);
            if (teamAreaHandle instanceof ITeamArea) {
                teamAreaHandle = (ITeamAreaHandle)((ITeamArea)teamAreaHandle).getItemHandle();
            }
            iprParams[i + 1] = teamAreaHandle;
            ++i;
        }
        filter = filter._and(iprModel.teamArea()._in(teamAreaArgHandles));
        iprQuery.filter(filter);
        iprQuery.orderByAsc((IField)iprModel.name());
        return this.getQueryService().queryItems(iprQuery, iprParams, pageSize);
    }

    public IItemQueryPage fetchNextQueryPage(IItemQueryPage lastPage, int pageSize) throws TeamRepositoryException {
        return (IItemQueryPage)this.getQueryService().fetchPage(lastPage.getToken(), lastPage.getNextStartPosition(), pageSize);
    }

    public IIterationPlanRecord[] fetchAllIterationPlans(ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.acquire();
            BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel iprModel = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
            IItemQuery iprQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)iprModel);
            ItemQueryResults resultIterator = new ItemQueryResults(this.getQueryService(), iprQuery, new Object[0]);
            List handles = resultIterator.getAllItems();
            List result = this.getTeamRepository().itemManager().fetchPartialItems(handles, 0, profile.getProperties(), monitor);
            IIterationPlanRecord[] iIterationPlanRecordArray = result.toArray(new IIterationPlanRecord[result.size()]);
            return iIterationPlanRecordArray;
        }
        finally {
            this.release();
        }
    }

    @Override
    public List<String> fetchTopLevelWorkItemTypes(final IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)processAreaHandle);
        IClientLibraryContext.IServiceRunnable<List<String>> runnable = new IClientLibraryContext.IServiceRunnable<List<String>>(){

            public List<String> run(IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList<String> result = new ArrayList<String>(5);
                IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)processAreaHandle).getProcess(processAreaHandle, monitor);
                IProcessConfigurationData data = process.findProcessConfiguration("com.ibm.team.apt.configuration.topLevelPlanWorkItemBinding", (IProgressMonitor)new NullProgressMonitor());
                if (data != null) {
                    IProcessConfigurationElement[] bindings;
                    IProcessConfigurationElement[] iProcessConfigurationElementArray = bindings = data.getElements();
                    int n = bindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessConfigurationElement binding = iProcessConfigurationElementArray[n2];
                        result.add(binding.getAttribute("workitemType"));
                        ++n2;
                    }
                }
                return Collections.unmodifiableList(result);
            }
        };
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EstimateMode fetchEstimationMode(final IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)handle);
        IClientLibraryContext.IServiceRunnable<EstimateMode> runnable = new IClientLibraryContext.IServiceRunnable<EstimateMode>(){

            public EstimateMode run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessConfigurationElement element;
                String value;
                IProcessConfigurationElement[] elements;
                IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)handle).getProcess(handle, monitor);
                IProcessConfigurationData data = process.findProcessConfiguration("com.ibm.team.apt.configuration.workItemProgressMode", (IProgressMonitor)new NullProgressMonitor());
                if (data != null && (elements = data.getElements()).length == 1 && (value = (element = elements[0]).getAttribute("name")) != null) {
                    try {
                        return Enum.valueOf(EstimateMode.class, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return EstimateMode.TimeSpent;
                    }
                }
                return EstimateMode.TimeSpent;
            }
        };
        EstimateMode result = (EstimateMode)((Object)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor));
        LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> lRUElementCache = this.fEstimateCache;
        synchronized (lRUElementCache) {
            IItemHandle key = IterationPlanClient.key(handle);
            if (key.getStateId() == null) {
                IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                key = manager.fetchPartialItem((IItemHandle)handle, 0, (Collection)Collections.emptyList(), monitor);
            }
            this.fEstimateCache.put(key, new CacheEntry<EstimateMode>(System.currentTimeMillis(), key.getStateId(), result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimateMode findCachedEstimationMode(IProcessAreaHandle handle) {
        Assert.isNotNull((Object)handle);
        IItemHandle key = IterationPlanClient.key(handle);
        LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> lRUElementCache = this.fEstimateCache;
        synchronized (lRUElementCache) {
            CacheEntry entry = (CacheEntry)this.fEstimateCache.get(key);
            if (entry != null) {
                if (entry.isValid(System.currentTimeMillis(), key.getStateId())) {
                    return (EstimateMode)((Object)entry.getElement());
                }
                this.fEstimateCache.remove(key);
            }
        }
        return null;
    }

    private static final IItemHandle key(IProcessAreaHandle handle) {
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
        IItem item = manager.getSharedItemIfKnown((IItemHandle)handle);
        if (item != null) {
            return item.getStateHandle();
        }
        return handle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheEntry<E> {
        private final long fTimestamp;
        private final E fElement;
        private final UUID fStateId;

        public CacheEntry(long timestamp, UUID stateId, E element) {
            this.fTimestamp = timestamp;
            this.fStateId = stateId;
            this.fElement = element;
        }

        public E getElement() {
            return this.fElement;
        }

        public long getTimestamp() {
            return this.fTimestamp;
        }

        public boolean isValid(long timeStamp, UUID stateId) {
            return timeStamp - this.getTimestamp() <= 0x6DDD00L && this.fStateId.equals((Object)stateId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FetchMode {
        PAST,
        CURRENT,
        FUTURE;

    }
}

