/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.icu.util.Calendar;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.SequenceValue;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.testing.IItemSequenceManagerTestingAccessor;
import com.ibm.team.apt.internal.client.util.Literals;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.WorktimeScheduler;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkingCopyRunnable;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.IWorkItemActivationManager;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemSequenceManager {
    private static final Set<BookedTimeType> OUTOFOFFICE = Collections.singleton(BookedTimeType.OUT_OF_OFFICE);
    public static final BookedTimeType FIX_SCHEDULED_ITEM = new BookedTimeType("fixWorkItem");
    private ResolvedPlan fPlan;
    private List<PlanItem> fResolvedItems = new ArrayList<PlanItem>();
    private List<PlanItem> fUnresolvedItems = new ArrayList<PlanItem>();
    private Set<PlanItem> fUnschduledItems = new HashSet<PlanItem>();
    private Map<PlanItem, BookedPlanItemTime> fFixScheduledItems = new HashMap<PlanItem, BookedPlanItemTime>();
    private ItemSet<IIteration> fPlannedIterations;
    private Map<PlanItem, Timespan> fSchedulingCache = new HashMap<PlanItem, Timespan>();
    private final ReadWriteLock fManagerLock = new ReentrantReadWriteLock();
    protected final Lock fReadLock = this.fManagerLock.readLock();
    protected final Lock fWriteLock = this.fManagerLock.writeLock();
    private WorktimeScheduler fWorktimeScheduler;
    private IWorkItemActivationManager fWorkItemActivationManager;
    private Comparator<PlanItem> fUnresolvedSequenceComparator = new Comparator<PlanItem>(){

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            return o1.getSequenceValue().compareTo(o2.getSequenceValue());
        }
    };

    public ItemSequenceManager(ResolvedPlan plan) {
        this.fPlan = plan;
        this.fWorkItemActivationManager = ClientModel.getWorkItemActivationManager();
        this.fPlannedIterations = plan.getPlannedIterations();
    }

    public void initialize(final IContributorInfo info, final IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)info);
        IWorkItemHandle activeWorkItem = this.fWorkItemActivationManager.getActiveWorkItem();
        final PlanItem activePlanItem = activeWorkItem != null ? this.fPlan.getPlanItem(activeWorkItem) : null;
        this.runWriteLocked(activePlanItem, new Runnable(){

            public void run() {
                monitor.beginTask("", 1);
                try {
                    ItemSequenceManager.this.updateWorkTime(info);
                    for (PlanItem planItem : ItemSequenceManager.this.fetchPlanItems()) {
                        if (!ItemSequenceManager.this.isItemIncluded(planItem)) continue;
                        if (planItem.isResolved()) {
                            ItemSequenceManager.this.fResolvedItems.add(planItem);
                            continue;
                        }
                        if (planItem.getFixedStartDate() != null) {
                            ItemSequenceManager.this.doAddFixScheduledItem(planItem);
                            continue;
                        }
                        if (planItem.getSequenceValue().isScheduled()) {
                            ItemSequenceManager.this.fUnresolvedItems.add(planItem);
                            continue;
                        }
                        ItemSequenceManager.this.fUnschduledItems.add(planItem);
                    }
                    Collections.sort(ItemSequenceManager.this.fUnresolvedItems, ItemSequenceManager.this.fUnresolvedSequenceComparator);
                    ItemSequenceManager.this.updateSchedulingCache(null);
                    if (activePlanItem != null && ItemSequenceManager.this.isItemIncluded(activePlanItem) && ItemSequenceManager.this.fUnresolvedItems.indexOf(activePlanItem) > 0) {
                        ItemSequenceManager.this.doSchedule(activePlanItem, false);
                    }
                    ItemSequenceManager.this.updateResolvedCache();
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private static ItemCollection<IContributorAbsence> filterAbsences(ItemCollection<IContributorAbsence> absences, Timespan span) {
        ItemArrayList result = new ItemArrayList(absences.size());
        for (IContributorAbsence absence : absences) {
            if (!span.contains(absence.getEndDate()) && !span.contains(absence.getStartDate())) continue;
            result.add((Object)absence);
        }
        return result;
    }

    public void dispose() {
        this.fWriteLock.lock();
        try {
            this.fPlan = null;
            this.fResolvedItems = null;
            this.fUnresolvedItems = null;
            this.fSchedulingCache = null;
            this.fWorktimeScheduler = null;
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    public abstract IContributorHandle getOwner();

    public IWorkHoursDefinition getWorkHourDefinition() {
        return this.fWorktimeScheduler;
    }

    public Date getWorkStart() {
        this.fReadLock.lock();
        try {
            Date date = this.isDisposed() ? null : this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime(), OUTOFOFFICE);
            return date;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long calculateWorkTime(Date startDate, Date endDate) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0L;
            }
            if (startDate == null) return 0L;
            if (endDate == null) return 0L;
            if (endDate.before(startDate)) {
                return 0L;
            }
            long l = this.fWorktimeScheduler.calcutateWorkingTime(new Timespan(startDate, endDate));
            return l;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long calculateRemainingWorkTime(Date endDate) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0L;
            }
            Date referenceTime = this.fPlan.getReferenceTime();
            if (endDate == null) return 0L;
            if (endDate.before(referenceTime)) {
                return 0L;
            }
            long l = this.fWorktimeScheduler.calcutateWorkingTime(new Timespan(referenceTime, endDate));
            return l;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public void executeLocked(Runnable code) {
        this.fReadLock.lock();
        try {
            code.run();
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public Collection<IScheduleItem> getAbsences() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Collection bookedTimes = this.fWorktimeScheduler.getBookedTime((Collection)Arrays.asList(BookedTimeType.OUT_OF_OFFICE));
            ArrayList<IScheduleItem> result = new ArrayList<IScheduleItem>(bookedTimes.size());
            for (IBookedTime bookedTime : bookedTimes) {
                result.add(this.getScheduledItem(bookedTime));
            }
            ArrayList<IScheduleItem> arrayList = result;
            return arrayList;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public IScheduleItem getCurrentItem() {
        this.fReadLock.lock();
        try {
            block12: {
                if (this.isDisposed()) lbl-1000:
                // 3 sources

                {
                    return null;
                }
                nextWorkDay = this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime(), (Collection)Collections.EMPTY_SET);
                if (nextWorkDay.equals(this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime()))) break block12;
                var3_2 = this.fWorktimeScheduler.getBookedTime().iterator();
                do {
                    if (!var3_2.hasNext()) ** GOTO lbl-1000
                } while (Dates.compareTo((Date)(bookedTime = (IBookedTime)var3_2.next()).getStart(), (Date)nextWorkDay) > 0 || Dates.compareTo((Date)bookedTime.getEnd(), (Date)nextWorkDay) <= 0 || (scheduledItem = this.getScheduledItem(bookedTime)) == null);
                var6_8 = scheduledItem;
                return var6_8;
            }
            if (!this.fUnresolvedItems.isEmpty()) {
                var6_9 = this.fUnresolvedItems.get(0);
                return var6_9;
            }
            var3_3 = this.fWorktimeScheduler.getBookedTime().iterator();
            do {
                if (var3_3.hasNext()) ** break;
                ** continue;
            } while ((scheduledItem = this.getScheduledItem(bookedTime = (IBookedTime)var3_3.next())) == null || scheduledItem.isResolved());
            var6_10 = scheduledItem;
            return var6_10;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<IScheduleItem> getScheduleItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<PlanItem> allItems = new ArrayList<PlanItem>(this.fResolvedItems.size() + this.fUnresolvedItems.size());
            allItems.addAll(this.fResolvedItems);
            allItems.addAll(this.fUnresolvedItems);
            List<IScheduleItem> list = Collections.unmodifiableList(allItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getUnscheduledItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fUnschduledItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public Collection<PlanItem> getUnscheduledItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Collection<PlanItem> collection = Collections.unmodifiableCollection(this.fUnschduledItems);
            return collection;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getResolvedItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fResolvedItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<PlanItem> getResolvedItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<PlanItem> resolvedItems = new ArrayList<PlanItem>(this.fResolvedItems);
            Collections.reverse(resolvedItems);
            List<PlanItem> list = Collections.unmodifiableList(resolvedItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<PlanItem> getUnresolvedItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            List<PlanItem> list = Collections.unmodifiableList(this.fUnresolvedItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getUnresolvedItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fUnresolvedItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getIndexOf(PlanItem item) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                throw new NoSuchElementException();
            }
            boolean resolved = item.isResolved();
            List<PlanItem> list = resolved ? this.fResolvedItems : this.fUnresolvedItems;
            int result = list.indexOf(item);
            if (result == -1) {
                throw new NoSuchElementException();
            }
            int n = resolved ? -result - 1 : result;
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public PlanItem getAt(int chronologicalIndex) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return null;
            }
            if (chronologicalIndex >= 0) {
                PlanItem planItem = this.fUnresolvedItems.get(chronologicalIndex);
                return planItem;
            }
            PlanItem planItem = this.fResolvedItems.get(-chronologicalIndex - 1);
            return planItem;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlanItem findAt(Date when) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return null;
            }
            if (this.fUnresolvedItems.size() > 0) {
                PlanItem firstItem = this.fUnresolvedItems.get(0);
                if (this.fSchedulingCache.get(firstItem).getStart().after(when)) {
                    PlanItem planItem = firstItem;
                    return planItem;
                }
                PlanItem lastItem = this.fUnresolvedItems.get(this.fUnresolvedItems.size() - 1);
                if (this.fSchedulingCache.get(lastItem).getEnd().before(when)) {
                    PlanItem planItem = lastItem;
                    return planItem;
                }
            }
            int low = 0;
            int high = this.fUnresolvedItems.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                PlanItem value = this.fUnresolvedItems.get(mid);
                Timespan scheduledTime = this.fSchedulingCache.get(value);
                if (scheduledTime.contains(when)) {
                    PlanItem planItem = value;
                    return planItem;
                }
                if (scheduledTime.getStart().after(when)) {
                    high = mid - 1;
                    continue;
                }
                Assert.isTrue((scheduledTime.getEnd().equals(when) || scheduledTime.getEnd().before(when) ? 1 : 0) != 0);
                low = mid + 1;
            }
            return null;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public void unschedule(final PlanItem item, final boolean setAccepted) {
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                ItemSequenceManager.this.doUnschedule(item, setAccepted, true);
            }
        });
    }

    public void schedule(final PlanItem item) {
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return;
                }
                ItemSequenceManager.this.doSchedule(item, true);
            }
        });
    }

    public void schedule(final PlanItem item, final PlanItem before, final PlanItem after) {
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                Assert.isLegal((item != before && item != after && before != after ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return;
                }
                ItemSequenceManager.this.doScheduleSpecific(item, before, after, true);
            }
        });
    }

    public void schedule(final PlanItem item, final Date when) {
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                Assert.isLegal((!when.before(ItemSequenceManager.this.fPlan.getReferenceTime()) ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return;
                }
                ItemSequenceManager.this.removeOldScheduling(item);
                PlanItem candidate = ItemSequenceManager.this.findAt(when);
                PlanItem before = null;
                PlanItem after = null;
                if (candidate == null && ItemSequenceManager.this.fUnresolvedItems.size() > 0) {
                    before = (PlanItem)ItemSequenceManager.this.fUnresolvedItems.get(ItemSequenceManager.this.fUnresolvedItems.size() - 1);
                } else if (candidate != null) {
                    Timespan timespan = (Timespan)ItemSequenceManager.this.fSchedulingCache.get(candidate);
                    if (when.getTime() - timespan.getStart().getTime() < timespan.getEnd().getTime() - when.getTime()) {
                        after = candidate;
                    } else {
                        before = candidate;
                    }
                }
                if (after != null || before != null) {
                    ItemSequenceManager.this.doScheduleSpecific(item, before, after, true);
                } else {
                    ItemSequenceManager.this.doSchedule(item, true);
                }
            }
        });
    }

    protected void updateReferenceTime() {
        this.runWriteLocked(null, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.updateSchedulingCache(null);
                    ItemSequenceManager.this.updateResolvedCache();
                }
            }
        });
    }

    protected void updateWorkTime(final IContributorInfo info) {
        Assert.isNotNull((Object)info);
        this.runWriteLocked(null, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    IWorkLocationDefinition workLocation = info.getWorkLocation(ItemSequenceManager.this.getOwner());
                    ItemSequenceManager.this.fWorktimeScheduler = new WorktimeScheduler(workLocation);
                    Timespan plannedTimespan = ItemSequenceManager.this.fPlan.getPlannedTimespan();
                    if (plannedTimespan != null) {
                        if (plannedTimespan.getEnd() != null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(plannedTimespan.getEnd().getTime());
                            calendar.add(2, 2);
                            plannedTimespan = new Timespan(plannedTimespan.getStart(), new Date(calendar.getTimeInMillis()));
                        }
                        ItemCollection absences = info.getAbsences(ItemSequenceManager.this.getOwner());
                        absences = ItemSequenceManager.filterAbsences((ItemCollection<IContributorAbsence>)absences, plannedTimespan);
                        for (IContributorAbsence absence : absences) {
                            ItemSequenceManager.this.fWorktimeScheduler.addBookedTime((IBookedTime)new OutOfOfficeItem(ItemSequenceManager.this.fPlan, absence, ItemSequenceManager.this));
                        }
                    }
                    ItemSequenceManager.this.updateResolvedCache();
                    ItemSequenceManager.this.updateSchedulingCache(null);
                }
            }
        });
    }

    protected Timespan getScheduledTime(IScheduleItem item) {
        if (item instanceof PlanItem) {
            PlanItem planItem = (PlanItem)item;
            if (!this.isItemIncluded(planItem)) {
                return null;
            }
            this.fReadLock.lock();
            try {
                Timespan timespan = this.isDisposed() ? null : this.fSchedulingCache.get(planItem);
                return timespan;
            }
            finally {
                this.fReadLock.unlock();
            }
        }
        if (item instanceof OutOfOfficeItem) {
            OutOfOfficeItem outOfOfficeItem = (OutOfOfficeItem)item;
            return new Timespan(outOfOfficeItem.getStart(), outOfOfficeItem.getEnd());
        }
        throw new IllegalArgumentException();
    }

    protected void itemAdded(final PlanItem item) {
        if (!this.isItemIncluded(item)) {
            return;
        }
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    if (item.isResolved()) {
                        ItemSequenceManager.this.fResolvedItems.add(item);
                        ItemSequenceManager.this.updateResolvedCache();
                    } else {
                        ItemSequenceManager.this.doAddToScheduling(item);
                        ItemSequenceManager.this.updateSchedulingCache(item);
                    }
                }
            }
        });
    }

    protected void itemRemoved(final PlanItem item) {
        this.runWriteLocked(item, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.removeOldScheduling(item);
                }
            }
        });
    }

    protected void processWorkItemChangeEvent(final PlanItem planItem, final WorkItemChangeEvent event) {
        this.runWriteLocked(planItem, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    IWorkflowInfo wfInfo;
                    ChangeDetails targetChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.TARGET_PROPERTY, ChangeDetails.class);
                    if (targetChange != null) {
                        boolean isOldTargetIncluded = ItemSequenceManager.this.isTargetIncluded((IIterationHandle)targetChange.getOldValue());
                        boolean isNewTargetIncluded = ItemSequenceManager.this.isTargetIncluded((IIterationHandle)targetChange.getNewValue());
                        if (isOldTargetIncluded && !isNewTargetIncluded) {
                            ItemSequenceManager.this.itemRemoved(planItem);
                            return;
                        }
                        if (!isOldTargetIncluded && isNewTargetIncluded) {
                            ItemSequenceManager.this.itemAdded(planItem);
                            return;
                        }
                    }
                    if (!ItemSequenceManager.this.isItemIncluded(planItem)) {
                        return;
                    }
                    boolean schedulingChanged = false;
                    PlanItem firstItemToRefresh = planItem;
                    Assert.isLegal((boolean)planItem.getWorkItemHandle().sameItemId((IItemHandle)event.getWorkItem()));
                    IWorkItem workItem = event.getWorkItem();
                    if (event.affects(IWorkItem.STATE_PROPERTY) && (wfInfo = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workItem)) != null) {
                        ChangeDetails stateChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.STATE_PROPERTY);
                        Identifier<IState> oldState = WorkItems.createState((String)stateChange.getOldValue());
                        Identifier<IState> newState = WorkItems.createState((String)stateChange.getNewValue());
                        if (oldState == null) {
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 5, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            ItemSequenceManager.this.fResolvedItems.remove(planItem);
                            ItemSequenceManager.this.doUnschedule(planItem, false, true);
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 4, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 2, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            ItemSequenceManager.this.removeOldScheduling(planItem);
                            ItemSequenceManager.this.fResolvedItems.add(planItem);
                            schedulingChanged = true;
                        }
                    }
                    if (event.affects(WorkItem.DURATION_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY) || event.affects(WorkItem.TIME_SPENT_PROPERTY) || event.affects(IWorkItem.DUE_DATE_PROPERTY)) {
                        schedulingChanged = true;
                    }
                    if (event.affects(WorkItem.START_DATE_PROPERTY)) {
                        schedulingChanged = true;
                        ItemSequenceManager.this.removeOldScheduling(planItem);
                        ItemSequenceManager.this.doAddToScheduling(planItem);
                        firstItemToRefresh = null;
                    }
                    if (event.affects(WorkItem.SEQUENCE_VALUE_PROPERTY)) {
                        int insertionIndex;
                        int oldIndex = ItemSequenceManager.this.fUnresolvedItems.indexOf(planItem);
                        if (oldIndex != -1) {
                            ItemSequenceManager.this.fUnresolvedItems.remove(planItem);
                            schedulingChanged = true;
                        }
                        if (ItemSequenceManager.this.fUnschduledItems.remove(planItem)) {
                            Assert.isTrue((oldIndex == -1 ? 1 : 0) != 0);
                            schedulingChanged = true;
                        }
                        schedulingChanged |= (insertionIndex = ItemSequenceManager.this.doAddToScheduling(planItem)) != -1;
                        if (firstItemToRefresh != null && oldIndex != -1 && (insertionIndex == -1 || oldIndex < insertionIndex)) {
                            PlanItem planItem2 = firstItemToRefresh = oldIndex < ItemSequenceManager.this.fUnresolvedItems.size() ? (PlanItem)ItemSequenceManager.this.fUnresolvedItems.get(oldIndex) : null;
                        }
                    }
                    if (schedulingChanged) {
                        ItemSequenceManager.this.updateSchedulingCache(firstItemToRefresh);
                        ItemSequenceManager.this.updateResolvedCache();
                    }
                }
            }
        });
    }

    protected void processWorkItemActivationEvent(final PlanItem planItem, final WorkItemActivationEvent event, IProgressMonitor monitor) {
        if (!this.isItemIncluded(planItem)) {
            return;
        }
        this.runWriteLocked(planItem, new Runnable(){

            public void run() {
                if (!ItemSequenceManager.this.isDisposed() && event.getType() == 0) {
                    PlanItem firstItem;
                    PlanItem planItem2 = firstItem = ItemSequenceManager.this.fUnresolvedItems.size() > 0 ? (PlanItem)ItemSequenceManager.this.fUnresolvedItems.get(0) : null;
                    if (firstItem != planItem) {
                        ItemSequenceManager.this.doScheduleSpecific(planItem, null, firstItem, false);
                    }
                }
            }
        });
    }

    protected abstract Collection<PlanItem> fetchPlanItems();

    protected ResolvedPlan getPlan() {
        return this.fPlan;
    }

    private IScheduleItem getScheduledItem(IBookedTime bookedTime) {
        if (bookedTime instanceof IScheduleItem) {
            return (IScheduleItem)bookedTime;
        }
        if (bookedTime instanceof BookedPlanItemTime) {
            return ((BookedPlanItemTime)bookedTime).getPlanItem();
        }
        return null;
    }

    private void doUnschedule(PlanItem subject, boolean setAccepted, boolean saveSequenceValue) {
        SequenceValue sequenceValue;
        SequenceValue sequenceValue2 = sequenceValue = setAccepted ? SequenceValue.ACCEPTED : SequenceValue.NEW;
        if (this.isItemIncluded(subject)) {
            this.removeOldScheduling(subject);
            if (subject.getFixedStartDate() == null) {
                this.fUnschduledItems.add(subject);
            } else {
                this.doAddFixScheduledItem(subject);
            }
        }
        subject.setSequenceValue(sequenceValue, saveSequenceValue);
        this.updateSchedulingCache(null);
    }

    private void doSchedule(PlanItem planItem, boolean saveSequenceValue) {
        this.removeOldScheduling(planItem);
        PlanItem before = null;
        PlanItem after = null;
        if (planItem.getWorkItemHandle().sameItemId((IItemHandle)this.fWorkItemActivationManager.getActiveWorkItem())) {
            if (this.fUnresolvedItems.size() > 0) {
                before = null;
                after = this.fUnresolvedItems.get(0);
            }
        } else {
            int searchPos = this.fUnresolvedItems.size();
            if (planItem.getDueDate() != null) {
                while (searchPos > 0) {
                    Timespan scheduledTime = this.fSchedulingCache.get(this.fUnresolvedItems.get(searchPos - 1));
                    if (scheduledTime.getEnd().after(planItem.getDueDate())) break;
                    --searchPos;
                }
            }
            while (searchPos > 0) {
                PlanItem scheduledItem = this.fUnresolvedItems.get(searchPos - 1);
                double v = 0.0;
                v += (double)Literals.compare(planItem.getPriority(), scheduledItem.getPriority());
                if ((v += (double)Literals.compare(planItem.getSeverity(), scheduledItem.getSeverity())) < 0.0) break;
                --searchPos;
            }
            if (searchPos > 0) {
                before = this.fUnresolvedItems.get(searchPos - 1);
            }
            if (searchPos < this.fUnresolvedItems.size()) {
                after = this.fUnresolvedItems.get(searchPos);
            }
        }
        this.doScheduleSpecific(planItem, before, after, saveSequenceValue);
    }

    private void doScheduleSpecific(PlanItem subject, PlanItem before, PlanItem after, boolean saveSequenceValue) {
        int beforeIndex;
        this.removeOldScheduling(subject);
        Assert.isLegal((before == null || before.getPlan() == subject.getPlan() ? 1 : 0) != 0);
        Assert.isLegal((after == null || after.getPlan() == subject.getPlan() ? 1 : 0) != 0);
        if (after != null && before == null) {
            int afterIndex = this.fUnresolvedItems.indexOf(after);
            if (afterIndex > 0) {
                before = this.fUnresolvedItems.get(afterIndex - 1);
            }
        } else if (before != null && after == null && (beforeIndex = this.fUnresolvedItems.indexOf(before)) != -1 && beforeIndex < this.fUnresolvedItems.size() - 1) {
            after = this.fUnresolvedItems.get(beforeIndex + 1);
        }
        Double beforeValue = before != null ? before.getSequenceValue().getValue() : null;
        Double afterValue = after != null ? after.getSequenceValue().getValue() : null;
        double newValue = 0.0;
        int insertAfter = 0;
        if (beforeValue != null && afterValue != null) {
            newValue = beforeValue + (afterValue - beforeValue) / 2.0;
            insertAfter = this.fUnresolvedItems.indexOf(before) + 1;
        } else if (beforeValue == null && afterValue != null) {
            newValue = afterValue - 1.0;
            insertAfter = 0;
        } else if (beforeValue != null && afterValue == null) {
            newValue = beforeValue + 1.0;
            insertAfter = this.fUnresolvedItems.indexOf(before) + 1;
        }
        this.fUnresolvedItems.add(insertAfter, subject);
        subject.setSequenceValue(new SequenceValue(newValue), saveSequenceValue);
        this.updateSchedulingCache(subject);
    }

    private void updateSchedulingCache(PlanItem firstItem) {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            Timespan oldValue;
            int i;
            for (BookedPlanItemTime bookedTime : this.fFixScheduledItems.values()) {
                PlanItem planItem = bookedTime.getPlanItem();
                Timespan oldValue2 = this.fSchedulingCache.put(planItem, bookedTime);
                if (oldValue2 != null && oldValue2.equals((Object)bookedTime)) continue;
                builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue2, (Object)bookedTime);
                firstItem = null;
            }
            int n = i = firstItem != null ? this.fUnresolvedItems.indexOf(firstItem) : 0;
            if (i == -1) {
                i = 0;
            }
            Timespan predecessor = i > 0 ? this.fSchedulingCache.get(this.fUnresolvedItems.get(i - 1)) : null;
            Date nextStart = predecessor != null ? predecessor.getEnd() : this.getSchedulingReferenceTime();
            while (i < this.fUnresolvedItems.size()) {
                Timespan newValue;
                PlanItem planItem = this.fUnresolvedItems.get(i);
                oldValue = this.fSchedulingCache.put(planItem, newValue = this.fWorktimeScheduler.calculateTimeSpan(nextStart, planItem.getDuration().getDuration(), true));
                if (oldValue == null || !oldValue.equals((Object)newValue)) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, newValue);
                }
                nextStart = newValue.getEnd();
                ++i;
            }
            for (PlanItem planItem : this.fUnschduledItems) {
                oldValue = this.fSchedulingCache.put(planItem, null);
                if (oldValue == null) continue;
                builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, null);
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private void updateResolvedCache() {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            Collections.sort(this.fResolvedItems, new Comparator<PlanItem>(){

                @Override
                public int compare(PlanItem o1, PlanItem o2) {
                    Date t1 = o1.getResolutionDate();
                    Date t2 = o2.getResolutionDate();
                    if (t1 != null && t2 != null) {
                        return Dates.compareTo((Date)t1, (Date)t2);
                    }
                    if (t1 == null && t2 == null) {
                        return o1.getSequenceValue().compareTo(o2.getSequenceValue());
                    }
                    return (t1 == null ? 1 : 0) - (t2 == null ? 1 : 0);
                }
            });
            Date thisItemEndTime = this.fPlan.getReferenceTime();
            int i = this.fResolvedItems.size() - 1;
            while (i >= 0) {
                PlanItem previousItem;
                Date previousItemResolutionDate;
                PlanItem planItem = this.fResolvedItems.get(i);
                Date resolutionDate = planItem.getResolutionDate();
                if (resolutionDate != null) {
                    thisItemEndTime = resolutionDate;
                }
                Timespan newValue = this.fWorktimeScheduler.calculateTimeSpan(thisItemEndTime, planItem.getDuration().getDuration(), false);
                if (i > 0 && (previousItemResolutionDate = (previousItem = this.fResolvedItems.get(i - 1)).getResolutionDate()) != null && newValue.getStart().before(previousItemResolutionDate)) {
                    newValue = new Timespan(previousItemResolutionDate, thisItemEndTime);
                }
                Assert.isNotNull((Object)newValue);
                Timespan oldValue = this.fSchedulingCache.put(planItem, newValue);
                if (oldValue == null || !oldValue.equals((Object)newValue)) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, newValue);
                }
                thisItemEndTime = newValue.getEnd();
                --i;
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private void removeOldScheduling(PlanItem planItem) {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            int scheduledIndex = this.fUnresolvedItems.indexOf(planItem);
            if (scheduledIndex != -1) {
                Assert.isTrue((!this.fUnschduledItems.contains(planItem) ? 1 : 0) != 0);
                this.fUnresolvedItems.remove(planItem);
                Timespan oldValue = this.fSchedulingCache.remove(planItem);
                if (oldValue != null) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, null);
                }
                if (scheduledIndex < this.fUnresolvedItems.size()) {
                    this.updateSchedulingCache(this.fUnresolvedItems.get(scheduledIndex));
                }
            } else if (this.fUnschduledItems.remove(planItem)) {
                Assert.isTrue((!this.fFixScheduledItems.containsKey(planItem) ? 1 : 0) != 0);
            } else {
                BookedPlanItemTime bookedTime = this.fFixScheduledItems.remove(planItem);
                if (bookedTime != null) {
                    this.fWorktimeScheduler.removeBookedTime((IBookedTime)bookedTime);
                }
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private int doAddToScheduling(PlanItem planItem) {
        int result = -1;
        if (planItem.getFixedStartDate() != null) {
            this.doAddFixScheduledItem(planItem);
        } else if (planItem.getSequenceValue().isScheduled()) {
            result = Collections.binarySearch(this.fUnresolvedItems, planItem, this.fUnresolvedSequenceComparator);
            if (result < 0) {
                result = -result - 1;
            }
            result = Math.min(this.fUnresolvedItems.size(), result);
            this.fUnresolvedItems.add(result, planItem);
        } else {
            this.fUnschduledItems.add(planItem);
        }
        return result;
    }

    private void doAddFixScheduledItem(PlanItem planItem) {
        Timestamp startDate = planItem.getFixedStartDate();
        Assert.isNotNull((Object)startDate);
        long duration = planItem.getDuration().longValue();
        Timespan timespan = this.fWorktimeScheduler.calculateTimeSpan((Date)startDate, duration, true, OUTOFOFFICE);
        BookedPlanItemTime bookedTime = new BookedPlanItemTime(startDate, timespan.getEnd(), planItem);
        this.fFixScheduledItems.put(planItem, bookedTime);
        this.fWorktimeScheduler.addBookedTime((IBookedTime)bookedTime);
    }

    private Date getSchedulingReferenceTime() {
        Date now = this.fPlan.getReferenceTime();
        if (this.fPlan.getStartDate() != null && now.before(this.fPlan.getStartDate())) {
            now = this.fPlan.getStartDate();
        }
        return now;
    }

    private boolean changedToState(IWorkflowInfo info, int stateGroups, Identifier<IState> oldState, Identifier<IState> newState) {
        return !info.stateGroupContains(stateGroups, oldState) && info.stateGroupContains(stateGroups, newState);
    }

    private boolean isItemIncluded(PlanItem item) {
        return this.isTargetIncluded((IIterationHandle)item.getTarget());
    }

    private boolean isTargetIncluded(IIterationHandle target) {
        return target != null && this.fPlannedIterations.contains((Object)target);
    }

    private boolean isDisposed() {
        return this.fPlan == null;
    }

    private void runWriteLocked(PlanItem planItem, final Runnable code) {
        IWorkItemHandle workItemHandle;
        IWorkItemHandle iWorkItemHandle = workItemHandle = planItem != null ? planItem.getWorkItemHandle() : null;
        if (workItemHandle != null) {
            WorkItemWorkingCopyImpl workItemWorkingCopy = (WorkItemWorkingCopyImpl)planItem.getWorkItemWorkingCopy(false);
            workItemWorkingCopy.run(this.fWriteLock, (WorkingCopyRunnable)new WorkingCopyRunnable<Void>(){
                IWorkItemWorkingCopyManager workingCopyManager = null;
                boolean gotDeltaBuilder = false;
                boolean gotCompoundChange = false;
                ResolvedPlan plan = null;

                public Void run() {
                    if (!ItemSequenceManager.this.isDisposed()) {
                        this.plan = ItemSequenceManager.this.fPlan;
                        this.plan.connectDeltaBuilder();
                        this.gotDeltaBuilder = true;
                        this.workingCopyManager = ItemSequenceManager.this.fPlan.getWorkingCopyManager(true);
                        this.workingCopyManager.beginCompoundWorkItemChange(workItemHandle);
                        this.gotCompoundChange = true;
                        code.run();
                    }
                    return null;
                }

                public void runFinally() {
                    try {
                        if (this.gotCompoundChange) {
                            this.workingCopyManager.endCompoundWorkItemChange(workItemHandle);
                        }
                    }
                    finally {
                        if (this.gotDeltaBuilder) {
                            this.plan.disconnectDeltaBuilder();
                        }
                    }
                }
            });
        } else {
            boolean gotDeltaBuilder = false;
            ResolvedPlan plan = null;
            this.fWriteLock.lock();
            try {
                if (!this.isDisposed()) {
                    plan = this.fPlan;
                    plan.connectDeltaBuilder();
                    gotDeltaBuilder = true;
                    code.run();
                }
            }
            finally {
                this.fWriteLock.unlock();
                if (gotDeltaBuilder) {
                    plan.disconnectDeltaBuilder();
                }
            }
        }
    }

    public IItemSequenceManagerTestingAccessor getTestingAccessor() {
        return new IItemSequenceManagerTestingAccessor(){

            public WorktimeScheduler getWorktimeScheduler() {
                return ItemSequenceManager.this.fWorktimeScheduler;
            }
        };
    }

    private static class BookedPlanItemTime
    extends Timespan
    implements IBookedTime {
        private final PlanItem fPlanItem;

        public BookedPlanItemTime(Date start, Date end, PlanItem planItem) {
            super(start, end);
            this.fPlanItem = planItem;
        }

        public BookedTimeType getType() {
            return FIX_SCHEDULED_ITEM;
        }

        public PlanItem getPlanItem() {
            return this.fPlanItem;
        }
    }
}

