/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.util;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class NonFlatWidgetFactory {
    protected static int DEFAULT_COMPOSITE_GRID_FLAG = 1808;

    public static Composite createComposite(Composite parent, int numColumns, int numberSpan, boolean margin, boolean border) {
        return NonFlatWidgetFactory.createComposite(parent, numColumns, numberSpan, margin, border, DEFAULT_COMPOSITE_GRID_FLAG);
    }

    public static Composite createComposite(Composite parent, int numColumns, int numberSpan, boolean margin, boolean border, int gridDataConstants) {
        int style = border ? 2048 : 0;
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        if (!margin) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData(gridDataConstants);
        data.horizontalSpan = numberSpan;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Label createLabel(Composite parent, String text) {
        return NonFlatWidgetFactory.createLabel(parent, text, -1);
    }

    public static Label createLabel(Composite parent, String text, int gridStyle) {
        Label label = new Label(parent, 0);
        label.setText(text);
        NonFlatWidgetFactory.setGridStyle((Control)label, gridStyle);
        return label;
    }

    public static Text createText(Composite parent, boolean multiLine) {
        int style = multiLine ? 2050 : 2052;
        return NonFlatWidgetFactory.createText(parent, style);
    }

    public static Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        return text;
    }

    public static Text createText(Composite parent, boolean multiLine, int gridStyle) {
        int style = multiLine ? 2050 : 2052;
        return NonFlatWidgetFactory.createText(parent, style, gridStyle);
    }

    public static Text createText(Composite parent, int style, int gridStyle) {
        Text text = new Text(parent, style);
        NonFlatWidgetFactory.setGridStyle((Control)text, gridStyle);
        return text;
    }

    public static Tree createTree(Composite parent, int style) {
        return new Tree(parent, style);
    }

    public static Button createPushButton(Composite parent, String title) {
        Button button = new Button(parent, 8);
        button.setText(title);
        return button;
    }

    public static Button createCheckButton(Composite parent, String title) {
        Button button = new Button(parent, 32);
        button.setText(title);
        return button;
    }

    public static Combo createCombo(Composite parent, boolean isReadOnly) {
        return NonFlatWidgetFactory.createCombo(parent, isReadOnly, null);
    }

    public static Combo createCombo(Composite parent, boolean isReadOnly, int gridStyle) {
        Combo combo = NonFlatWidgetFactory.createCombo(parent, isReadOnly, null);
        NonFlatWidgetFactory.setGridStyle((Control)combo, gridStyle);
        return combo;
    }

    public static Combo createCombo(Composite parent, boolean isReadOnly, String[] values) {
        int addStyle = isReadOnly ? 8 : 0;
        Combo combo = new Combo(parent, 0x800 | addStyle);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                combo.add(values[i]);
                ++i;
            }
        }
        return combo;
    }

    public static Combo createCombo(Composite parent, boolean isReadOnly, String[] values, int gridStyle) {
        Combo combo = NonFlatWidgetFactory.createCombo(parent, isReadOnly, values);
        NonFlatWidgetFactory.setGridStyle((Control)combo, gridStyle);
        return combo;
    }

    public static CheckboxTableViewer createCheckboxTableViewer(Composite parent) {
        Table table = NonFlatWidgetFactory.createTable(parent, true);
        return new CheckboxTableViewer(table);
    }

    public static Table createTable(Composite parent, boolean isCheck) {
        int style = isCheck ? 2080 : 2048;
        Table table = new Table(parent, style);
        new TableColumn(table, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        return table;
    }

    protected static void setGridStyle(Control control, int gridStyle) {
        if (gridStyle != -1 && control != null) {
            control.setLayoutData((Object)new GridData(gridStyle));
        }
    }
}

