/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.util;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaUtils {
    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaUtils.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = JavaUtils.findType(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            ICompilationUnit unit = cus[i];
            IType type = JavaUtils.findType(unit, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (JavaUtils.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }
}

